/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.Random;
import ptolemy.actor.lib.Source;
import ptolemy.data.BooleanToken;
import ptolemy.data.LongToken;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.SharedParameter;

public abstract class RandomSource
extends Source {
    public SharedParameter resetOnEachRun;
    public SharedParameter seed = new SharedParameter((NamedObj)this, "seed", RandomSource.class, "0L");
    protected long _generatorSeed = 0L;
    protected boolean _needNew = false;
    protected boolean _needNewGenerator = true;
    protected Random _random;

    public RandomSource(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.seed.setTypeEquals(BaseType.LONG);
        this.resetOnEachRun = new SharedParameter((NamedObj)this, "resetOnEachRun", RandomSource.class, "false");
        this.resetOnEachRun.setTypeEquals(BaseType.BOOLEAN);
        new SingletonParameter(this.trigger, "_showName").setToken(BooleanToken.TRUE);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.seed) {
            long seedValue = ((LongToken)this.seed.getToken()).longValue();
            if (seedValue != this._generatorSeed) {
                this._needNewGenerator = true;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        RandomSource newObject = (RandomSource)super.clone(workspace);
        newObject._needNewGenerator = true;
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this._needNewGenerator) {
            this._createGenerator();
        }
        if (this._needNew) {
            this._generateRandomNumber();
            this._needNew = false;
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this._random == null || ((BooleanToken)this.resetOnEachRun.getToken()).booleanValue()) {
            this._createGenerator();
        }
        this._needNew = true;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._needNew = true;
        return super.postfire();
    }

    protected void _createGenerator() throws IllegalActionException {
        long seedValue;
        this._generatorSeed = seedValue = ((LongToken)this.seed.getToken()).longValue();
        seedValue = seedValue == 0L ? System.currentTimeMillis() + (long)this.hashCode() : (seedValue += (long)this.getFullName().hashCode());
        this._random = new Random(seedValue);
        this._needNewGenerator = false;
        this._needNew = true;
    }

    protected abstract void _generateRandomNumber() throws IllegalActionException;
}

