/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.SequenceSource;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class Pulse
extends SequenceSource {
    public Parameter indexes = new Parameter(this, "indexes");
    public Parameter repeat;
    public Parameter values;
    private int _iterationCount = 0;
    private int _indexColCount = 0;
    private transient int[] _indexes;
    private Token _zero;
    private boolean _match = false;
    private boolean _repeatFlag;

    public Pulse(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.indexes.setExpression("{0, 1}");
        this.indexes.setTypeEquals(new ArrayType(BaseType.INT));
        this.attributeChanged(this.indexes);
        this.values = new Parameter(this, "values");
        this.values.setExpression("{1, 0}");
        this.repeat = new Parameter((NamedObj)this, "repeat", new BooleanToken(false));
        this.repeat.setTypeEquals(BaseType.BOOLEAN);
        this.attributeChanged(this.repeat);
        this.output.setTypeAtLeast(ArrayType.elementType(this.values));
        this.attributeChanged(this.values);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.indexes) {
            ArrayToken indexesValue = (ArrayToken)this.indexes.getToken();
            this._indexes = new int[indexesValue.length()];
            int previous = 0;
            for (int i = 0; i < indexesValue.length(); ++i) {
                this._indexes[i] = ((IntToken)indexesValue.getElement(i)).intValue();
                if (this._indexes[i] < previous) {
                    throw new IllegalActionException((Nameable)this, "Value of indexes is not nondecreasing and nonnegative.");
                }
                previous = this._indexes[i];
            }
        } else if (attribute == this.values) {
            try {
                ArrayToken valuesArray = (ArrayToken)this.values.getToken();
                Token prototype = valuesArray.getElement(0);
                this._zero = prototype.zero();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new IllegalActionException((Nameable)this, "Cannot set values to an empty array.");
            }
            catch (ClassCastException ex) {
                throw new IllegalActionException((Nameable)this, "Cannot set values to something that is not an array: " + this.values.getToken());
            }
        } else if (attribute == this.repeat) {
            this._repeatFlag = ((BooleanToken)this.repeat.getToken()).booleanValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Pulse newObject = (Pulse)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.values));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int currentIndex = 0;
        ArrayToken val = (ArrayToken)this.values.getToken();
        if (this._indexColCount < this._indexes.length) {
            if (val.length() != this._indexes.length) {
                throw new IllegalActionException((Nameable)this, "Parameters values and indexes have different lengths.  Length of values = " + val.length() + ". Length of indexes = " + this._indexes.length + ".");
            }
            currentIndex = this._indexes[this._indexColCount];
            if (this._iterationCount == currentIndex) {
                this.output.send(0, val.getElement(this._indexColCount));
                this._match = true;
                return;
            }
        } else if (this._repeatFlag) {
            this._iterationCount = 0;
            this._indexColCount = 0;
            currentIndex = this._indexes[this._indexColCount];
            if (this._iterationCount == currentIndex) {
                this.output.send(0, val.getElement(this._indexColCount));
                this._match = true;
            }
            return;
        }
        this.output.send(0, this._zero);
        this._match = false;
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._iterationCount = 0;
        this._indexColCount = 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._iterationCount <= this._indexes[this._indexes.length - 1]) {
            ++this._iterationCount;
        }
        if (this._match) {
            ++this._indexColCount;
        }
        return super.postfire();
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        this._match = false;
        return super.prefire();
    }
}

