/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class MaxIndex
extends Transformer {
    public MaxIndex(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.input.setMultiport(true);
        this.output.setTypeEquals(BaseType.INT);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        double maxValue = Double.NEGATIVE_INFINITY;
        int maxIndex = -1;
        boolean foundFirst = false;
        for (int i = 0; i < this.input.getWidth(); ++i) {
            if (!this.input.hasToken(i)) continue;
            double val = ((DoubleToken)this.input.get(i)).doubleValue();
            if (foundFirst) {
                if (!(maxValue < val)) continue;
                maxValue = val;
                maxIndex = i;
                continue;
            }
            maxValue = val;
            maxIndex = i;
            foundFirst = true;
        }
        if (foundFirst) {
            this.output.send(0, new IntToken(maxIndex));
        }
    }
}

