/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import ptolemy.actor.Director;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class DelayStart
extends TypedAtomicActor {
    public StringParameter startTime = new StringParameter(this, "startTime");

    public DelayStart(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.startTime.setExpression("12:00 pm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize() throws IllegalActionException {
        DateFormat dateFormat = DateFormat.getTimeInstance(3);
        try {
            while (true) {
                Date date = dateFormat.parse(this.startTime.stringValue());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                if (calendar.get(1) == 1970) {
                    Calendar now = Calendar.getInstance();
                    calendar.set(1, now.get(1));
                    calendar.set(5, now.get(5));
                    calendar.set(2, now.get(2));
                    date = calendar.getTime();
                }
                if (this._debugging) {
                    this._debug("Delaying start until: " + date);
                }
                long time = date.getTime();
                Director director = this.getDirector();
                long current = System.currentTimeMillis();
                if (time <= current) break;
                Director director2 = director;
                synchronized (director2) {
                    try {
                        this._workspace.wait(director, time - current);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (ParseException e) {
            throw new IllegalActionException((Nameable)this, "Invalid startTime: " + this.startTime.stringValue());
        }
        super.initialize();
    }
}

