/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import java.util.List;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class ArrayToElements
extends Transformer {
    public ArrayToElements(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(ArrayType.elementType(this.input));
        this.output.setMultiport(true);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArrayToElements newObject = (ArrayToElements)super.clone(workspace);
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType(newObject.input));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            ArrayToken token = (ArrayToken)this.input.get(0);
            int size = token.length();
            int min = Math.min(size, this.output.getWidth());
            Token[] elements = token.arrayValue();
            for (int i = 0; i < min; ++i) {
                this.output.send(i, elements[i]);
            }
        }
    }

    @Override
    public List typeConstraintList() {
        return this.output.typeConstraintList();
    }
}

