/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.SingletonAttribute;

public class ArrayLevelCrossing
extends TypedAtomicActor {
    public Parameter above;
    public TypedIOPort array;
    public Parameter forwards;
    public TypedIOPort output;
    public StringParameter scale;
    public PortParameter start = new PortParameter(this, "start");
    public Parameter threshold;

    public ArrayLevelCrossing(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.start.setExpression("0");
        this.start.setTypeEquals(BaseType.INT);
        new SingletonParameter(this.start.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.forwards = new Parameter(this, "forwards");
        this.forwards.setExpression("true");
        this.forwards.setTypeEquals(BaseType.BOOLEAN);
        this.threshold = new Parameter(this, "threshold");
        this.threshold.setExpression("0.0");
        this.threshold.setTypeEquals(BaseType.DOUBLE);
        this.above = new Parameter(this, "above");
        this.above.setExpression("false");
        this.above.setTypeEquals(BaseType.BOOLEAN);
        this.scale = new StringParameter(this, "scale");
        this.scale.setExpression("absolute");
        this.scale.addChoice("absolute");
        this.scale.addChoice("relative linear");
        this.scale.addChoice("relative amplitude decibels");
        this.scale.addChoice("relative power decibels");
        this.array = new TypedIOPort(this, "array", true, false);
        new SingletonAttribute(this.array, "_showName");
        this.output = new TypedIOPort(this, "output", false, true);
        this.array.setTypeEquals(new ArrayType(BaseType.DOUBLE));
        this.output.setTypeEquals(BaseType.INT);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.start.update();
        if (this.array.hasToken(0)) {
            ArrayToken inputArray = (ArrayToken)this.array.get(0);
            int inputSize = inputArray.length();
            int startValue = ((IntToken)this.start.getToken()).intValue();
            if (startValue >= inputSize || startValue < 0) {
                throw new IllegalActionException((Nameable)this, "start is out of range: " + startValue);
            }
            int increment = -1;
            if (((BooleanToken)this.forwards.getToken()).booleanValue()) {
                increment = 1;
            }
            double reference = ((DoubleToken)inputArray.getElement(startValue)).doubleValue();
            double thresholdValue = ((DoubleToken)this.threshold.getToken()).doubleValue();
            String scaleValue = this.scale.stringValue();
            boolean aboveValue = ((BooleanToken)this.above.getToken()).booleanValue();
            if (scaleValue.equals("relative amplitude decibels")) {
                thresholdValue = aboveValue ? reference * Math.pow(10.0, thresholdValue / 20.0) : reference * Math.pow(10.0, -thresholdValue / 20.0);
            } else if (scaleValue.equals("relative power decibels")) {
                thresholdValue = aboveValue ? reference * Math.pow(10.0, thresholdValue / 10.0) : reference * Math.pow(10.0, -thresholdValue / 10.0);
            } else if (scaleValue.equals("relative linear")) {
                thresholdValue = aboveValue ? reference + thresholdValue : reference - thresholdValue;
            }
            int bin = -1;
            for (int i = startValue; i < inputSize && i >= 0; i += increment) {
                double currentValue = ((DoubleToken)inputArray.getElement(i)).doubleValue();
                if (aboveValue) {
                    if (!(currentValue > thresholdValue)) continue;
                    bin = i;
                    break;
                }
                if (!(currentValue < thresholdValue)) continue;
                bin = i;
                break;
            }
            this.output.send(0, new IntToken(bin));
        }
    }
}

