/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui.style;

import ptolemy.actor.gui.PtolemyQuery;
import ptolemy.actor.gui.style.ParameterEditorStyle;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class CheckBoxStyle
extends ParameterEditorStyle {
    public CheckBoxStyle() {
    }

    public CheckBoxStyle(Workspace workspace) {
        super(workspace);
    }

    public CheckBoxStyle(Parameter container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public boolean acceptable(Settable param) {
        if (!(param instanceof Parameter)) {
            return false;
        }
        try {
            Token current = ((Parameter)param).getToken();
            return current instanceof BooleanToken;
        }
        catch (IllegalActionException ex) {
            return false;
        }
    }

    @Override
    public void addEntry(PtolemyQuery query) throws IllegalActionException {
        String name = this.getContainer().getName();
        if (!(this.getContainer() instanceof Parameter)) {
            throw new IllegalActionException((Nameable)this.getContainer(), "CheckBoxStyle can only be contained by instances of Parameter.");
        }
        Parameter param = (Parameter)this.getContainer();
        Token current = param.getToken();
        if (!(current instanceof BooleanToken)) {
            throw new IllegalActionException((Nameable)this.getContainer(), "CheckBoxStyle can only be used for boolean-valued parameters");
        }
        query.addCheckBox(name, param.getDisplayName(), ((BooleanToken)current).booleanValue());
        query.attachParameter(param, name);
    }

    @Override
    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        if (container != null && !(container instanceof Parameter)) {
            throw new IllegalActionException((Nameable)this, container, "CheckBoxStyle can only be contained by a Parameter.");
        }
        super.setContainer(container);
    }
}

