/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import diva.gui.GUIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import ptolemy.actor.gui.Placeable;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFormatter;
import ptolemy.util.StringUtilities;

public class PlotTableauFrame
extends TableauFrame
implements Printable {
    public final PlotBox plot;
    protected JMenu _editMenu;
    protected JMenu _specialMenu;
    protected File _directory = null;
    protected File _file = null;

    public PlotTableauFrame() {
        this((Tableau)null);
    }

    public PlotTableauFrame(Tableau tableau) {
        this(tableau, new Plot());
    }

    public PlotTableauFrame(Tableau tableau, PlotBox plotBox) {
        this(tableau, plotBox, null);
    }

    public PlotTableauFrame(Tableau tableau, PlotBox plotBox, Placeable placeable) {
        super(tableau, null, placeable);
        this.plot = plotBox;
        LinkedList<String> extensions = new LinkedList<String>();
        extensions.add("plt");
        this._fileFilter = new TableauFrame.ExtensionFileFilter(extensions);
        this.plot.setBackground(new Color(0xE5E5E5));
        this.getContentPane().add((Component)this.plot, "Center");
        this._initialSaveAsFileName = "plot.plt";
    }

    @Override
    public int print(Graphics graphics, PageFormat format, int index) throws PrinterException {
        return this.plot.print(graphics, format, index);
    }

    public void samplePlot() {
        this._file = null;
        this._directory = null;
        this.plot.samplePlot();
    }

    @Override
    protected void _addMenus() {
        super._addMenus();
        this._editMenu = new JMenu("Edit");
        this._editMenu.setMnemonic(69);
        this._menubar.add(this._editMenu);
        FormatAction formatAction = new FormatAction();
        GUIUtilities.addMenuItem((JMenu)this._editMenu, (Action)formatAction);
        this._specialMenu = new JMenu("Special");
        this._specialMenu.setMnemonic(83);
        this._menubar.add(this._specialMenu);
        JMenuItem[] specialMenuItems = new JMenuItem[]{new JMenuItem("Clear", 67), new JMenuItem("Export", 69), new JMenuItem("Fill", 70), new JMenuItem("Reset axes", 82), new JMenuItem("Sample plot", 83)};
        SpecialMenuListener sml = new SpecialMenuListener();
        for (int i = 0; i < specialMenuItems.length; ++i) {
            specialMenuItems[i].setActionCommand(specialMenuItems[i].getText());
            specialMenuItems[i].addActionListener(sml);
            this._specialMenu.add(specialMenuItems[i]);
        }
    }

    @Override
    protected boolean _clear() {
        boolean result = super._clear();
        this.plot.clear(false);
        return result;
    }

    protected void _editFormat() {
        PlotFormatter formatter = new PlotFormatter(this.plot);
        formatter.openModal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _export() {
        JFileChooser fileDialog = new JFileChooser();
        fileDialog.addChoosableFileFilter(new EPSFileFilter());
        fileDialog.setDialogTitle("Export EPS to...");
        if (this._directory != null) {
            fileDialog.setCurrentDirectory(this._directory);
        } else {
            String cwd = StringUtilities.getProperty("user.dir");
            if (cwd != null) {
                fileDialog.setCurrentDirectory(new File(cwd));
            }
        }
        fileDialog.setSelectedFile(new File(fileDialog.getCurrentDirectory(), "plot.eps"));
        int returnVal = fileDialog.showDialog(this, "Export");
        if (returnVal == 0) {
            File file = fileDialog.getSelectedFile();
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                this.plot.export(fout);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error exporting plot to '" + file + "': " + ex, "Ptolemy II Error", 2);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (Throwable throwable) {
                        System.out.println("Ignoring failure to close stream on " + file);
                        throwable.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    protected void _help() {
        JOptionPane.showMessageDialog(this, "PlotTableauFrame is a plot in a top-level window.\n  File formats understood: Ptplot ASCII.\n  Left mouse button: Zooming.", "About Ptolemy Plot", 1);
    }

    @Override
    protected void _writeFile(File file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        this.plot.write(fout);
    }

    static class EPSFileFilter
    extends FileFilter {
        EPSFileFilter() {
        }

        @Override
        public boolean accept(File fileOrDirectory) {
            if (fileOrDirectory.isDirectory()) {
                return true;
            }
            String fileOrDirectoryName = fileOrDirectory.getName();
            int dotIndex = fileOrDirectoryName.lastIndexOf(46);
            if (dotIndex == -1) {
                return false;
            }
            String extension = fileOrDirectoryName.substring(dotIndex);
            if (extension != null) {
                return extension.equalsIgnoreCase(".eps");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Encapsulated PostScript (.eps) files";
        }
    }

    class SpecialMenuListener
    implements ActionListener {
        SpecialMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            try {
                if (actionCommand.equals("Fill")) {
                    PlotTableauFrame.this.plot.fillPlot();
                } else if (actionCommand.equals("Reset axes")) {
                    PlotTableauFrame.this.plot.resetAxes();
                } else if (actionCommand.equals("Clear")) {
                    PlotTableauFrame.this.plot.clear(false);
                    PlotTableauFrame.this.plot.repaint();
                } else if (actionCommand.equals("Export")) {
                    PlotTableauFrame.this._export();
                } else if (actionCommand.equals("Sample plot")) {
                    PlotTableauFrame.this.plot.clear(true);
                    PlotTableauFrame.this.samplePlot();
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Special Menu Exception:\n" + exception.toString(), "Ptolemy Plot Error", 2);
            }
            PlotTableauFrame.this.repaint();
        }
    }

    private class FormatAction
    extends AbstractAction {
        public FormatAction() {
            super("Format");
            this.putValue("tooltip", "Open a dialog to format the plot.");
            this.putValue("MnemonicKey", 70);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PlotTableauFrame.this._editFormat();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Format Exception:\n" + exception.toString(), "Ptolemy Plot Error", 2);
            }
            PlotTableauFrame.this.repaint();
        }
    }
}

