/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.util.Iterator;
import java.util.List;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;

public class ModelDirectory
extends CompositeEntity {
    public ModelDirectory(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public Effigy getEffigy(String identifier) {
        for (Effigy entity : this.entityList(Effigy.class)) {
            String idString;
            StringAttribute id = (StringAttribute)entity.getAttribute("identifier");
            if (id == null || !(idString = id.getExpression()).equals(identifier)) continue;
            return entity;
        }
        return null;
    }

    @Override
    protected void _removeEntity(ComponentEntity entity) {
        Object remaining;
        super._removeEntity(entity);
        List remainingEntities = this.entityList(Effigy.class);
        if (remainingEntities.size() == 0) {
            try {
                this.setContainer(null);
            }
            catch (KernelException ex) {
                throw new InternalErrorException("Cannot remove directory!");
            }
        }
        if (remainingEntities.size() == 1 && (remaining = remainingEntities.get(0)) instanceof PtolemyEffigy && ((PtolemyEffigy)remaining).getModel() instanceof Configuration) {
            try {
                this.setContainer(null);
            }
            catch (KernelException ex) {
                throw new InternalErrorException("Cannot remove directory!");
            }
        }
        boolean anyTableau = false;
        Iterator effigies = remainingEntities.iterator();
        while (effigies.hasNext() && !anyTableau) {
            Effigy effigy = (Effigy)effigies.next();
            if (effigy.numberOfOpenTableaux() <= 0) continue;
            anyTableau = true;
        }
        if (!anyTableau) {
            try {
                for (Effigy effigy : remainingEntities) {
                    effigy.setContainer(null);
                }
            }
            catch (KernelException ex) {
                throw new InternalErrorException("Cannot remove directory!");
            }
        }
    }
}

