/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import ptolemy.util.ClassUtilities;
import ptolemy.util.FileUtilities;
import ptolemy.util.StringUtilities;

public class JNLPUtilities {
    private JNLPUtilities() {
    }

    public static URL canonicalizeJarURL(URL possibleJarURL) throws MalformedURLException {
        if (possibleJarURL.toExternalForm().startsWith("jar:")) {
            URL jarURL = new URL(StringUtilities.substitute(possibleJarURL.toExternalForm(), " ", "%20"));
            return jarURL;
        }
        return possibleJarURL;
    }

    public static boolean isRunningUnderWebStart() {
        try {
            String javaWebStart = System.getProperty("javawebstart.version");
            if (javaWebStart != null) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static URL jarURLEntryResource(String spec) throws IOException {
        return ClassUtilities.jarURLEntryResource(spec);
    }

    public static String saveJarURLAsTempFile(String jarURLName, String prefix, String suffix, File directory) throws IOException {
        URL jarURL = JNLPUtilities._lookupJarURL(jarURLName);
        jarURLName = jarURL.toString();
        if (suffix == null && jarURLName.lastIndexOf(46) != -1) {
            suffix = jarURLName.substring(jarURLName.lastIndexOf(46));
        }
        File temporaryFile = File.createTempFile(prefix, suffix, directory);
        temporaryFile.deleteOnExit();
        FileUtilities.binaryCopyURLToFile(jarURL, temporaryFile);
        return temporaryFile.toString();
    }

    public static String saveJarURLInClassPath(String jarURLName) throws IOException {
        String parentEntryFileName;
        URL jarURL = JNLPUtilities._lookupJarURL(jarURLName);
        int jarSeparatorIndex = (jarURLName = jarURL.toString()).indexOf("!/");
        if (jarSeparatorIndex == -1) {
            return jarURLName;
        }
        String jarURLFileName = jarURLName.substring(0, jarSeparatorIndex);
        String entryFileName = jarURLName.substring(jarSeparatorIndex + 2);
        String jarURLParentFileName = jarURLFileName.substring(0, jarURLFileName.lastIndexOf("/"));
        if (jarURLParentFileName.endsWith(parentEntryFileName = entryFileName.substring(0, entryFileName.lastIndexOf("/"))) && jarURLParentFileName.startsWith("jar:file:/")) {
            String jarURLTop = jarURLParentFileName.substring(10, jarURLParentFileName.length() - parentEntryFileName.length());
            File temporaryFile = new File(jarURLTop, entryFileName);
            if (!temporaryFile.exists()) {
                FileUtilities.binaryCopyURLToFile(jarURL, temporaryFile);
            }
            return temporaryFile.toString();
        }
        return null;
    }

    private static URL _lookupJarURL(String jarURLName) throws IOException {
        URL jarURL = JNLPUtilities.jarURLEntryResource(jarURLName);
        if (jarURL == null) {
            jarURL = Thread.currentThread().getContextClassLoader().getResource(jarURLName);
        }
        if (jarURL == null) {
            throw new FileNotFoundException("Could not find '" + jarURLName + "'");
        }
        return jarURL;
    }
}

