/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.net.URL;
import java.net.URLConnection;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.EffigyFactory;
import ptolemy.actor.gui.HTMLEffigy;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class HTMLEffigyFactory
extends EffigyFactory {
    public HTMLEffigyFactory(Workspace workspace) {
        super(workspace);
    }

    public HTMLEffigyFactory(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public boolean canCreateBlankEffigy() {
        return false;
    }

    @Override
    public Effigy createEffigy(CompositeEntity container, URL base, URL in) throws Exception {
        if (in == null) {
            return null;
        }
        String extension = HTMLEffigyFactory.getExtension(in);
        if (!extension.equals("htm") && !extension.equals("html")) {
            URLConnection connection = in.openConnection();
            if (connection == null) {
                return null;
            }
            String contentType = connection.getContentType();
            if (contentType == null) {
                return null;
            }
            if (!contentType.startsWith("text/html") && !contentType.startsWith("text/rtf")) {
                return null;
            }
        }
        HTMLEffigy effigy = new HTMLEffigy(container, container.uniqueName("effigy"));
        effigy.uri.setURL(in);
        return effigy;
    }
}

