/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import ptolemy.actor.gt.GTTools;
import ptolemy.actor.gt.NamedObjToken;
import ptolemy.actor.gt.NamedObjVariable;
import ptolemy.actor.gt.Pattern;
import ptolemy.actor.gt.data.MatchResult;
import ptolemy.data.BooleanToken;
import ptolemy.data.Function;
import ptolemy.data.FunctionToken;
import ptolemy.data.ObjectToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtFunctionApplicationNode;
import ptolemy.data.expr.ASTPtFunctionalIfNode;
import ptolemy.data.expr.ASTPtLeafNode;
import ptolemy.data.expr.ASTPtMethodCallNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ConversionUtilities;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.FunctionType;
import ptolemy.data.type.Type;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class GTParameter
extends Parameter {
    public GTParameter(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    protected void _evaluate() throws IllegalActionException {
    }

    protected void _evaluate(Pattern pattern, MatchResult matchResult) throws IllegalActionException {
        this.setParseTreeEvaluator(new Evaluator(pattern, matchResult));
        super._evaluate();
    }

    public static class Scope
    implements ParserScope {
        private MatchResult _matchResult;
        private Pattern _pattern;
        private ParserScope _superscope;

        public Scope(Pattern pattern, MatchResult matchResult, ParserScope superscope) {
            this._pattern = pattern;
            this._matchResult = matchResult;
            this._superscope = superscope;
        }

        @Override
        public Token get(String name) throws IllegalActionException {
            NamedObj container;
            NamedObj patternChild = GTTools.getChild(this._pattern, name, true, true, true, true);
            if (patternChild != null && this._matchResult.containsKey(patternChild)) {
                NamedObj child = (NamedObj)this._matchResult.get(patternChild);
                return NamedObjVariable.getNamedObjVariable(child, true).getToken();
            }
            Token superToken = this._superscope.get(name);
            if (superToken == null && (container = this._pattern.getContainer()) != null) {
                NamedObjVariable containerVar = NamedObjVariable.getNamedObjVariable(this._pattern.getContainer(), true);
                ParserScope containerScope = containerVar.getParserScope();
                superToken = containerScope.get(name);
            }
            return superToken;
        }

        @Override
        public Type getType(String name) throws IllegalActionException {
            Token token = this.get(name);
            if (token != null) {
                return token.getType();
            }
            return this._superscope.getType(name);
        }

        @Override
        public InequalityTerm getTypeTerm(String name) throws IllegalActionException {
            return this._superscope.getTypeTerm(name);
        }

        @Override
        public Set<?> identifierSet() throws IllegalActionException {
            HashSet<String> identifiers = new HashSet<String>(this._superscope.identifierSet());
            for (Object childObject : GTTools.getChildren(this._pattern, true, true, true, true)) {
                identifiers.add(((NamedObj)childObject).getName());
            }
            return identifiers;
        }
    }

    public static class LoopFunction
    implements Function {
        private Collection<?> _collection;
        private LoopEvaluator _evaluator;
        private Token _startValue;

        public LoopFunction(Pattern pattern, MatchResult matchResult, String current, Token startValue, String boundVariable, Collection<?> collection) {
            this._startValue = startValue;
            this._collection = collection;
            this._evaluator = new LoopEvaluator(pattern, matchResult, current, boundVariable);
        }

        @Override
        public Token apply(Token[] arguments) throws IllegalActionException {
            ASTPtRootNode tree = (ASTPtRootNode)((ObjectToken)arguments[0]).getValue();
            Token currentValue = this._startValue;
            for (Object element : this._collection) {
                Token elementToken = element instanceof Token ? (Token)element : new ObjectToken(element);
                this._evaluator.setCurrentValue(currentValue);
                this._evaluator.setElementToken(elementToken);
                currentValue = this._evaluator.evaluateParseTree(tree);
            }
            return currentValue;
        }

        @Override
        public int getNumberOfArguments() {
            return 1;
        }

        @Override
        public boolean isCongruent(Function function) {
            return false;
        }
    }

    public static class LoopEvaluator
    extends Evaluator {
        private String _boundVariable;
        private String _currentName;
        private Token _currentToken;
        private Token _elementToken;

        public LoopEvaluator(Pattern pattern, MatchResult matchResult, String currentName, String boundVariable) {
            super(pattern, matchResult);
            this._currentName = currentName;
            this._boundVariable = boundVariable;
            this._currentToken = Token.NIL;
            this._elementToken = Token.NIL;
        }

        public void setCurrentValue(Token current) {
            this._currentToken = current;
        }

        public void setElementToken(Token elementToken) {
            this._elementToken = elementToken;
        }

        @Override
        public void visitLeafNode(ASTPtLeafNode node) throws IllegalActionException {
            if (node.isIdentifier()) {
                String name = node.getName();
                if (name.equals(this._currentName)) {
                    this._evaluatedChildToken = this._currentToken;
                    return;
                }
                if (name.equals(this._boundVariable)) {
                    this._evaluatedChildToken = this._elementToken;
                    return;
                }
            }
            super.visitLeafNode(node);
        }
    }

    public static class Evaluator
    extends ParseTreeEvaluator {
        private MatchResult _matchResult;
        private Pattern _pattern;

        public Evaluator(Pattern pattern, MatchResult matchResult) {
            this._pattern = pattern;
            this._matchResult = matchResult;
        }

        @Override
        public Token evaluateParseTree(ASTPtRootNode node, ParserScope scope) throws IllegalActionException {
            return super.evaluateParseTree(node, new Scope(this._pattern, this._matchResult, scope));
        }

        @Override
        public void visitFunctionApplicationNode(ASTPtFunctionApplicationNode node) throws IllegalActionException {
            String functionName = node.getFunctionName();
            if (functionName != null && functionName.equals("loop")) {
                if (node.jjtGetNumChildren() != 5) {
                    throw new IllegalActionException("The loop special function requires exactly 4 arguments.");
                }
                String current = null;
                ASTPtRootNode child = (ASTPtRootNode)node.jjtGetChild(1);
                if (child != null && child instanceof ASTPtLeafNode && ((ASTPtLeafNode)child).isIdentifier()) {
                    current = ((ASTPtLeafNode)child).getName();
                }
                if (current == null) {
                    throw new IllegalActionException("The first argument to the loop special function must be an identifier.");
                }
                Token startValue = this._evaluateChild(node, 2);
                String boundVariable = null;
                child = (ASTPtRootNode)node.jjtGetChild(3);
                if (child != null && child instanceof ASTPtLeafNode) {
                    boundVariable = ((ASTPtLeafNode)child).getName();
                }
                if (boundVariable == null) {
                    throw new IllegalActionException("The third argument to the loop special function must be an identifier.");
                }
                Collection collection = null;
                Token token = this._evaluateChild(node, 4);
                if (token instanceof ObjectToken && ((ObjectToken)token).getValue() instanceof Collection) {
                    collection = (Collection)((ObjectToken)token).getValue();
                }
                if (collection == null) {
                    throw new IllegalActionException("The forth argument to the loop special function must be a value collection.");
                }
                LoopFunction function = new LoopFunction(this._pattern, this._matchResult, current, startValue, boundVariable, collection);
                FunctionType functionType = new FunctionType(new Type[]{BaseType.OBJECT}, BaseType.GENERAL);
                this._evaluatedChildToken = new FunctionToken(function, functionType);
            } else if (functionName == null) {
                Token token = null;
                try {
                    token = this._evaluateChild(node, 0);
                }
                catch (IllegalActionException e) {
                    super.visitFunctionApplicationNode(node);
                    return;
                }
                if (token instanceof FunctionToken) {
                    FunctionToken functionToken = (FunctionToken)token;
                    int argCount = node.jjtGetNumChildren() - 1;
                    if (functionToken.getNumberOfArguments() != argCount) {
                        throw new IllegalActionException("Wrong number of arguments when applying function " + token.toString());
                    }
                    if (functionToken.getFunction() instanceof LoopFunction) {
                        this._evaluatedChildToken = functionToken.apply(new Token[]{new ObjectToken(node.jjtGetChild(1))});
                        return;
                    }
                }
                super.visitFunctionApplicationNode(node);
            }
        }

        @Override
        public void visitFunctionalIfNode(ASTPtFunctionalIfNode node) throws IllegalActionException {
            if (node.isConstant() && node.isEvaluated()) {
                this._evaluatedChildToken = node.getToken();
                return;
            }
            int numChildren = node.jjtGetNumChildren();
            if (numChildren != 3) {
                throw new InternalErrorException("PtParser error: a functional-if node does not have three children in the parse tree.");
            }
            this._evaluateChild(node, 0);
            Token test = this._evaluatedChildToken;
            if (!(test instanceof BooleanToken)) {
                throw new IllegalActionException("Functional-if must branch on a boolean, but instead was " + test.toString() + " an instance of " + test.getClass().getName());
            }
            boolean value = ((BooleanToken)test).booleanValue();
            ASTPtRootNode tokenChild = value ? (ASTPtRootNode)node.jjtGetChild(1) : (ASTPtRootNode)node.jjtGetChild(2);
            tokenChild.visit(this);
            if (node.isConstant()) {
                node.setToken(this._evaluatedChildToken);
            }
        }

        @Override
        public void visitMethodCallNode(ASTPtMethodCallNode node) throws IllegalActionException {
            Token firstChild;
            int argCount = node.jjtGetNumChildren();
            if (argCount == 1 && (firstChild = this._evaluateChild(node, 0)) instanceof NamedObjToken) {
                NamedObj child;
                NamedObj patternChild;
                NamedObjToken objectToken = (NamedObjToken)firstChild;
                NamedObj object = objectToken.getObject();
                NamedObj patternObject = (NamedObj)this._matchResult.getKey(object);
                String methodName = node.getMethodName();
                if (patternObject != null && (patternChild = GTTools.getChild(patternObject, methodName, true, true, true, true)) != null && (child = (NamedObj)this._matchResult.get(patternChild)) != null) {
                    this._evaluatedChildToken = NamedObjVariable.getNamedObjVariable(child, true).getToken();
                    return;
                }
            }
            super.visitMethodCallNode(node);
        }

        @Override
        protected Token _methodCall(String methodName, Type[] argTypes, Object[] argValues) throws IllegalActionException {
            Object object = argValues[0];
            if (!(object instanceof ObjectToken) && !(object instanceof NamedObjToken)) {
                return super._methodCall(methodName, argTypes, argValues);
            }
            if ((object = this._getObject(object)) == null) {
                throw new IllegalActionException("Method " + methodName + " cannot be found because the object invoked on is " + "null.");
            }
            Class clazz = object.getClass();
            HashSet classes = new HashSet();
            classes.add(clazz);
            while (!classes.isEmpty()) {
                Iterator iterator = classes.iterator();
                clazz = (Class)iterator.next();
                iterator.remove();
                if (!Modifier.isPublic(clazz.getModifiers())) {
                    for (Class<?> interf : clazz.getInterfaces()) {
                        classes.add(interf);
                    }
                    Class superclass = clazz.getSuperclass();
                    if (superclass == null) continue;
                    classes.add(superclass);
                    continue;
                }
                Token result = this._methodCall(clazz, object, methodName, argTypes, argValues);
                if (result == null) continue;
                return result;
            }
            return super._methodCall(methodName, argTypes, argValues);
        }

        private Object _getObject(Object value) throws IllegalActionException {
            if (value instanceof ObjectToken) {
                return ((ObjectToken)value).getValue();
            }
            if (value instanceof NamedObjToken) {
                return ((NamedObjToken)value).getObject();
            }
            if (value instanceof Token) {
                return ConversionUtilities.convertTokenToJavaType((Token)value);
            }
            return value;
        }

        private Token _methodCall(Class<?> clazz, Object object, String methodName, Type[] argTypes, Object[] argValues) throws IllegalActionException {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                Class<?>[] parameterTypes;
                if (!method.getName().equals(methodName) || !Modifier.isPublic(method.getModifiers()) || (parameterTypes = method.getParameterTypes()).length != argTypes.length - 1) continue;
                boolean compatible = true;
                for (int i = 0; compatible && i < parameterTypes.length; ++i) {
                    if (parameterTypes[i].isInstance(this._getObject(argValues[i + 1]))) continue;
                    compatible = false;
                }
                if (!compatible) continue;
                Object[] args = new Object[argValues.length - 1];
                for (int i = 1; i < argValues.length; ++i) {
                    args[i - 1] = this._getObject(argValues[i]);
                }
                try {
                    Object result = method.invoke(object, args);
                    if (result instanceof NamedObj) {
                        return NamedObjVariable.getNamedObjVariable((NamedObj)result, true).getToken();
                    }
                    return ConversionUtilities.convertJavaTypeToToken(result);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

