/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import ptolemy.actor.AbstractReceiver;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.util.FIFOQueue;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;

public class QueueReceiver
extends AbstractReceiver {
    public static final int INFINITE_CAPACITY = -1;
    protected FIFOQueue _queue = new FIFOQueue();

    public QueueReceiver() {
    }

    public QueueReceiver(IOPort container) throws IllegalActionException {
        super(container);
    }

    @Override
    public void clear() {
        this._queue.clear();
    }

    public List elementList() {
        return this._queue.elementList();
    }

    public Enumeration elements() {
        return Collections.enumeration(this.elementList());
    }

    @Override
    public Token get() {
        Token t = null;
        try {
            t = (Token)this._queue.take();
        }
        catch (NoSuchElementException ex) {
            throw new NoTokenException(this.getContainer(), "Attempt to get token from an empty QueueReceiver.");
        }
        return t;
    }

    public Token get(int offset) {
        try {
            return (Token)this._queue.get(offset);
        }
        catch (NoSuchElementException ex) {
            throw new NoTokenException(this.getContainer(), "Offset " + offset + " out of range with " + this._queue.size() + " tokens in the receiver and " + this._queue.historySize() + " in history.");
        }
    }

    public int getCapacity() {
        return this._queue.getCapacity();
    }

    public int getHistoryCapacity() {
        return this._queue.getHistoryCapacity();
    }

    @Override
    public boolean hasRoom() {
        return !this._queue.isFull();
    }

    @Override
    public boolean hasRoom(int numberOfTokens) throws IllegalArgumentException {
        if (numberOfTokens < 1) {
            throw new IllegalArgumentException("The number of tokens must be greater than 0");
        }
        return this._queue.size() + numberOfTokens < this._queue.getCapacity();
    }

    @Override
    public boolean hasToken() {
        return this._queue.size() > 0;
    }

    @Override
    public boolean hasToken(int numberOfTokens) throws IllegalArgumentException {
        if (numberOfTokens < 1) {
            throw new IllegalArgumentException("The number of tokens must be greater than 0");
        }
        return this._queue.size() >= numberOfTokens;
    }

    public List historyElementList() {
        return this._queue.historyElementList();
    }

    public Enumeration historyElements() {
        return Collections.enumeration(this.historyElementList());
    }

    public int historySize() {
        return this._queue.historySize();
    }

    @Override
    public void put(Token token) {
        if (!this._queue.put(token)) {
            throw new NoRoomException(this.getContainer(), "Queue is at capacity. Cannot put a token.");
        }
    }

    public void setCapacity(int capacity) throws IllegalActionException {
        try {
            this._queue.setCapacity(capacity);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException((Nameable)this.getContainer(), ex, "Failed to set capacity to " + capacity);
        }
    }

    public void setHistoryCapacity(int capacity) throws IllegalActionException {
        try {
            this._queue.setHistoryCapacity(capacity);
        }
        catch (IllegalActionException ex) {
            throw new IllegalActionException((Nameable)this.getContainer(), ex, "Failed to setHistoryCapacity to " + capacity);
        }
    }

    public int size() {
        return this._queue.size();
    }
}

