/*
 * Decompiled with CFR 0.152.
 */
package opale.ode;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import opale.mathtools.DVect;
import opale.ode.Equation;
import opale.ode.ObjectODE;
import opale.ode.SEquation;
import opale.ode.TimeScheme;
import opale.ode.UpdateODE;
import opale.tools.Chronometer;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;
import opale.tools.Stdio;
import opale.tools.StreamReader;
import opale.tools.WFile;

public final class Problem
extends ObjectODE {
    public final boolean PRINT = false;
    private TimeScheme sch;
    private Equation eqn;
    private DVect cdinit;
    private Vector inco;
    private Vector times;
    private int dim;
    private boolean issolve = false;
    private UpdateODE myupdate = null;

    public Problem() {
        this.dim = 1;
        this.cdinit = new DVect(this.dim);
    }

    public Problem(int n) {
        this.dim = Math.max(n, 1);
        this.cdinit = new DVect(this.dim);
    }

    public void solve() {
        this.issolve = false;
        Stdio.printerrln("\n**************************************************");
        Stdio.printerrln("************ Solving a problem *******************");
        Stdio.printerrln("**************************************************");
        Stdio.printerrln("*** Check the problem ***");
        if (this.eqn == null) {
            Stdio.printerrln("No equation for this problem !!\n Stop.");
            System.exit(-1);
        }
        if (this.dim != this.eqn.dim()) {
            Stdio.printerrln("Equation and problem have not same dimension !!.\n Stop.");
            System.exit(-1);
        }
        Stdio.printerrln(" --> Equation OK");
        if (this.sch == null) {
            Stdio.printerrln("No time scheme !!\n Stop.");
            System.exit(-1);
        }
        Stdio.printerrln(" --> Scheme : " + this.sch);
        Stdio.printerrln(" --> Initial condition : ");
        int n = 0;
        while (n < this.dim) {
            Stdio.printerrln("\t" + this.cdinit.get(n));
            ++n;
        }
        Stdio.printerrln("*** Problem OK ***\n");
        Stdio.printerrln("*** Memory allocation  ***\n");
        this.inco = new Vector(this.sch.getNstep());
        this.times = new Vector(this.sch.getNstep());
        Stdio.printerrln("*** Time scheme initialisation ***\n");
        this.sch.init();
        this.inco.add(this.sch.present().clone());
        this.times.add(new Double(this.sch.tmin()));
        Stdio.printerrln("*** Starting the resolution ***");
        double d = this.sch.tmax();
        double d2 = this.sch.time();
        if (this.myupdate == null) {
            Chronometer.start();
            while (d2 < d) {
                this.sch.advance();
                boolean bl = this.sch.update();
                if (!bl) continue;
                d2 = this.sch.time();
                this.inco.add((DVect)this.sch.present().clone());
                this.times.add(new Double(d2));
            }
            Chronometer.stop();
        } else {
            Chronometer.start();
            while (d2 < d) {
                this.sch.advance();
                boolean bl = this.sch.update();
                if (!bl) continue;
                d2 = this.sch.time();
                this.inco.add((DVect)this.sch.present().clone());
                this.times.add(new Double(d2));
                this.myupdate.update(this);
            }
            Chronometer.stop();
        }
        Stdio.printerrln("*** elapsed time : " + Chronometer.time() + " ms\n");
        Stdio.printerrln("**********************************************");
        Stdio.printerrln("************ It's the end ! Ciao *************");
        Stdio.printerrln("**********************************************\n");
        this.issolve = true;
    }

    public String printSol() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.times.size();
        if (this.issolve) {
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append((Double)this.times.get(n2) + " ");
                DVect dVect = (DVect)this.inco.get(n2);
                int n3 = 0;
                while (n3 < this.dim) {
                    stringBuffer.append(dVect.get(n3) + " ");
                    ++n3;
                }
                stringBuffer.append("\n");
                ++n2;
            }
        } else {
            stringBuffer.append("Problem not solved \n");
        }
        return stringBuffer.toString();
    }

    public double[][] toTab() {
        if (this.issolve) {
            int n = this.times.size();
            double[][] dArray = new double[this.dim + 1][this.times.size()];
            int n2 = 0;
            while (n2 < n) {
                dArray[0][n2] = (Double)this.times.get(n2);
                DVect dVect = (DVect)this.inco.get(n2);
                int n3 = 1;
                while (n3 <= this.dim) {
                    dArray[n3][n2] = dVect.get(n3 - 1);
                    ++n3;
                }
                ++n2;
            }
            return dArray;
        }
        return null;
    }

    public double[][] toArray() {
        if (this.issolve) {
            double[][] dArray = new double[this.dim + 1][this.times.size()];
            int n = this.times.size();
            int n2 = 0;
            while (n2 < n) {
                dArray[0][n2] = (Double)this.times.get(n2);
                DVect dVect = (DVect)this.inco.get(n2);
                int n3 = 1;
                while (n3 <= this.dim) {
                    dArray[n3][n2] = dVect.get(n3 - 1);
                    ++n3;
                }
                ++n2;
            }
            return dArray;
        }
        return null;
    }

    public void writeSol(WFile wFile) {
        wFile.writeString(this.printSol());
    }

    public int dim() {
        return this.dim;
    }

    public void setInit(DVect dVect) {
        this.cdinit.set(dVect);
    }

    public DVect getInit() {
        return this.cdinit;
    }

    public int getNStep() {
        if (this.issolve) {
            return this.times.size();
        }
        return -1;
    }

    public void setEqn(Equation equation) {
        if (this.dim != equation.dim()) {
            Stdio.printerrln("Equation and problem have not same dimension !!.\n Stop.");
            System.exit(-1);
        }
        this.eqn = equation;
    }

    public Equation getEqn() {
        return this.eqn;
    }

    public void setTS(TimeScheme timeScheme) {
        this.sch = timeScheme;
        timeScheme.setPb(this);
    }

    public TimeScheme getTS() {
        return this.sch;
    }

    public int readKeyWord(String string, StreamReader streamReader, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("dim")) {
            this.dim = (int)streamReader.nextDouble();
            this.cdinit = new DVect(this.dim);
            return 0;
        }
        if (string.equals("y0")) {
            int n = 0;
            while (n < this.dim) {
                this.cdinit.set(n, streamReader.nextDouble());
                ++n;
            }
            return 0;
        }
        if (string.equals("sch")) {
            String string2 = streamReader.next();
            if (!opaleSet.contains(string2) || opaleSet.getObject(string2) == null) {
                throw new InvalidFormatException("Incorrect data file : indentifier " + string2 + " doesn't exist !!");
            }
            if (!(opaleSet.getObject(string2) instanceof TimeScheme)) {
                throw new InvalidFormatException("Incorrect data file : indentifier " + string2 + " is not a time scheme !!");
            }
            this.setTS((TimeScheme)opaleSet.getObject(string2));
            return 0;
        }
        if (string.equals("eqn")) {
            String string3 = streamReader.next();
            if (!opaleSet.contains(string3) || opaleSet.getObject(string3) == null) {
                throw new InvalidFormatException("Incorrect data file : indentifier " + string3 + "  doesn't exist!!");
            }
            if (!(opaleSet.getObject(string3) instanceof Equation)) {
                throw new InvalidFormatException("Incorrect data file : indentifier  " + string3 + " isn't an equation !!");
            }
            this.setEqn((Equation)((Object)opaleSet.getObject(string3)));
            return 0;
        }
        return -1;
    }

    public void write(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        printWriter.println("{");
        if (!opaleSet.contains(this.sch)) {
            throw new InvalidFormatException("Error writing a file : the time scheme " + this.sch + " doesn't exist !!");
        }
        if (!(this.eqn instanceof ObjectODE)) {
            throw new InvalidFormatException("Error writing a file : the equation " + this.eqn + " of type " + this.eqn.getClass() + " can't print in a file !!");
        }
        if (!opaleSet.contains((ObjectODE)((Object)this.eqn))) {
            throw new InvalidFormatException("Error writing a file : the equation " + this.eqn + " doesn't exist !!");
        }
        printWriter.println("dim " + this.dim);
        printWriter.print("y0");
        int n = 0;
        while (n < this.dim) {
            printWriter.print(" " + this.cdinit.get(n));
            ++n;
        }
        printWriter.println("");
        printWriter.println("sch " + this.sch.getId());
        printWriter.println("eqn " + ((SEquation)this.eqn).getId());
        printWriter.println("}");
    }

    public void setUpdateODE(UpdateODE updateODE) {
        this.myupdate = updateODE;
    }

    public String toString() {
        return "Problem of ODE";
    }
}

