/*
 * Decompiled with CFR 0.152.
 */
package opale.matrix.solver;

import opale.mathtools.DVect;
import opale.matrix.IterativeSolver;
import opale.matrix.Matrix;
import opale.tools.Debug;

public class SolverGaussSeidel
implements IterativeSolver {
    public void solve(Matrix matrix, DVect dVect, DVect dVect2) {
        int n = matrix.getRowDim();
        if (n != matrix.getColumnDim()) {
            throw new IllegalArgumentException("Gauss-Seidel solver implemented only for square matrix");
        }
        if (n != dVect.size() || n != dVect2.size()) {
            throw new IllegalArgumentException("matrix and vector dimension are not equals.");
        }
        double[][] dArray = matrix.getInternalArray();
        double[] dArray2 = dVect.toArray();
        double[] dArray3 = dVect2.toArray();
        double d = 1.0;
        double d2 = dVect.normInf();
        int n2 = 0;
        while (n2++ < 100 && d / d2 > 1.0E-9) {
            d = 0.0;
            int n3 = 0;
            while (n3 < n) {
                double d3 = dArray2[n3];
                int n4 = 0;
                while (n4 < n) {
                    d3 -= dArray[n3][n4] * dArray3[n4];
                    ++n4;
                }
                d = Math.max(Math.abs(d3), d);
                dArray3[n3] = dArray3[n3] + d3 / dArray[n3][n3];
                ++n3;
            }
            Debug.print("residu = " + d);
        }
        Debug.print("n iter = " + n2);
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{4.0, 1.0}, {1.0, 4.0}};
        Matrix matrix = new Matrix(dArrayArray);
        DVect dVect = new DVect(2);
        DVect dVect2 = new DVect(2);
        System.out.println(matrix);
        dVect.set(0, 1.0);
        dVect.set(1, 0.0);
        SolverGaussSeidel solverGaussSeidel = new SolverGaussSeidel();
        solverGaussSeidel.solve(matrix, dVect, dVect2);
        System.out.println(dVect2);
    }
}

