/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.object2d;

import java.io.IOException;
import java.io.PrintWriter;
import opale.m2d.DefaultGraphicalOptions;
import opale.m2d.GObject2D;
import opale.m2d.InfoObject;
import opale.m2d.MarkType;
import opale.m2d.OIJ;
import opale.m2d.Pen2D;
import opale.m2d.marktype.ClassicPoint;
import opale.m2d.object2d.Data2D;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;
import opale.tools.StreamReader;

public class GData2D
extends Data2D
implements GObject2D,
Cloneable {
    private DefaultGraphicalOptions info;
    private String legende;

    public GData2D() {
        Debug.print("Dans GData2D()");
        this.info = new DefaultGraphicalOptions();
    }

    public GData2D(OIJ oIJ) {
        super(oIJ);
        this.info = new DefaultGraphicalOptions();
    }

    public GData2D(Data2D data2D) {
        super(data2D);
        this.info = new DefaultGraphicalOptions();
    }

    public GData2D(GData2D gData2D) {
        super(gData2D);
        this.info = new DefaultGraphicalOptions((DefaultGraphicalOptions)gData2D.getInfo());
    }

    public final int readKeyWord(String string, StreamReader streamReader, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("INFO")) {
            this.info.read(streamReader, opaleSet);
            return 0;
        }
        return super.readKeyWord(string, streamReader, opaleSet);
    }

    public void writeMore(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        this.info.write(printWriter, opaleSet);
        super.writeMore(printWriter, opaleSet);
    }

    public void draw(Pen2D pen2D) {
        if (this.info.isVisible()) {
            pen2D.setColor(this.info.getColor());
            int n = 0;
            while (n < this.nbPts - 1) {
                pen2D.drawLine(this.x[n], this.y[n], this.x[n + 1], this.y[n + 1]);
                ++n;
            }
            MarkType markType = this.info.getMarktype();
            if (!(markType instanceof ClassicPoint)) {
                n = 0;
                while (n < this.nbPts) {
                    markType.draw(pen2D, this.x[n], this.y[n]);
                    ++n;
                }
            }
        }
    }

    public Object clone() {
        GData2D gData2D = (GData2D)super.clone();
        gData2D.info = (DefaultGraphicalOptions)this.info.clone();
        return gData2D;
    }

    public void drawLegend(Pen2D pen2D, int n, int n2, int n3, int n4) {
        if (this.info.isVisible()) {
            pen2D.setColor(this.info.getColor());
            pen2D.drawLine(n, n2 + n4 / 2, n + n3, n2 + n4 / 2);
        }
    }

    public InfoObject getInfo() {
        return this.info;
    }

    public String getLegend() {
        return this.info.getName();
    }

    public void setLegend(String string) {
        this.info.setName(string);
    }

    public double x(double d) {
        return d;
    }

    public double y(double d) {
        return d;
    }
}

