/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class JPointer {
    private double s = 0.0;
    private int type;
    private Shape shape = null;
    private Color color = Color.BLACK;
    private boolean enabled = true;
    private boolean adjusting = false;
    private transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    public static final int POINTER_SIMPLE_TRIANGLE = 0;
    public static final int POINTER_SIMPLE_QUADRANGLE = 1;
    public static final int POINTER_SIMPLE_STOP = 2;
    private static final Shape POINTER_SHAPE_SIMPLE_TRIANGLE;
    private static final Shape POINTER_SHAPE_SIMPLE_QUADRANGLE;
    private static final Shape POINTER_SHAPE_SIMPLE_STOP;
    public static final int SLIDER_SIMPLE_TRIANGLE = 3;
    public static final int SLIDER_SIMPLE_QUADRANGLE = 4;
    public static final int SLIDER_SIMPLE_STOP = 5;
    private static final Shape SLIDER_SHAPE_SIMPLE_TRIANGLE;
    private static final Shape SLIDER_SHAPE_SIMPLE_QUADRANGLE;
    private static final Shape SLIDER_SHAPE_SIMPLE_STOP;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JPointer(int n) {
        this.type = n;
    }

    public double getValue() {
        return this.s;
    }

    public void setValue(double d) {
        if (this.s == d) {
            return;
        }
        this.s = d;
        if (!this.adjusting) {
            this.fireStateChanged();
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setAdjusting(boolean bl) {
        if (this.adjusting && !bl) {
            this.fireStateChanged();
        }
        this.adjusting = bl;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean contains(Point point) {
        return this.shape.contains(point) && this.enabled;
    }

    protected void paintOnDial(Graphics2D graphics2D, double d, double d2, double d3, double d4, double d5) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d4, d5);
        affineTransform.scale(d / 1000.0, d / 1000.0);
        affineTransform.rotate(Math.PI * 2 * this.getValue() / d2 + d3);
        switch (this.type) {
            case 0: {
                graphics2D.setColor(this.color);
                this.shape = affineTransform.createTransformedShape(POINTER_SHAPE_SIMPLE_TRIANGLE);
                graphics2D.fill(this.shape);
                break;
            }
            case 1: {
                graphics2D.setColor(this.color);
                this.shape = affineTransform.createTransformedShape(POINTER_SHAPE_SIMPLE_QUADRANGLE);
                graphics2D.fill(this.shape);
                break;
            }
            case 2: {
                graphics2D.setColor(this.color);
                this.shape = affineTransform.createTransformedShape(POINTER_SHAPE_SIMPLE_STOP);
                graphics2D.fill(this.shape);
            }
        }
    }

    protected void paintOnSlider(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d3 / 2.0, d4 * (0.9 - 0.8 * (this.s - d) / (d2 - d)));
        affineTransform.scale(d3 / 1000.0, d4 / 2000.0);
        switch (this.type) {
            case 3: {
                graphics2D.setColor(this.color);
                this.shape = affineTransform.createTransformedShape(SLIDER_SHAPE_SIMPLE_TRIANGLE);
                graphics2D.fill(this.shape);
                break;
            }
            case 4: {
                graphics2D.setColor(this.color);
                this.shape = affineTransform.createTransformedShape(SLIDER_SHAPE_SIMPLE_QUADRANGLE);
                graphics2D.fill(this.shape);
                break;
            }
            case 5: {
                graphics2D.setColor(this.color);
                this.shape = affineTransform.createTransformedShape(SLIDER_SHAPE_SIMPLE_STOP);
                graphics2D.fill(this.shape);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JPointer.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JPointer.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JPointer.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? JPointer.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n;
        POINTER_SHAPE_SIMPLE_TRIANGLE = new Polygon(new int[]{-100, 100, 0}, new int[]{100, 100, -600}, 3);
        POINTER_SHAPE_SIMPLE_QUADRANGLE = new Polygon(new int[]{-100, 0, 100, 0}, new int[]{0, 100, 0, -600}, 4);
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        for (n = 0; n < 16; ++n) {
            nArray[n] = (int)(30.0 * Math.cos(Math.PI * 2 * (double)n / 16.0));
            nArray2[n] = (int)(-595.0 + 30.0 * Math.sin(Math.PI * 2 * (double)n / 16.0));
        }
        POINTER_SHAPE_SIMPLE_STOP = new Polygon(nArray, nArray2, 16);
        SLIDER_SHAPE_SIMPLE_TRIANGLE = new Polygon(new int[]{100, 0, 100}, new int[]{-100, 0, 100}, 3);
        SLIDER_SHAPE_SIMPLE_QUADRANGLE = new Polygon(new int[]{100, 0, 100, 50}, new int[]{-100, 0, 100, 0}, 4);
        nArray = new int[16];
        nArray2 = new int[16];
        for (n = 0; n < 16; ++n) {
            nArray[n] = (int)(200.0 + 30.0 * Math.cos(Math.PI * 2 * (double)n / 16.0));
            nArray2[n] = (int)(30.0 * Math.sin(Math.PI * 2 * (double)n / 16.0));
        }
        SLIDER_SHAPE_SIMPLE_STOP = new Polygon(nArray, nArray2, 16);
    }
}

