/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import numerics.Point3D;
import numerics.Vector3D;
import tractography.Tract;
import tractography.TractCollection;
import tractography.Voxel;
import tractography.VoxelList;

public class TargetCP_Image {
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;
    private final int xDataDim;
    private final int yDataDim;
    private final int zDataDim;
    private short[][][] targets = null;
    private int minTargetIndex = 0;
    private int maxTargetIndex = 0;
    private int numTargets = 0;
    private int[][] streamlineCounts;
    private int totalStreamlines = 0;
    private boolean countFirstEntry = true;
    private Vector3D forwards = null;
    private boolean directional = false;

    public TargetCP_Image(short[][][] sArray, double d, double d2, double d3) {
        this.xDataDim = sArray.length;
        this.yDataDim = sArray[0].length;
        this.zDataDim = sArray[0][0].length;
        this.targets = sArray;
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.zDataDim; ++k) {
                    if (sArray[i][j][k] > 0 && sArray[i][j][k] < this.minTargetIndex) {
                        this.minTargetIndex = sArray[i][j][k];
                    }
                    if (sArray[i][j][k] <= 0 || sArray[i][j][k] <= this.maxTargetIndex) continue;
                    this.maxTargetIndex = sArray[i][j][k];
                }
            }
        }
        this.numTargets = this.maxTargetIndex - this.minTargetIndex + 1;
        this.streamlineCounts = new int[1][this.maxTargetIndex + 1];
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
    }

    public void setDirectional(Vector3D vector3D) {
        this.forwards = vector3D.normalized();
        this.directional = true;
        this.streamlineCounts = new int[2][this.maxTargetIndex + 1];
    }

    public boolean directional() {
        return this.directional;
    }

    public final void processTracts(TractCollection tractCollection) {
        for (int i = 0; i < tractCollection.numberOfTracts(); ++i) {
            this.processTract(tractCollection.getTract(i));
        }
    }

    public final void processTract(Tract tract) {
        block15: {
            Voxel[] voxelArray;
            boolean[] blArray;
            block17: {
                int n;
                int n2;
                double d;
                double d2;
                block19: {
                    block18: {
                        int n3;
                        int n4;
                        int n5;
                        int n6;
                        Point3D point3D;
                        int n7;
                        int n8;
                        block16: {
                            short s;
                            int n9;
                            ++this.totalStreamlines;
                            blArray = new boolean[this.maxTargetIndex + 1];
                            VoxelList voxelList = tract.toVoxelList(this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
                            voxelArray = voxelList.getVoxels();
                            int n10 = voxelList.seedPointIndex();
                            int n11 = tract.seedPointIndex();
                            int n12 = voxelArray.length;
                            n8 = tract.numberOfPoints();
                            if (!this.directional) break block16;
                            Vector3D vector3D = null;
                            if (n11 < n8 - 1) {
                                vector3D = new Vector3D(tract.getPoint(n11 + 1), tract.getPoint(n11)).normalized();
                            } else if (n11 > 0) {
                                vector3D = new Vector3D(tract.getPoint(n11), tract.getPoint(n11 - 1)).normalized();
                            } else {
                                short s2 = this.targets[voxelArray[0].x][voxelArray[0].y][voxelArray[0].z];
                                if (s2 > 0) {
                                    int[] nArray = this.streamlineCounts[0];
                                    short s3 = s2;
                                    nArray[s3] = nArray[s3] + 1;
                                    int[] nArray2 = this.streamlineCounts[1];
                                    short s4 = s2;
                                    nArray2[s4] = nArray2[s4] + 1;
                                }
                                return;
                            }
                            int n13 = this.forwards.dot(vector3D) > 0.0 ? 0 : 1;
                            int n14 = n13 == 0 ? 1 : 0;
                            for (n9 = n10; n9 < n12; ++n9) {
                                s = this.targets[voxelArray[n9].x][voxelArray[n9].y][voxelArray[n9].z];
                                if (s <= 0 || blArray[s]) continue;
                                int[] nArray = this.streamlineCounts[n13];
                                short s5 = s;
                                nArray[s5] = nArray[s5] + 1;
                                blArray[s] = true;
                                if (this.countFirstEntry) break;
                            }
                            blArray = new boolean[this.maxTargetIndex + 1];
                            for (n9 = n10; n9 >= 0; --n9) {
                                s = this.targets[voxelArray[n9].x][voxelArray[n9].y][voxelArray[n9].z];
                                if (s <= 0 || blArray[s]) continue;
                                int[] nArray = this.streamlineCounts[n14];
                                short s6 = s;
                                nArray[s6] = nArray[s6] + 1;
                                blArray[s] = true;
                                if (!this.countFirstEntry) {
                                    continue;
                                }
                                break block15;
                            }
                            break block15;
                        }
                        if (!this.countFirstEntry) break block17;
                        d2 = -1.0;
                        d = -1.0;
                        n2 = 0;
                        n = 0;
                        for (n7 = n11; n7 < n8; ++n7) {
                            point3D = tract.getPoint(n7);
                            n6 = (int)(point3D.x / this.xVoxelDim);
                            n5 = (int)(point3D.y / this.yVoxelDim);
                            n4 = (int)(point3D.z / this.zVoxelDim);
                            n3 = this.targets[n6][n5][n4];
                            if (n3 <= 0) continue;
                            d2 = tract.pathLengthFromSeed(n7);
                            n2 = n3;
                            break;
                        }
                        for (n7 = n11; n7 >= 0; --n7) {
                            point3D = tract.getPoint(n7);
                            n6 = (int)(point3D.x / this.xVoxelDim);
                            n5 = (int)(point3D.y / this.yVoxelDim);
                            n4 = (int)(point3D.z / this.zVoxelDim);
                            n3 = this.targets[n6][n5][n4];
                            if (n3 <= 0) continue;
                            d = tract.pathLengthFromSeed(n7);
                            n = n3;
                            break;
                        }
                        if (!(d2 < 0.0)) break block18;
                        if (!(d > 0.0)) break block15;
                        int[] nArray = this.streamlineCounts[0];
                        int n15 = n;
                        nArray[n15] = nArray[n15] + 1;
                        break block15;
                    }
                    if (!(d < 0.0)) break block19;
                    if (!(d2 > 0.0)) break block15;
                    int[] nArray = this.streamlineCounts[0];
                    int n16 = n2;
                    nArray[n16] = nArray[n16] + 1;
                    break block15;
                }
                if (d2 < d) {
                    int[] nArray = this.streamlineCounts[0];
                    int n17 = n2;
                    nArray[n17] = nArray[n17] + 1;
                } else {
                    int[] nArray = this.streamlineCounts[0];
                    int n18 = n;
                    nArray[n18] = nArray[n18] + 1;
                }
                break block15;
            }
            int n = voxelArray.length;
            int n19 = 1;
            short s = this.targets[voxelArray[0].x][voxelArray[0].y][voxelArray[0].z];
            if (s > 0) {
                int[] nArray = this.streamlineCounts[0];
                short s7 = s;
                nArray[s7] = nArray[s7] + 1;
                blArray[s] = true;
            }
            while (n19 < n) {
                s = this.targets[voxelArray[n19].x][voxelArray[n19].y][voxelArray[n19].z];
                if (s > 0 && !blArray[s]) {
                    int[] nArray = this.streamlineCounts[0];
                    short s8 = s;
                    nArray[s8] = nArray[s8] + 1;
                    blArray[s] = true;
                }
                ++n19;
            }
        }
    }

    public int[][][][] getStreamlineCounts() {
        int[][][][] nArray = null;
        nArray = this.directional ? new int[2][this.xDataDim][this.yDataDim][this.zDataDim] : new int[1][this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.zDataDim; ++k) {
                    if (this.targets[i][j][k] <= 0) continue;
                    nArray[0][i][j][k] = this.streamlineCounts[0][this.targets[i][j][k]];
                    if (!this.directional) continue;
                    nArray[1][i][j][k] = this.streamlineCounts[1][this.targets[i][j][k]];
                }
            }
        }
        return nArray;
    }

    public double[][][][] getConnectionProbabilities() {
        double[][][][] dArray = null;
        dArray = this.directional ? new double[2][this.xDataDim][this.yDataDim][this.zDataDim] : new double[1][this.xDataDim][this.yDataDim][this.zDataDim];
        double d = this.totalStreamlines;
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.zDataDim; ++k) {
                    if (this.targets[i][j][k] <= 0) continue;
                    dArray[0][i][j][k] = (double)this.streamlineCounts[0][this.targets[i][j][k]] / d;
                    if (!this.directional) continue;
                    dArray[1][i][j][k] = (double)this.streamlineCounts[1][this.targets[i][j][k]] / d;
                }
            }
        }
        return dArray;
    }

    public int totalStreamlines() {
        return this.totalStreamlines;
    }

    protected int[][] getStreamlineCountsArray() {
        int n = this.directional ? 2 : 1;
        int[][] nArray = new int[n][this.maxTargetIndex + 1];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.streamlineCounts[i], this.minTargetIndex, nArray[i], this.minTargetIndex, this.numTargets);
        }
        return nArray;
    }

    public void setCountFirstEntry(boolean bl) {
        this.countFirstEntry = bl;
    }
}

