/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import misc.LoggedException;
import numerics.Point3D;
import numerics.RealMatrix;
import tractography.Tract;
import tractography.TractCollection;
import tractography.Voxel;
import tractography.VoxelList;

public class StreamlineROI_Filter {
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;
    private final int xDataDim;
    private final int yDataDim;
    private final int zDataDim;
    private RealMatrix trans = null;
    private short[][][] waypoints;
    private int minWaypointIndex = Integer.MAX_VALUE;
    private int maxWaypointIndex = -1;
    private int numWaypoints = 0;
    private int minTractPoints = 0;
    private double minTractLength = 0.0;
    private int maxTractPoints = 0;
    private double maxTractLength = 0.0;
    private short[][][] exclusionROI;
    private boolean haveExclusionROIs = false;
    private short[][][] endZones;
    private boolean haveEndZones = false;
    private boolean discardInExclusionROI = false;
    private boolean truncateLoops = false;
    private boolean discardLoops = false;
    private boolean resample = true;
    private double resampleStepSize;

    public StreamlineROI_Filter(int[] nArray, double[] dArray) {
        this(nArray[0], nArray[1], nArray[2], dArray[0], dArray[1], dArray[2]);
    }

    public StreamlineROI_Filter(int n, int n2, int n3, double d, double d2, double d3) {
        this.xDataDim = n;
        this.yDataDim = n2;
        this.zDataDim = n3;
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
        double d4 = d;
        if (d2 < d4) {
            d4 = d2;
        }
        if (d3 < d4) {
            d4 = d3;
        }
        this.resampleStepSize = d4 / 10.0;
        this.exclusionROI = new short[n][n2][n3];
    }

    public void setWaypoints(short[][][] sArray) {
        if (sArray.length != this.xDataDim || sArray[0].length != this.yDataDim || sArray[0][0].length != this.zDataDim) {
            throw new LoggedException("Waypoint dimensions " + sArray.length + " " + sArray[0].length + " " + sArray[0][0].length + " do not match seed space dimensions " + this.xDataDim + " " + this.yDataDim + " " + this.zDataDim);
        }
        this.waypoints = sArray;
        this.numWaypoints = 0;
        boolean[] blArray = new boolean[Short.MAX_VALUE];
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.zDataDim; ++k) {
                    int n = sArray[i][j][k];
                    if (n > 0 && n < this.minWaypointIndex) {
                        this.minWaypointIndex = n;
                    }
                    if (n > 0 && n > this.maxWaypointIndex) {
                        this.maxWaypointIndex = n;
                    }
                    if (n <= 0 || blArray[n]) continue;
                    blArray[n] = true;
                    ++this.numWaypoints;
                }
            }
        }
    }

    public void setEndZones(short[][][] sArray) {
        if (sArray.length != this.xDataDim || sArray[0].length != this.yDataDim || sArray[0][0].length != this.zDataDim) {
            throw new LoggedException("EndZone dimensions " + sArray.length + " " + sArray[0].length + " " + sArray[0][0].length + " do not match seed space dimensions " + this.xDataDim + " " + this.yDataDim + " " + this.zDataDim);
        }
        this.endZones = sArray;
        this.haveEndZones = true;
    }

    public void setExclusionROIs(short[][][] sArray) {
        if (sArray.length != this.xDataDim || sArray[0].length != this.yDataDim || sArray[0][0].length != this.zDataDim) {
            throw new LoggedException("Exclusion ROI dimensions " + sArray.length + " " + sArray[0].length + " " + sArray[0][0].length + " do not match seed space dimensions " + this.xDataDim + " " + this.yDataDim + " " + this.zDataDim);
        }
        this.exclusionROI = sArray;
        this.haveExclusionROIs = true;
    }

    public void setTransIntoSeedSpace(RealMatrix realMatrix) {
        this.trans = realMatrix;
    }

    public TractCollection processTract(Tract tract) {
        TractCollection tractCollection = new TractCollection(2, 100.0);
        tractCollection.addTract(tract);
        return this.processTracts(tractCollection);
    }

    public TractCollection processTracts(TractCollection tractCollection) {
        TractCollection tractCollection2 = new TractCollection(tractCollection.numberOfTracts() + 1, 100.0);
        for (int i = 0; i < tractCollection.numberOfTracts(); ++i) {
            Tract tract = tractCollection.getTract(i);
            if (tract.numberOfPoints() < this.minTractPoints) continue;
            if (this.maxTractPoints > 0 && tract.numberOfPoints() > this.maxTractPoints) {
                tract.truncateToMaxPoints(this.maxTractPoints);
            }
            if (this.minTractLength > 0.0 && tract.length() < this.minTractLength) continue;
            if (this.maxTractLength > 0.0 && tract.length() > this.maxTractLength) {
                tract.truncateToMaxLength(this.maxTractLength);
            }
            if (this.trans != null) {
                tract.transform(this.trans);
            }
            if (this.resample) {
                tract = tract.resample(this.resampleStepSize);
            }
            boolean bl = false;
            if (this.xDataDim > 0 && this.xVoxelDim > 0.0) {
                bl = this.truncateToExclusion(tract);
            }
            boolean bl2 = true;
            if (this.numWaypoints > 0) {
                bl2 = this.passesWaypoints(tract, this.truncateLoops, this.discardLoops);
            }
            boolean bl3 = true;
            if (bl2 && this.haveEndZones) {
                bl3 = this.truncateToEndZones(tract);
            }
            if (!bl2 || !bl3 || bl && this.discardInExclusionROI) continue;
            tractCollection2.addTract(tract);
        }
        return tractCollection2;
    }

    private final boolean passesWaypoints(Tract tract, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        Object object;
        if (this.numWaypoints == 0) {
            return true;
        }
        if (tract.numberOfPoints() == 1) {
            object = tract.getPoint(0);
            n3 = (int)(((Point3D)object).x / this.xVoxelDim);
            n2 = (int)(((Point3D)object).y / this.yVoxelDim);
            n = (int)(((Point3D)object).z / this.zVoxelDim);
            if (n3 < 0 || n3 >= this.xDataDim || n2 < 0 || n2 >= this.yDataDim || n < 0 || n >= this.zDataDim) {
                return false;
            }
        }
        object = new boolean[this.maxWaypointIndex + 1];
        n3 = 0;
        if (this.truncateLoops || this.discardLoops) {
            short s;
            int n4;
            int n5;
            int n6;
            int n7;
            Point3D[] point3DArray = tract.getPoints();
            n = tract.seedPointIndex();
            int n8 = 0;
            int n9 = point3DArray.length - 1;
            short s2 = 0;
            for (n7 = n; n7 >= 0; --n7) {
                n6 = (int)(point3DArray[n7].x / this.xVoxelDim);
                n5 = (int)(point3DArray[n7].y / this.yVoxelDim);
                n4 = (int)(point3DArray[n7].z / this.zVoxelDim);
                s = this.waypoints[n6][n5][n4];
                if (s > 0) {
                    if (object[s] != false) {
                        if (s2 == s) continue;
                        if (this.discardLoops) {
                            return false;
                        }
                        n8 = n7;
                        continue;
                    }
                    object[s] = true;
                    ++n3;
                    s2 = s;
                    continue;
                }
                s2 = 0;
            }
            s2 = 0;
            for (n7 = n; n7 < point3DArray.length; ++n7) {
                n6 = (int)(point3DArray[n7].x / this.xVoxelDim);
                n5 = (int)(point3DArray[n7].y / this.yVoxelDim);
                n4 = (int)(point3DArray[n7].z / this.zVoxelDim);
                s = this.waypoints[n6][n5][n4];
                if (n7 == n) {
                    s2 = s;
                }
                if (s > 0) {
                    if (object[s] != false) {
                        if (s2 == s) continue;
                        if (this.discardLoops) {
                            return false;
                        }
                        n9 = n7;
                        continue;
                    }
                    object[s] = true;
                    ++n3;
                    s2 = s;
                    continue;
                }
                s2 = 0;
            }
            if (n8 > 0 || n9 < point3DArray.length - 1) {
                tract.chop(n8, n9);
            }
        } else {
            VoxelList voxelList = tract.toVoxelList(this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
            int n10 = voxelList.size();
            for (n2 = 0; n3 < this.numWaypoints && n2 < n10; ++n2) {
                Voxel voxel = voxelList.getVoxel(n2);
                short s = this.waypoints[voxel.x][voxel.y][voxel.z];
                if (s <= 0 || object[s] != false) continue;
                object[s] = true;
                ++n3;
            }
        }
        return n3 == this.numWaypoints;
    }

    private final boolean entersExclusion(Tract tract) {
        int n;
        int n2;
        Object object;
        if (!this.haveExclusionROIs) {
            return false;
        }
        if (tract.numberOfPoints() == 1) {
            object = tract.getPoint(0);
            n2 = (int)(((Point3D)object).x / this.xVoxelDim);
            n = (int)(((Point3D)object).y / this.yVoxelDim);
            int n3 = (int)(((Point3D)object).z / this.zVoxelDim);
            if (n2 < 0 || n2 >= this.xDataDim || n < 0 || n >= this.yDataDim || n3 < 0 || n3 >= this.zDataDim) {
                return false;
            }
        }
        object = tract.toVoxelList(this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
        n2 = ((VoxelList)object).size();
        for (n = 0; n < n2; ++n) {
            Voxel voxel = ((VoxelList)object).getVoxel(n);
            if (this.exclusionROI[voxel.x][voxel.y][voxel.z] <= 0) continue;
            return true;
        }
        return false;
    }

    private final boolean truncateToExclusion(Tract tract) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Point3D[] point3DArray = tract.getPoints();
        if (point3DArray.length == 1) {
            n7 = (int)(point3DArray[0].x / this.xVoxelDim);
            n6 = (int)(point3DArray[0].y / this.yVoxelDim);
            n5 = (int)(point3DArray[0].z / this.zVoxelDim);
            if (n7 < 0 || n7 >= this.xDataDim || n6 < 0 || n6 >= this.yDataDim || n5 < 0 || n5 >= this.zDataDim) {
                return false;
            }
            if (this.exclusionROI[n7][n6][n5] > 0) {
                return true;
            }
        }
        n7 = tract.seedPointIndex();
        n6 = 0;
        n5 = point3DArray.length - 1;
        boolean bl = false;
        for (n4 = n7; n4 >= 0; --n4) {
            n3 = (int)(point3DArray[n4].x / this.xVoxelDim);
            n2 = (int)(point3DArray[n4].y / this.yVoxelDim);
            n = (int)(point3DArray[n4].z / this.zVoxelDim);
            if (n3 < 0 || n3 >= this.xDataDim || n2 < 0 || n2 >= this.yDataDim || n < 0 || n >= this.zDataDim) {
                n6 = n4 + 1;
                break;
            }
            if (this.exclusionROI[n3][n2][n] <= 0) continue;
            n6 = n4;
            bl = true;
            break;
        }
        for (n4 = n7; n4 < point3DArray.length; ++n4) {
            n3 = (int)(point3DArray[n4].x / this.xVoxelDim);
            n2 = (int)(point3DArray[n4].y / this.yVoxelDim);
            n = (int)(point3DArray[n4].z / this.zVoxelDim);
            if (n3 < 0 || n3 >= this.xDataDim || n2 < 0 || n2 >= this.yDataDim || n < 0 || n >= this.zDataDim) {
                n5 = n4 - 1;
                break;
            }
            if (this.exclusionROI[n3][n2][n] <= 0) continue;
            n5 = n4;
            bl = true;
            break;
        }
        if (n6 >= n5) {
            tract.chop(n7, n7);
        } else if (n6 > 0 || n5 < point3DArray.length - 1) {
            tract.chop(n6, n5);
        }
        return bl;
    }

    private final boolean truncateToEndZones(Tract tract) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Point3D[] point3DArray = tract.getPoints();
        if (point3DArray.length == 1) {
            return false;
        }
        int n6 = n5 = tract.seedPointIndex();
        int n7 = n5;
        short s = this.endZones[(int)(point3DArray[n5].x / this.xVoxelDim)][(int)(point3DArray[n5].y / this.yVoxelDim)][(int)(point3DArray[n5].z / this.zVoxelDim)];
        short s2 = 0;
        short s3 = 0;
        for (n4 = n5; n4 >= 0; --n4) {
            n3 = (int)(point3DArray[n4].x / this.xVoxelDim);
            n2 = (int)(point3DArray[n4].y / this.yVoxelDim);
            n = (int)(point3DArray[n4].z / this.zVoxelDim);
            if (this.endZones[n3][n2][n] <= 0 || this.endZones[n3][n2][n] == s) continue;
            n6 = n4;
            s2 = this.endZones[n3][n2][n];
            break;
        }
        for (n4 = n5; n4 < point3DArray.length; ++n4) {
            n3 = (int)(point3DArray[n4].x / this.xVoxelDim);
            n2 = (int)(point3DArray[n4].y / this.yVoxelDim);
            n = (int)(point3DArray[n4].z / this.zVoxelDim);
            if (this.endZones[n3][n2][n] <= 0 || this.endZones[n3][n2][n] == s) continue;
            n7 = n4;
            s3 = this.endZones[n3][n2][n];
            break;
        }
        if (s > 0) {
            double d;
            if (s2 == 0 && s3 == 0) {
                return false;
            }
            double d2 = n6 < n5 ? tract.pathLengthFromSeed(n6) : Double.MAX_VALUE;
            double d3 = d = n7 > n5 ? tract.pathLengthFromSeed(n7) : Double.MAX_VALUE;
            if (d2 < d) {
                tract.chop(n6, n5);
            } else {
                tract.chop(n5, n7);
            }
            return true;
        }
        if (s2 == 0 || s3 == 0) {
            return false;
        }
        if (s2 == s3) {
            return false;
        }
        if (n6 > 0 || n7 < point3DArray.length - 1) {
            tract.chop(n6, n7);
        }
        return true;
    }

    public void setDiscardOnExclusionEntry(boolean bl) {
        this.discardInExclusionROI = bl;
    }

    public void setResampleTracts(boolean bl) {
        this.resample = bl;
    }

    public void setResampleStepSize(double d) {
        if (!(d > 0.0)) {
            throw new LoggedException("Can't resample step size to " + d);
        }
        this.resampleStepSize = d;
    }

    public void setMinTractPoints(int n) {
        this.minTractPoints = n;
    }

    public void setMinTractLength(double d) {
        this.minTractLength = d;
    }

    public void setMaxTractPoints(int n) {
        this.maxTractPoints = n;
    }

    public void setMaxTractLength(double d) {
        this.maxTractLength = d;
    }

    public void setTruncateLoops(boolean bl) {
        this.truncateLoops = bl;
    }

    public void setDiscardLoops(boolean bl) {
        this.discardLoops = bl;
        if (this.discardLoops) {
            this.truncateLoops = false;
        }
    }
}

