/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.Random;
import numerics.AxialDistribution;
import numerics.Vector3D;
import numerics.WatsonDistribution;
import tractography.PICoTractographyImage;
import tractography.SimplePICoRandomizer;

public class PICoWatsonRandomizer
extends SimplePICoRandomizer {
    protected final PICoTractographyImage image;
    protected final Random ran;

    protected PICoWatsonRandomizer(PICoTractographyImage pICoTractographyImage, Random random) {
        super(pICoTractographyImage.xDataDim(), pICoTractographyImage.yDataDim(), pICoTractographyImage.zDataDim());
        this.image = pICoTractographyImage;
        this.ran = random;
    }

    @Override
    protected AxialDistribution[] getPDFs(int n, int n2, int n3) {
        double[] dArray = this.image.getPICoPDFParams(n, n2, n3);
        Vector3D[] vector3DArray = this.image.getEigenvectors(n, n2, n3);
        AxialDistribution[] axialDistributionArray = new WatsonDistribution[vector3DArray.length / 3];
        for (int i = 0; i < axialDistributionArray.length; ++i) {
            axialDistributionArray[i] = dArray[i] >= 0.0 ? new WatsonDistribution(vector3DArray[3 * i], dArray[i], this.ran) : new WatsonDistribution(vector3DArray[3 * i + 2], dArray[i], this.ran);
        }
        return axialDistributionArray;
    }
}

