/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import data.VoxelOrderDataSource;
import java.util.Random;
import misc.LoggedException;
import numerics.Vector3D;
import tractography.PICoPDF;
import tractography.PICoRandomizer;
import tractography.TractographyImage;

public class PICoTractographyImage
extends TractographyImage {
    protected final double[][][][] pdfParams;
    protected final PICoRandomizer randomizer;
    protected final PICoPDF pdf;

    public PICoTractographyImage(VoxelOrderDataSource voxelOrderDataSource, int n, PICoPDF pICoPDF, int[] nArray, double[] dArray, Random random) {
        super(nArray, dArray, 3);
        this.pdf = pICoPDF;
        this.pdfParams = new double[this.xDataDim][this.yDataDim][this.zDataDim][];
        int n2 = pICoPDF.numParams;
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    double[] dArray2 = voxelOrderDataSource.nextVoxel();
                    this.numPDs[k][j][i] = (int)dArray2[0];
                    if (this.numPDs[k][j][i] < 0 || this.numPDs[k][j][i] > n) {
                        throw new LoggedException("Invalid number of components, " + this.numPDs[k][j][i] + ", in input data. " + "Check -inputmodel, PICo PDF and -numpds options.");
                    }
                    this.vectors[k][j][i] = new Vector3D[3 * this.numPDs[k][j][i]];
                    this.pdfParams[k][j][i] = new double[this.numPDs[k][j][i] * n2];
                    for (int i2 = 0; i2 < this.numPDs[k][j][i]; ++i2) {
                        int n3 = 2 + i2 * (10 + n2);
                        this.vectors[k][j][i][3 * i2] = new Vector3D(dArray2[n3], dArray2[n3 + 1], dArray2[n3 + 2]);
                        this.vectors[k][j][i][3 * i2 + 1] = new Vector3D(dArray2[n3 + 3], dArray2[n3 + 4], dArray2[n3 + 5]);
                        this.vectors[k][j][i][3 * i2 + 2] = new Vector3D(dArray2[n3 + 6], dArray2[n3 + 7], dArray2[n3 + 8]);
                        for (int i3 = 0; i3 < n2; ++i3) {
                            this.pdfParams[k][j][i][n2 * i2 + i3] = dArray2[n3 + 9 + i3];
                        }
                    }
                }
            }
        }
        this.computeIsotropicMask();
        this.randomizer = pICoPDF.getRandomizer(this, random);
    }

    protected PICoTractographyImage(Vector3D[][][][] vector3DArray, double[][][][] dArray, PICoPDF pICoPDF, int[] nArray, double[] dArray2, Random random) {
        super(vector3DArray, dArray2, 3);
        this.pdfParams = dArray;
        this.pdf = pICoPDF;
        this.randomizer = pICoPDF.getRandomizer(this, random);
    }

    protected PICoTractographyImage(PICoTractographyImage pICoTractographyImage, Random random) {
        super(new int[]{pICoTractographyImage.xDataDim, pICoTractographyImage.yDataDim, pICoTractographyImage.zDataDim}, new double[]{pICoTractographyImage.xVoxelDim, pICoTractographyImage.yVoxelDim, pICoTractographyImage.zVoxelDim}, 3);
        this.pdfParams = new double[this.xDataDim][this.yDataDim][this.zDataDim][];
        this.pdf = pICoTractographyImage.pdf;
        this.randomizer = this.pdf.getRandomizer(this, random);
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    int n;
                    this.numPDs[k][j][i] = pICoTractographyImage.numPDs[k][j][i];
                    this.vectors[k][j][i] = new Vector3D[3 * this.numPDs[k][j][i]];
                    for (n = 0; n < 3 * this.numPDs[k][j][i]; ++n) {
                        this.vectors[k][j][i][n] = pICoTractographyImage.vectors[k][j][i][n];
                    }
                    n = pICoTractographyImage.pdfParams[k][j][i].length;
                    this.pdfParams[k][j][i] = new double[n];
                    for (int i2 = 0; i2 < n; ++i2) {
                        this.pdfParams[k][j][i][i2] = pICoTractographyImage.pdfParams[k][j][i][i2];
                    }
                }
            }
        }
        this.computeIsotropicMask();
    }

    protected Vector3D[] getEigenvectors(int n, int n2, int n3) {
        return this.vectors[n][n2][n3];
    }

    protected double[] getPICoPDFParams(int n, int n2, int n3) {
        return this.pdfParams[n][n2][n3];
    }

    @Override
    public Vector3D[] getPDs(int n, int n2, int n3) {
        return this.randomizer.getRandomizedPDs(n, n2, n3);
    }

    public static final PICoTractographyImage getPICoTractographyImage(String string, String string2, int n, PICoPDF pICoPDF, double[][][] dArray, double d, int[] nArray, double[] dArray2, Random random) {
        int n2 = pICoPDF.numParams;
        int n3 = 1 + n * (10 + n2);
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, n3, string2);
        PICoTractographyImage pICoTractographyImage = new PICoTractographyImage(voxelOrderDataSource, n, pICoPDF, nArray, dArray2, random);
        if (dArray != null) {
            pICoTractographyImage.computeIsotropicMask(dArray, d);
        }
        return pICoTractographyImage;
    }
}

