/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.Random;
import numerics.Vector3D;
import tractography.NonInterpolatedFibreTracker;
import tractography.TractographyImage;

public class NonIntProbFibreTracker
extends NonInterpolatedFibreTracker {
    protected final Vector3D[][][][] voxelPDs;
    private final Random ran;

    public NonIntProbFibreTracker(TractographyImage tractographyImage, double d, Random random) {
        super(tractographyImage, d);
        this.ran = random;
        this.voxelPDs = new Vector3D[this.xDataDim][this.yDataDim][this.zDataDim][];
    }

    @Override
    protected final Vector3D[] getPDs(int n, int n2, int n3) {
        if (this.visitedVoxel[n][n2][n3] == 0) {
            this.voxelPDs[n][n2][n3] = this.image.getPDs(n, n2, n3);
        }
        return this.voxelPDs[n][n2][n3];
    }

    protected final Vector3D[] getPDs(int n, int n2, int n3, Vector3D vector3D) {
        if (this.visitedVoxel[n][n2][n3] == 0) {
            this.voxelPDs[n][n2][n3] = this.image.getPDs(n, n2, n3, vector3D);
        }
        return this.voxelPDs[n][n2][n3];
    }

    @Override
    protected Vector3D getTrackingDirection(int n, int n2, int n3, Vector3D vector3D) {
        if (this.visitedVoxel[n][n2][n3] == 0) {
            this.getPDs(n, n2, n3, vector3D);
        }
        Vector3D vector3D2 = null;
        if (this.voxelPDs[n][n2][n3].length == 1) {
            vector3D2 = this.voxelPDs[n][n2][n3][0];
        } else {
            double[] dArray = new double[this.voxelPDs[n][n2][n3].length];
            for (int i = 0; i < this.voxelPDs[n][n2][n3].length; ++i) {
                dArray[i] = Math.abs(this.voxelPDs[n][n2][n3][i].dot(vector3D));
            }
            double d = -1.0;
            int n4 = -1;
            for (int i = 0; i < this.voxelPDs[n][n2][n3].length; ++i) {
                if (!(dArray[i] > d)) continue;
                d = dArray[i];
                n4 = i;
            }
            vector3D2 = this.voxelPDs[n][n2][n3][n4];
        }
        if (vector3D.dot(vector3D2) > 0.0) {
            return vector3D2;
        }
        return vector3D2.negated();
    }
}

