/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.Random;
import numerics.Point3D;
import numerics.Vector3D;
import tractography.EightNeighbourInterpolator;
import tractography.ImageInterpolator;
import tractography.ProbabilisticInterpolator;
import tractography.TractographyImage;

public class NeighbourChoiceInterpolator
extends EightNeighbourInterpolator
implements ProbabilisticInterpolator,
ImageInterpolator {
    private final double[] interpFraction = new double[8];
    private final int[] dims = new int[6];
    private final TractographyImage image;
    private final Random ran;
    private Vector3D[][][][] voxelPDs;
    private boolean[][][] randomized;
    private boolean[][][] background;
    private final boolean[] line = new boolean[this.zDataDim];

    public NeighbourChoiceInterpolator(TractographyImage tractographyImage, Random random) {
        super(tractographyImage.xDataDim(), tractographyImage.yDataDim(), tractographyImage.zDataDim(), tractographyImage.xVoxelDim(), tractographyImage.yVoxelDim(), tractographyImage.zVoxelDim());
        this.image = tractographyImage;
        this.ran = random;
        this.voxelPDs = new Vector3D[this.xDataDim][this.yDataDim][this.zDataDim][];
        this.randomized = new boolean[this.xDataDim][this.yDataDim][this.zDataDim];
        this.background = new boolean[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    this.background[k][j][i] = tractographyImage.numberOfPDs(k, j, i) == 0;
                }
            }
        }
    }

    @Override
    public Vector3D getTrackingDirection(Point3D point3D, Vector3D vector3D) {
        this.setInterpolationVoxels(point3D, this.interpFraction, this.dims);
        double d = 0.0;
        for (int i = 0; i < 8; ++i) {
            int n = this.dims[i / 4];
            int n2 = this.dims[2 + i / 2 % 2];
            int n3 = this.dims[4 + i % 2];
            if (this.background[n][n2][n3]) {
                this.interpFraction[i] = 0.0;
            }
            d += this.interpFraction[i];
        }
        double d2 = this.ran.nextDouble() * d;
        double d3 = 0.0;
        for (int i = 0; i < 8; ++i) {
            if (!(d2 - (d3 += this.interpFraction[i]) < 1.0E-9)) continue;
            int n = this.dims[i / 4];
            int n4 = this.dims[2 + i / 2 % 2];
            int n5 = this.dims[4 + i % 2];
            if (!this.randomized[n][n4][n5]) {
                this.voxelPDs[n][n4][n5] = this.image.getPDs(n, n4, n5, vector3D);
                this.randomized[n][n4][n5] = true;
            }
            Vector3D vector3D2 = null;
            if (this.voxelPDs[n][n4][n5].length == 1) {
                vector3D2 = this.voxelPDs[n][n4][n5][0];
            } else {
                double[] dArray = new double[this.voxelPDs[n][n4][n5].length];
                for (int j = 0; j < this.voxelPDs[n][n4][n5].length; ++j) {
                    dArray[j] = Math.abs(this.voxelPDs[n][n4][n5][j].dot(vector3D));
                }
                double d4 = -1.0;
                int n6 = -1;
                for (int j = 0; j < this.voxelPDs[n][n4][n5].length; ++j) {
                    if (!(dArray[j] > d4)) continue;
                    d4 = dArray[j];
                    n6 = j;
                }
                vector3D2 = this.voxelPDs[n][n4][n5][n6];
            }
            if (vector3D.dot(vector3D2) > 0.0) {
                return vector3D2;
            }
            return vector3D2.negated();
        }
        throw new IllegalStateException("Rejected all 8 neighbourhood tensors. cumulsum == " + d3 + ", interpFractions == {" + this.interpFraction[0] + ", " + this.interpFraction[1] + ", " + this.interpFraction[2] + ", " + this.interpFraction[3] + ", " + this.interpFraction[4] + ", " + this.interpFraction[5] + ", " + this.interpFraction[6] + ", " + this.interpFraction[7] + "}");
    }

    @Override
    public Vector3D getTrackingDirection(Point3D point3D, int n, boolean bl) {
        int n2 = (int)(point3D.x / this.xVoxelDim);
        int n3 = (int)(point3D.y / this.yVoxelDim);
        int n4 = (int)(point3D.z / this.zVoxelDim);
        if (!this.randomized[n2][n3][n4]) {
            this.voxelPDs[n2][n3][n4] = this.image.getPDs(n2, n3, n4);
            this.randomized[n2][n3][n4] = true;
        }
        if (bl) {
            return this.getTrackingDirection(point3D, this.voxelPDs[n2][n3][n4][n]);
        }
        return this.getTrackingDirection(point3D, this.voxelPDs[n2][n3][n4][n]).negated();
    }

    @Override
    public final void resetRandomization() {
        for (int i = 0; i < this.yDataDim; ++i) {
            for (int j = 0; j < this.xDataDim; ++j) {
                System.arraycopy(this.line, 0, this.randomized[j][i], 0, this.zDataDim);
            }
        }
    }
}

