/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.ArrayList;
import java.util.List;
import misc.LoggedException;
import numerics.Vector3D;

public class HistBin {
    private double eigenvalue1;
    private double eigenvalue2;
    private List<Vector3D> fibreOrientationsList;

    public HistBin(double d, double d2) {
        this.eigenvalue1 = d;
        this.eigenvalue2 = d2;
        this.fibreOrientationsList = new ArrayList<Vector3D>();
    }

    public double[] getEigs() {
        double[] dArray = new double[]{this.eigenvalue1, this.eigenvalue2};
        return dArray;
    }

    public double[] getLogEigs() {
        double[] dArray = new double[]{Math.log(this.eigenvalue1), Math.log(this.eigenvalue2)};
        return dArray;
    }

    public double getTrace() {
        return this.eigenvalue1 + this.eigenvalue2;
    }

    public double getLogTrace() {
        return Math.log(this.eigenvalue1 + this.eigenvalue2);
    }

    public Vector3D[] getDirsList() {
        if (this.fibreOrientationsList.size() > 0) {
            Vector3D[] vector3DArray = new Vector3D[this.fibreOrientationsList.size()];
            this.fibreOrientationsList.toArray(vector3DArray);
            return vector3DArray;
        }
        return null;
    }

    public int getNumDirs() {
        return this.fibreOrientationsList.size();
    }

    public void addDirToList(Vector3D vector3D) {
        if (!this.fibreOrientationsList.add(vector3D)) {
            throw new LoggedException("could not add fibre-orientation estimate to histgram!");
        }
    }
}

