/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import Jama.Matrix;
import data.DataSourceException;
import data.DataSynthesizer;
import data.GaussianMixture;
import data.ModelPDF;
import imaging.Scheme;
import inverters.DT_Inversion;
import inverters.ModelIndex;
import inverters.TwoTensorInversion;
import java.util.Random;
import misc.DT;
import numerics.RealMatrix;
import numerics.Rotations;
import numerics.Vector3D;

public abstract class DT_LookupTableGenerator {
    protected Vector3D e1Vec;
    protected Vector3D e2Vec;
    protected Vector3D e3Vec;
    private Matrix e1;
    private Matrix e2;
    private Matrix e3;
    private Matrix e1T;
    private Matrix e2T;
    private Matrix e3T;
    private Matrix minusE1;
    private Matrix minusE2;
    private Matrix minusE3;
    private Matrix minusE1T;
    private Matrix minusE2T;
    private Matrix minusE3T;
    protected double snr;
    protected double trace;
    protected Scheme imPars;
    protected Random ran;
    public static final int WATSON = 0;
    public static final int BINGHAM = 1;
    public static final int ACG = 2;

    protected DT_LookupTableGenerator(Scheme scheme, double d, double d2, Random random) {
        this.imPars = scheme;
        this.snr = d;
        this.trace = d2;
        this.ran = random;
        this.initializeEigenvectors(this.ran);
    }

    protected DT getTensor(double d, double d2, Random random) {
        double d3;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Require 0.0 <= FA <= 1.0");
        }
        double d4 = d2;
        double d5 = (-3.0 * d4 + 2.0 * d * d * d4 - 2.0 * Math.sqrt(3.0 * d * d * d4 * d4 - 2.0 * d * d * d * d * d4 * d4)) / (3.0 * (-3.0 + 2.0 * d * d));
        double d6 = d3 = (d4 - d5) / 2.0;
        return this.getFullySpecifiedTensor(d5, d3, d6, random);
    }

    protected DT getTensor(double d, double d2, double d3, Random random) {
        double d4 = d3 / (d + d2 + 1.0);
        double d5 = d4 * d2;
        double d6 = d4 * d;
        return this.getFullySpecifiedTensor(d6, d5, d4, random);
    }

    protected DT getFullySpecifiedTensor(double d, double d2, double d3, Random random) {
        Matrix matrix = null;
        Matrix matrix2 = null;
        Matrix matrix3 = null;
        matrix = random.nextDouble() < 0.5 ? this.minusE1.times(this.minusE1T) : this.e1.times(this.e1T);
        matrix2 = random.nextDouble() < 0.5 ? this.minusE2.times(this.minusE2T) : this.e2.times(this.e2T);
        matrix3 = random.nextDouble() < 0.5 ? this.minusE3.times(this.minusE3T) : this.e3.times(this.e3T);
        Matrix matrix4 = matrix.timesEquals(d).plusEquals(matrix2.timesEquals(d2).plusEquals(matrix3.timesEquals(d3)));
        double[][] dArray = matrix4.getArray();
        DT dT = new DT(dArray[0][0], dArray[0][1], dArray[0][2], dArray[1][1], dArray[1][2], dArray[2][2]);
        return dT;
    }

    protected DT getTensor(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, double d, double d2, Random random) {
        if (d == 0.0) {
            return this.getTensor(vector3D, vector3D2, vector3D3, 1.0, 1.0, d2, random);
        }
        if (d > 0.0 && d < 1.0) {
            double d3 = d2;
            double d4 = (-3.0 * d3 + 2.0 * d * d * d3 - 2.0 * Math.sqrt(3.0 * d * d * d3 * d3 - 2.0 * d * d * d * d * d3 * d3)) / (3.0 * (-3.0 + 2.0 * d * d));
            double d5 = (d3 - d4) / 2.0;
            return this.getTensor(vector3D, vector3D2, vector3D3, d4 / d5, 1.0, d2, random);
        }
        throw new IllegalArgumentException("Require 0 <= FA < 1");
    }

    protected DT getTensor(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, double d, double d2, double d3, Random random) {
        double d4 = d3 / (d + d2 + 1.0);
        double d5 = d4 * d2;
        double d6 = d4 * d;
        Matrix matrix = null;
        Matrix matrix2 = null;
        Matrix matrix3 = null;
        Matrix matrix4 = vector3D.toJamaMatrix();
        Matrix matrix5 = vector3D2.toJamaMatrix();
        Matrix matrix6 = vector3D3.toJamaMatrix();
        matrix = random.nextDouble() < 0.5 ? matrix4.times(matrix4.transpose()) : matrix4.timesEquals(-1.0).times(matrix4.transpose());
        matrix2 = random.nextDouble() < 0.5 ? matrix5.times(matrix5.transpose()) : matrix5.timesEquals(-1.0).times(matrix5.transpose());
        matrix3 = random.nextDouble() < 0.5 ? matrix6.times(matrix6.transpose()) : matrix6.timesEquals(-1.0).times(matrix6.transpose());
        Matrix matrix7 = matrix.timesEquals(d6).plusEquals(matrix2.timesEquals(d5).plusEquals(matrix3.timesEquals(d4)));
        double[][] dArray = matrix7.getArray();
        DT dT = new DT(dArray[0][0], dArray[0][1], dArray[0][2], dArray[1][1], dArray[1][2], dArray[2][2]);
        return dT;
    }

    protected static DT[][] getNoisyTensors(DT[] dTArray, double[] dArray, ModelIndex modelIndex, Scheme scheme, double d, int n, Random random) {
        GaussianMixture gaussianMixture = new GaussianMixture(dTArray, dArray);
        DataSynthesizer dataSynthesizer = new DataSynthesizer((ModelPDF)gaussianMixture, scheme, d, n, random);
        DT[][] dTArray2 = new DT[dTArray.length][n];
        if (dTArray.length == 1) {
            DT_Inversion dT_Inversion = DT_Inversion.getIndexedDT_Inversion(modelIndex, scheme);
            for (int i = 0; i < n; ++i) {
                try {
                    double[] dArray2 = dT_Inversion.invert(dataSynthesizer.nextVoxel());
                    if (dArray2[0] != 0.0) continue;
                    dTArray2[0][i] = new DT(dArray2[2], dArray2[3], dArray2[4], dArray2[5], dArray2[6], dArray2[7]);
                    continue;
                }
                catch (DataSourceException dataSourceException) {
                    System.out.println(dataSourceException);
                }
            }
        } else {
            TwoTensorInversion twoTensorInversion = new TwoTensorInversion(scheme, modelIndex, ModelIndex.NLDT_POS);
            for (int i = 0; i < n; ++i) {
                double[] dArray3 = null;
                try {
                    dArray3 = twoTensorInversion.invert(dataSynthesizer.nextVoxel());
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    continue;
                }
                if (dArray3[0] != 0.0) {
                    System.err.println("fittedData[0]: " + dArray3[0]);
                    continue;
                }
                dTArray2[0][i] = new DT(dArray3[4], dArray3[5], dArray3[6], dArray3[7], dArray3[8], dArray3[9]);
                dTArray2[1][i] = new DT(dArray3[11], dArray3[12], dArray3[13], dArray3[14], dArray3[15], dArray3[16]);
            }
        }
        return dTArray2;
    }

    protected void initializeEigenvectors(RealMatrix realMatrix) {
        this.e1Vec = new Vector3D(1.0, 0.0, 0.0);
        this.e2Vec = new Vector3D(0.0, 1.0, 0.0);
        this.e3Vec = new Vector3D(0.0, 0.0, 1.0);
        this.e1Vec = Rotations.rotateVector(this.e1Vec, realMatrix);
        this.e2Vec = Rotations.rotateVector(this.e2Vec, realMatrix);
        this.e3Vec = Rotations.rotateVector(this.e3Vec, realMatrix);
        this.e1 = this.e1Vec.toJamaMatrix();
        this.e2 = this.e2Vec.toJamaMatrix();
        this.e3 = this.e3Vec.toJamaMatrix();
        this.e1T = this.e1.transpose();
        this.e2T = this.e2.transpose();
        this.e3T = this.e3.transpose();
        this.minusE1 = this.e1.times(-1.0);
        this.minusE2 = this.e2.times(-1.0);
        this.minusE3 = this.e3.times(-1.0);
        this.minusE1T = this.minusE1.transpose();
        this.minusE2T = this.minusE2.transpose();
        this.minusE3T = this.minusE3.transpose();
    }

    protected void initializeEigenvectors(Random random) {
        double d = Math.acos(2.0 * random.nextDouble() - 1.0);
        double d2 = Math.PI * 2 * random.nextDouble();
        this.e1Vec = Vector3D.vectorFromSPC(1.0, d, d2);
        this.e2Vec = Rotations.rotateVector(Rotations.X_AXIS, Rotations.Y_AXIS, d);
        this.e2Vec = Rotations.rotateVector(this.e2Vec, Rotations.Z_AXIS, d2);
        this.e2Vec = Rotations.rotateVector(this.e2Vec, this.e1Vec, Math.PI * 2 * random.nextDouble());
        this.e3Vec = this.e1Vec.cross(this.e2Vec);
        this.e1 = this.e1Vec.toJamaMatrix();
        this.e2 = this.e2Vec.toJamaMatrix();
        this.e3 = this.e3Vec.toJamaMatrix();
        this.e1T = this.e1.transpose();
        this.e2T = this.e2.transpose();
        this.e3T = this.e3.transpose();
        this.minusE1 = this.e1.times(-1.0);
        this.minusE2 = this.e2.times(-1.0);
        this.minusE3 = this.e3.times(-1.0);
        this.minusE1T = this.minusE1.transpose();
        this.minusE2T = this.minusE2.transpose();
        this.minusE3T = this.minusE3.transpose();
    }

    public abstract double[][][][] generateLUT(double var1, double var3, double var5, int var7, ModelIndex var8, boolean var9, boolean var10, boolean var11);
}

