/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import misc.DT;
import numerics.Point3D;
import numerics.Vector3D;
import tractography.DT_TractographyImage;
import tractography.EightNeighbourInterpolator;
import tractography.ImageInterpolator;

public final class DT_LinearInterpolator
extends EightNeighbourInterpolator
implements ImageInterpolator {
    private DT_TractographyImage image;

    public DT_LinearInterpolator(DT_TractographyImage dT_TractographyImage) {
        super(dT_TractographyImage.xDataDim(), dT_TractographyImage.yDataDim(), dT_TractographyImage.zDataDim(), dT_TractographyImage.xVoxelDim(), dT_TractographyImage.yVoxelDim(), dT_TractographyImage.zVoxelDim());
        this.image = dT_TractographyImage;
    }

    protected DT getInterpolatedTensor(Point3D point3D, Vector3D vector3D) {
        int n;
        double[] dArray = new double[8];
        int[] nArray = new int[6];
        int n2 = this.setInterpolationVoxels(point3D, dArray, nArray);
        DT[] dTArray = new DT[8];
        for (n = 0; n < 8; ++n) {
            int n3 = nArray[n / 4];
            int n4 = nArray[2 + n / 2 % 2];
            int n5 = nArray[4 + n % 2];
            dTArray[n] = this.chooseTensor(n3, n4, n5, vector3D);
        }
        if (dTArray[n2] == null) {
            dTArray[n2] = new DT(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        for (n = 0; n < 8; ++n) {
            if (dTArray[n] != null) continue;
            dTArray[n] = dTArray[n2];
        }
        double[] dArray2 = dTArray[0].getComponents();
        double[] dArray3 = dTArray[1].getComponents();
        double[] dArray4 = dTArray[2].getComponents();
        double[] dArray5 = dTArray[3].getComponents();
        double[] dArray6 = dTArray[4].getComponents();
        double[] dArray7 = dTArray[5].getComponents();
        double[] dArray8 = dTArray[6].getComponents();
        double[] dArray9 = dTArray[7].getComponents();
        double[] dArray10 = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray10[i] = dArray2[i] * dArray[0] + dArray3[i] * dArray[1] + dArray4[i] * dArray[2] + dArray5[i] * dArray[3] + dArray6[i] * dArray[4] + dArray7[i] * dArray[5] + dArray8[i] * dArray[6] + dArray9[i] * dArray[7];
        }
        return new DT(dArray10[0], dArray10[1], dArray10[2], dArray10[3], dArray10[4], dArray10[5]);
    }

    private DT chooseTensor(int n, int n2, int n3, Vector3D vector3D) {
        DT[] dTArray = this.image.getDTs(n, n2, n3);
        if (dTArray.length == 0) {
            return null;
        }
        if (dTArray.length == 1) {
            return dTArray[0];
        }
        Vector3D[] vector3DArray = this.image.getPDs(n, n2, n3);
        int n4 = 0;
        double d = 0.0;
        for (int i = 0; i < vector3DArray.length; ++i) {
            double d2 = Math.abs(vector3DArray[i].dot(vector3D));
            if (!(d2 > d)) continue;
            d = d2;
            n4 = i;
        }
        return dTArray[n4];
    }

    @Override
    public Vector3D getTrackingDirection(Point3D point3D, Vector3D vector3D) {
        DT dT = this.getInterpolatedTensor(point3D, vector3D);
        double[][] dArray = dT.sortedEigenSystem();
        Vector3D vector3D2 = new Vector3D(dArray[1][0], dArray[2][0], dArray[3][0]);
        if (vector3D2.dot(vector3D) > 0.0) {
            return vector3D2;
        }
        return vector3D2.negated();
    }

    @Override
    public Vector3D getTrackingDirection(Point3D point3D, int n, boolean bl) {
        int n2 = (int)(point3D.x / this.xVoxelDim);
        int n3 = (int)(point3D.y / this.yVoxelDim);
        int n4 = (int)(point3D.z / this.zVoxelDim);
        Vector3D[] vector3DArray = this.image.getPDs(n2, n3, n4);
        if (bl) {
            return this.getTrackingDirection(point3D, vector3DArray[n]);
        }
        return this.getTrackingDirection(point3D, vector3DArray[n].negated());
    }
}

