/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import data.VoxelOrderDataSource;
import imaging.Scheme;
import java.util.Random;
import misc.LoggedException;
import numerics.Vector3D;
import tractography.BayesDiracBallStickRandomizer;
import tractography.BayesDiracCylSymmTensorRandomizer;
import tractography.BayesDiracRandomizer;
import tractography.DataModel;
import tractography.PICoTractographyImage;
import tractography.TractographyImage;

public class BayesDiracTractographyImage
extends TractographyImage {
    protected final float[][][][] data;
    protected final Scheme ip;
    protected final BayesDiracRandomizer randomizer;

    public BayesDiracTractographyImage(float[][][][] fArray, double[] dArray, int[][][] nArray, Scheme scheme, DataModel dataModel, int n, Random random) {
        super(new int[]{fArray.length, fArray[0].length, fArray[0][0].length}, dArray, 1);
        this.ip = scheme;
        this.data = fArray;
        switch (dataModel) {
            case CYL_SYMM_DT: {
                this.randomizer = new BayesDiracCylSymmTensorRandomizer(fArray, this.ip, n, random);
                break;
            }
            case BALL_STICK: {
                this.randomizer = new BayesDiracBallStickRandomizer(fArray, this.ip, n, random);
                break;
            }
            default: {
                throw new LoggedException("Unsupported data model " + (Object)((Object)dataModel));
            }
        }
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    this.numPDs[k][j][i] = nArray[k][j][i];
                }
            }
        }
        this.computeIsotropicMask();
    }

    @Override
    public Vector3D[] getPDs(int n, int n2, int n3) {
        this.vectors[n][n2][n3] = this.randomizer.getRandomizedPDs(n, n2, n3);
        return super.getPDs(n, n2, n3);
    }

    @Override
    public Vector3D[] getPDs(int n, int n2, int n3, Vector3D vector3D) {
        this.vectors[n][n2][n3] = this.randomizer.getRandomizedPDs(n, n2, n3, vector3D);
        return super.getPDs(n, n2, n3);
    }

    public void setExternalPriors(PICoTractographyImage pICoTractographyImage) {
        int[] nArray = pICoTractographyImage.getDataDims();
        double[] dArray = pICoTractographyImage.getVoxelDims();
        if (nArray[0] != this.xDataDim || nArray[1] != this.yDataDim || nArray[2] != this.zDataDim) {
            throw new LoggedException("External prior image has different data dimensions");
        }
        if (dArray[0] != this.xVoxelDim || dArray[1] != this.yVoxelDim || dArray[2] != this.zVoxelDim) {
            throw new LoggedException("External prior image has different voxel dimensions");
        }
        this.randomizer.setExternalPriors(pICoTractographyImage.randomizer);
    }

    public static final BayesDiracTractographyImage getBayesDiracTractographyImage(String string, String string2, Scheme scheme, DataModel dataModel, int[][][] nArray, double[][][] dArray, double d, int[] nArray2, double[] dArray2, int n, Random random) {
        int n2 = scheme.numMeasurements();
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, n2, string2);
        float[][][][] fArray = new float[nArray2[0]][nArray2[1]][nArray2[2]][n2];
        for (int i = 0; i < nArray2[2]; ++i) {
            for (int j = 0; j < nArray2[1]; ++j) {
                for (int k = 0; k < nArray2[0]; ++k) {
                    double[] dArray3 = voxelOrderDataSource.nextVoxel();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        fArray[k][j][i][i2] = (float)dArray3[i2];
                    }
                }
            }
        }
        BayesDiracTractographyImage bayesDiracTractographyImage = new BayesDiracTractographyImage(fArray, dArray2, nArray, scheme, dataModel, n, random);
        if (dArray != null) {
            bayesDiracTractographyImage.computeIsotropicMask(dArray, d);
        }
        return bayesDiracTractographyImage;
    }

    public void setCurvePriorKappa(double d) {
        this.randomizer.setCurvatureK(d);
    }

    public void setCurvePriorGamma(double d) {
        this.randomizer.setCurvatureG(d);
    }
}

