/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import imaging.Scheme;
import inverters.BallStickInversion;
import java.util.Random;
import java.util.logging.Logger;
import tractography.BayesDiracRandomizer;

public class BayesDiracBallStickRandomizer
extends BayesDiracRandomizer {
    private static Logger logger = Logger.getLogger("camino.tractography.BayesDiracBallStickRandomizer");
    protected final BallStickInversion inv;

    public BayesDiracBallStickRandomizer(float[][][][] fArray, Scheme scheme, Random random) {
        super(fArray, scheme, random);
        this.inv = new BallStickInversion(scheme);
    }

    public BayesDiracBallStickRandomizer(float[][][][] fArray, Scheme scheme, int n, Random random) {
        super(fArray, scheme, n, random);
        this.inv = new BallStickInversion(scheme);
    }

    @Override
    protected void computeLikelihood(int n, int n2, int n3) {
        int n4;
        this.likelihood[n][n2][n3] = new float[this.numVectors];
        double[] dArray = new double[this.numMeas];
        for (int i = 0; i < this.numMeas; ++i) {
            dArray[i] = this.data[n][n2][n3][i];
        }
        double[] dArray2 = this.inv.invert(dArray);
        double d = dArray2[1];
        double d2 = Math.exp(dArray2[1]);
        double d3 = dArray2[2];
        double d4 = dArray2[3];
        double[] dArray3 = new double[this.numMeas];
        for (int i = 0; i < this.numMeas; ++i) {
            dArray3[i] = Math.log(this.data[n][n2][n3][i]);
        }
        double[] dArray4 = new double[this.numMeas];
        double[] dArray5 = new double[this.numMeas];
        double[] dArray6 = new double[this.numVectors];
        double d5 = 0.0;
        for (n4 = 0; n4 < this.numVectors; ++n4) {
            dArray6[n4] = 1.0;
            double d6 = 0.0;
            double d7 = 1.0 / ((double)this.numMeas - 5.0);
            for (int i = 0; i < this.numMeas; ++i) {
                double d8 = 0.0;
                dArray4[i] = d2 * ((1.0 - d4) * Math.exp(-this.b[i] * d3) + d4 * Math.exp(-this.b[i] * d3 * this.vDotG[i][n4] * this.vDotG[i][n4]));
                dArray5[i] = Math.log(dArray4[i]);
                d6 += d7 * ((double)this.data[n][n2][n3][i] - dArray4[i]) * ((double)this.data[n][n2][n3][i] - dArray4[i]);
            }
            double d9 = 1.0;
            double d10 = 0.0;
            for (int i = 0; i < this.numMeas; ++i) {
                d9 *= dArray4[i] / Math.sqrt(Math.PI * 2 * d6);
                d10 += -1.0 * (dArray4[i] * dArray4[i]) * (dArray3[i] - dArray5[i]) * (dArray3[i] - dArray5[i]) / (2.0 * d6);
            }
            dArray6[n4] = d9 * Math.exp(d10);
            if (this.externalPriors != null) {
                dArray6[n4] = dArray6[n4] * this.externalPriors.pdf(n, n2, n3, 0, this.vectors[n4]);
            }
            if (!(dArray6[n4] > 0.0)) continue;
            d5 += dArray6[n4];
        }
        for (n4 = 0; n4 < this.numVectors; ++n4) {
            this.likelihood[n][n2][n3][n4] = d5 > 0.0 ? (float)(dArray6[n4] / d5) : 0.07957747f;
        }
    }
}

