/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import imaging.Scheme;
import inverters.DT_Inversion;
import inverters.DiffusionInversion;
import inverters.ModelIndex;
import inverters.TwoTensorInversion;
import java.util.Random;
import misc.DT;
import numerics.Vector3D;
import tractography.BootstrapTractographyImage;

public abstract class BS_DT_TractographyImage
extends BootstrapTractographyImage {
    private final DiffusionInversion linearDTInversion;
    private final DiffusionInversion oneDTInversion;
    private final DiffusionInversion twoDTInversion;

    public BS_DT_TractographyImage(int[] nArray, double[] dArray, int[][][] nArray2, ModelIndex[] modelIndexArray, Scheme scheme, Random random) {
        super(nArray, dArray, 3, nArray2, scheme, random);
        if (modelIndexArray.length == 1) {
            modelIndexArray = new ModelIndex[]{ModelIndex.POSPOS, modelIndexArray[0]};
        }
        this.linearDTInversion = DT_Inversion.getIndexedDT_Inversion(ModelIndex.LDT, scheme);
        this.oneDTInversion = DT_Inversion.getIndexedDT_Inversion(modelIndexArray[1], scheme);
        this.twoDTInversion = new TwoTensorInversion(scheme, modelIndexArray[0], modelIndexArray[1]);
    }

    public final Vector3D[] getEigenvectors(int n, int n2, int n3) {
        this.setVectors(n, n2, n3);
        return this.vectors[n][n2][n3];
    }

    @Override
    protected void setVectors(int n, int n2, int n3) {
        double[] dArray;
        double[] dArray2 = this.nextBootstrapSample(n, n2, n3);
        DT[] dTArray = null;
        this.vectors[n][n2][n3] = new Vector3D[3 * this.numPDs[n][n2][n3]];
        if (this.numPDs[n][n2][n3] == 0) {
            return;
        }
        if (this.numPDs[n][n2][n3] == 1) {
            dArray = this.oneDTInversion.invert(dArray2);
            if (dArray[0] == 2.0) {
                System.err.println("DT inversion failed in voxel " + n + " " + n2 + " " + n3 + ". Trying linear inversion");
                dArray = this.linearDTInversion.invert(dArray2);
            }
            dTArray = new DT[]{new DT(dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7])};
        } else if (this.numPDs[n][n2][n3] == 2) {
            dArray = this.twoDTInversion.invert(dArray2);
            dTArray = new DT[]{new DT(dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9]), new DT(dArray[11], dArray[12], dArray[13], dArray[14], dArray[15], dArray[16])};
        } else {
            throw new UnsupportedOperationException("Can't invert data higher than order 4");
        }
        for (int i = 0; i < dTArray.length; ++i) {
            double[][] dArray3 = dTArray[i].sortedEigenSystem();
            for (int j = 0; j < 3; ++j) {
                this.vectors[n][n2][n3][j + 3 * i] = new Vector3D(dArray3[1][j], dArray3[2][j], dArray3[3][j]);
            }
        }
    }

    protected abstract double[] nextBootstrapSample(int var1, int var2, int var3);
}

