/*
 * Decompiled with CFR 0.152.
 */
package sphfunc;

import java.util.logging.Logger;
import numerics.RealMatrix;
import optimizers.PowellMinimiser;
import optimizers.PowellMinimiserException;
import sphfunc.ISCodes;
import sphfunc.PD;
import sphfunc.PDList;
import tools.CL_Initializer;

public abstract class SphericalFunction {
    Logger logger = Logger.getLogger(this.getClass().getName());
    private static double searchRadius = 0.4;
    public static double SFPD_PARAMSCALE = 0.1;
    protected double DPTHRESH = 0.001;
    protected double MINCONV = 1.0E-12;
    private final double GREAT_CIRCLE_INTEGRAL_THRESHOLD = 1.0E-5;
    private final int MAX_GREAT_CIRCLE_POINTS = 100;
    private final int MIN_GREAT_CIRCLE_POINTS = 20;
    private final int GREAT_CIRCLE_POINTS_INC = 5;

    public double getRadius(double d, double d2) {
        double[] dArray = this.toUnitVec(d, d2);
        return this.getRadius(dArray[0], dArray[1], dArray[2]);
    }

    public abstract double getRadius(double var1, double var3, double var5);

    public double moment(int n) {
        try {
            double[][] dArray = ISCodes.getPointSetForMaxEnt((int)CL_Initializer.pointSetInd).data;
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = this.getRadius(dArray[i][0], dArray[i][1], dArray[i][2]);
                d += Math.pow(d3, n);
            }
            return d / (double)dArray.length;
        }
        catch (Exception exception) {
            this.logger.warning("WARNING: " + exception);
            return 0.0;
        }
    }

    public double normMoment(int n) {
        double d = this.mean();
        try {
            double[][] dArray = ISCodes.getPointSetForMaxEnt((int)CL_Initializer.pointSetInd).data;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                double d4 = this.getRadius(dArray[i][0], dArray[i][1], dArray[i][2]);
                d2 += Math.pow(d4, n);
                d3 += Math.pow(d4 - d, n);
            }
            return d2 == 0.0 ? 0.0 : d3 / d2;
        }
        catch (Exception exception) {
            System.out.println("WARNING: " + exception);
            return 0.0;
        }
    }

    public double mean() {
        return this.moment(1);
    }

    public double anisotropy() {
        return Math.sqrt(this.normMoment(2));
    }

    public double skewness() {
        double d = this.normMoment(3);
        d = d < 0.0 ? -Math.pow(-d, 0.3333333333333333) : Math.pow(d, 0.3333333333333333);
        return d;
    }

    public double kurtosis() {
        double d = Math.sqrt(Math.sqrt(this.normMoment(4)));
        double d2 = this.anisotropy();
        if (d2 != 0.0) {
            return d / d2;
        }
        return 1.0;
    }

    public double[] getStats() {
        Object object;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            object = ISCodes.getPointSetForMaxEnt((int)CL_Initializer.pointSetInd).data;
            double d5 = 0.0;
            double d6 = 0.0;
            for (int i = 0; i < ((double[][])object).length; ++i) {
                double d7 = this.getRadius(object[i][0], object[i][1], object[i][2]);
                d5 += d7;
                d6 += d7 * d7;
                if (i == 0) {
                    d3 = d7;
                    d4 = d7;
                    continue;
                }
                d3 = d7 > d3 ? d7 : d3;
                d4 = i == 0 || d7 < d4 ? d7 : d4;
            }
            d = d5 / (double)((double[][])object).length;
            d2 = d6 / (double)((double[][])object).length - d * d;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        object = new double[4];
        object[0] = (double[])d;
        object[1] = (double[])d2;
        object[2] = (double[])d3;
        object[3] = (double[])d4;
        return object;
    }

    public double[] getPDs(double[][] dArray, PDList pDList) {
        int n;
        PDList pDList2 = this.getPDsRS(dArray);
        double[] dArray2 = new double[pDList2.getNoPDs()];
        SFPD_Minimiser sFPD_Minimiser = new SFPD_Minimiser(SFPD_PARAMSCALE);
        boolean bl = true;
        for (n = 0; n < pDList2.getNoPDs(); ++n) {
            PD pD = pDList2.getPD(n);
            double[] dArray3 = new double[]{0.0, pD.getTheta(), pD.getPhi()};
            try {
                double d;
                double d2 = -sFPD_Minimiser.minimise(dArray3, this.MINCONV);
                double[] dArray4 = sFPD_Minimiser.getMinParams();
                PD pD2 = new PD(dArray4[1], dArray4[2], d2);
                pDList.addPD(pD2);
                double d3 = pD.getPDX();
                double d4 = pD.getPDY();
                double d5 = pD.getPDZ();
                double d6 = pD2.getPDX();
                double d7 = pD2.getPDY();
                double d8 = pD2.getPDZ();
                double d9 = d3 * d6 + d4 * d7 + d5 * d8;
                dArray2[n] = d = Math.sqrt((d3 - d6) * (d3 - d6) + (d4 - d7) * (d4 - d7) + (d5 - d8) * (d5 - d8));
                if (!(d > searchRadius)) continue;
                bl = false;
                continue;
            }
            catch (Exception exception) {
                pDList.addPD(pD);
                dArray2[n] = -1.0;
                this.logger.warning(exception.toString());
                bl = false;
            }
        }
        if (!bl) {
            for (n = 0; n < pDList2.getNoPDs(); ++n) {
                this.logger.info("Before opt (" + n + "): " + pDList2.getPD(n));
            }
            for (n = 0; n < pDList.getNoPDs(); ++n) {
                this.logger.info("After opt  (" + n + "): " + pDList.getPD(n));
            }
        }
        return dArray2;
    }

    public PDList getPDsRS(double[][] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = this.getRadius(dArray[i][0], dArray[i][1], dArray[i][2]);
        }
        PDList pDList = this.getMaxima(dArray, dArray2);
        return pDList;
    }

    public static void setSearchRadius(double d) {
        searchRadius = d;
    }

    public static double getSearchRadius() {
        return searchRadius;
    }

    private PDList getMaxima(double[][] dArray, double[] dArray2) {
        int n;
        int n2;
        boolean[] blArray = new boolean[dArray2.length];
        for (n2 = 0; n2 < blArray.length; ++n2) {
            blArray[n2] = true;
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            if (!blArray[n2]) continue;
            for (n = 0; n < dArray2.length; ++n) {
                double d;
                double d2;
                double d3 = Math.sqrt((dArray[n2][0] - dArray[n][0]) * (dArray[n2][0] - dArray[n][0]) + (dArray[n2][1] - dArray[n][1]) * (dArray[n2][1] - dArray[n][1]) + (dArray[n2][2] - dArray[n][2]) * (dArray[n2][2] - dArray[n][2]));
                double d4 = d2 = d3 < (d = Math.sqrt((dArray[n2][0] + dArray[n][0]) * (dArray[n2][0] + dArray[n][0]) + (dArray[n2][1] + dArray[n][1]) * (dArray[n2][1] + dArray[n][1]) + (dArray[n2][2] + dArray[n][2]) * (dArray[n2][2] + dArray[n][2]))) ? d3 : d;
                if (!(d2 < searchRadius) || d2 == 0.0) continue;
                if (dArray2[n] > dArray2[n2]) {
                    blArray[n2] = false;
                    n = dArray2.length;
                    continue;
                }
                blArray[n] = false;
            }
        }
        PDList pDList = new PDList();
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            pDList.addPD(new PD(dArray[n], dArray2[n]));
        }
        return pDList;
    }

    public void setConvThresh(double d) {
        this.MINCONV = d;
    }

    public RealMatrix getHessian(PD pD) {
        double[] dArray = new double[]{pD.getPDX(), pD.getPDY(), pD.getPDZ()};
        return this.getHessian(dArray);
    }

    public RealMatrix getHessian(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        for (int i = 0; i < 3; ++i) {
            dArray[i] = dArray[i] / d;
        }
        double d2 = this.getRadius(dArray[0], dArray[1], dArray[2]);
        double d3 = 1.0E-5;
        double[] dArray2 = new double[3];
        double d4 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        if (d4 == 0.0) {
            dArray2[0] = 1.0;
            dArray2[1] = 0.0;
            dArray2[2] = 0.0;
        } else {
            dArray2[0] = dArray[1] / d4;
            dArray2[1] = -dArray[0] / d4;
            dArray2[2] = 0.0;
        }
        double[] dArray3 = new double[3];
        if (d4 == 0.0) {
            dArray3[0] = 0.0;
            dArray3[1] = 1.0;
            dArray3[2] = 0.0;
        } else {
            dArray3[0] = -dArray[0] * dArray[2];
            dArray3[1] = -dArray[1] * dArray[2];
            dArray3[2] = d4 * d4;
        }
        double d5 = Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]);
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = dArray3[i] / d5;
        }
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[3];
        double[] dArray9 = new double[3];
        double[] dArray10 = new double[3];
        double[] dArray11 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray4[i] = dArray[i] + d3 * dArray2[i];
            dArray5[i] = dArray[i] + d3 * dArray3[i];
            dArray6[i] = dArray[i] - d3 * dArray2[i];
            dArray7[i] = dArray[i] - d3 * dArray3[i];
            dArray8[i] = dArray[i] + d3 * dArray2[i] + d3 * dArray3[i];
            dArray9[i] = dArray[i] - d3 * dArray2[i] + d3 * dArray3[i];
            dArray10[i] = dArray[i] - d3 * dArray2[i] - d3 * dArray3[i];
            dArray11[i] = dArray[i] + d3 * dArray2[i] - d3 * dArray3[i];
        }
        double d6 = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2]);
        double d7 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2]);
        double d8 = Math.sqrt(dArray6[0] * dArray6[0] + dArray6[1] * dArray6[1] + dArray6[2] * dArray6[2]);
        double d9 = Math.sqrt(dArray7[0] * dArray7[0] + dArray7[1] * dArray7[1] + dArray7[2] * dArray7[2]);
        double d10 = Math.sqrt(dArray8[0] * dArray8[0] + dArray8[1] * dArray8[1] + dArray8[2] * dArray8[2]);
        double d11 = Math.sqrt(dArray9[0] * dArray9[0] + dArray9[1] * dArray9[1] + dArray9[2] * dArray9[2]);
        double d12 = Math.sqrt(dArray10[0] * dArray10[0] + dArray10[1] * dArray10[1] + dArray10[2] * dArray10[2]);
        double d13 = Math.sqrt(dArray11[0] * dArray11[0] + dArray11[1] * dArray11[1] + dArray11[2] * dArray11[2]);
        for (int i = 0; i < 3; ++i) {
            dArray4[i] = dArray4[i] / d6;
            dArray5[i] = dArray5[i] / d7;
            dArray6[i] = dArray6[i] / d8;
            dArray7[i] = dArray7[i] / d9;
            dArray8[i] = dArray8[i] / d10;
            dArray9[i] = dArray9[i] / d11;
            dArray10[i] = dArray10[i] / d12;
            dArray11[i] = dArray11[i] / d13;
        }
        double d14 = this.getRadius(dArray4[0], dArray4[1], dArray4[2]);
        double d15 = this.getRadius(dArray6[0], dArray6[1], dArray6[2]);
        double d16 = this.getRadius(dArray5[0], dArray5[1], dArray5[2]);
        double d17 = this.getRadius(dArray7[0], dArray7[1], dArray7[2]);
        double d18 = this.getRadius(dArray8[0], dArray8[1], dArray8[2]);
        double d19 = this.getRadius(dArray9[0], dArray9[1], dArray9[2]);
        double d20 = this.getRadius(dArray10[0], dArray10[1], dArray10[2]);
        double d21 = this.getRadius(dArray11[0], dArray11[1], dArray11[2]);
        double d22 = (d14 - d15) / (2.0 * d3);
        double d23 = (d16 - d17) / (2.0 * d3);
        double d24 = (d14 - 2.0 * d2 + d15) / (d3 * d3);
        double d25 = (d16 - 2.0 * d2 + d17) / (d3 * d3);
        double d26 = (d18 - d19 - d21 + d20) / (4.0 * d3 * d3);
        RealMatrix realMatrix = new RealMatrix(2, 2);
        realMatrix.entries[0][0] = d24;
        realMatrix.entries[1][0] = d26;
        realMatrix.entries[0][1] = d26;
        realMatrix.entries[1][1] = d25;
        return realMatrix;
    }

    protected double[] toUnitVec(double d, double d2) {
        double[] dArray = new double[]{Math.cos(d2) * Math.sin(d), Math.sin(d2) * Math.sin(d), Math.cos(d)};
        return dArray;
    }

    protected double[] toAngles(double d, double d2, double d3) {
        double[] dArray = new double[2];
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d4 == 0.0) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            return dArray;
        }
        double d5 = d / d4;
        double d6 = d2 / d4;
        double d7 = d3 / d4;
        double d8 = Math.acos(d7);
        double d9 = 0.0;
        double d10 = Math.sin(d8);
        if (Math.abs(d10) >= 1.0E-7) {
            double d11 = d5 / d10;
            d11 = d11 > 1.0 ? 1.0 : d11;
            d11 = d11 < -1.0 ? -1.0 : d11;
            d9 = Math.acos(d11);
            double d12 = d6 / d10;
            d12 = d12 > 1.0 ? 1.0 : d12;
            double d13 = d12 = d12 < -1.0 ? -1.0 : d12;
            if (Math.asin(d12) < 0.0) {
                d9 = Math.PI * 2 - d9;
            }
        }
        dArray[0] = d8;
        dArray[1] = d9;
        return dArray;
    }

    private final double[] getGreatCircleAngles(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)i * 2.0 * Math.PI / (double)n;
        }
        return dArray;
    }

    private final double[][] getGreatCirclePoints(double[] dArray, double[] dArray2, int n) {
        if (dArray2.length != n) {
            String string = new String("number of angles for great circle intgration is " + dArray2.length + " but degree is " + n + ". no good!");
            this.logger.severe(string);
            throw new RuntimeException(string);
        }
        double[][] dArrayArray = new double[n][];
        for (int i = 1; i <= n; ++i) {
            double d = (dArray2[i % n] + dArray2[i - 1]) / 2.0;
            dArrayArray[i % n] = this.getPointOnCircle(dArray, d);
        }
        return dArrayArray;
    }

    private final double[] getGreatCircleSegmentLengths(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray2.length];
        int n = dArray2.length;
        dArray3[0] = Math.PI * 2 - dArray2[n - 1];
        for (int i = 1; i < n; ++i) {
            dArray3[i] = dArray2[i] - dArray2[i - 1];
        }
        return dArray3;
    }

    private final double[] getPointOnCircle(double[] dArray, double d) {
        double d2 = dArray[2];
        double d3 = Math.sqrt(1.0 - d2 * d2);
        double d4 = d3 == 0.0 ? 0.0 : dArray[0] / d3;
        double d5 = d3 == 0.0 ? 1.0 : dArray[1] / d3;
        double[] dArray2 = new double[]{-d5, d4, 0.0};
        double[] dArray3 = new double[]{d4 * d2, d5 * d2, -d3};
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double[] dArray4 = new double[]{dArray2[0] * d6 + dArray3[0] * d7, dArray2[1] * d6 + dArray3[1] * d7, dArray2[2] * d6 + dArray3[2] * d7};
        return dArray4;
    }

    private double greatCircleIntegral(double[] dArray, int n) {
        double[] dArray2 = this.getGreatCircleAngles(n);
        double[][] dArray3 = this.getGreatCirclePoints(dArray, dArray2, n);
        double[] dArray4 = this.getGreatCircleSegmentLengths(dArray, dArray2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = this.getRadius(dArray3[i][0], dArray3[i][1], dArray3[i][2]);
            d += d2 * dArray4[i];
        }
        return d;
    }

    public double numGreatCircleIntegral(double[] dArray) {
        double d = -1.0;
        int n = 20;
        double d2 = this.greatCircleIntegral(dArray, 20);
        int n2 = 21;
        while (true) {
            double d3;
            d = d3 = this.greatCircleIntegral(dArray, n2);
            n = n2;
            if (Math.abs(d2 - d3) <= 1.0E-5) break;
            if (n2 > 100) {
                this.logger.warning("WARNING: great circle integral about u=(" + dArray[0] + "," + dArray[1] + "," + dArray[2] + ") did not converge after max number of steps (max steps = " + 100 + ", threshold = " + 1.0E-5 + ", diff = " + Math.abs(d2 - d3));
                this.logger.warning("returning integral value at n=" + n2);
                break;
            }
            d2 = d3;
            n2 += 5;
        }
        return d;
    }

    public double greatCircleIntegral(double[] dArray) {
        return this.numGreatCircleIntegral(dArray);
    }

    protected class SFPD_Minimiser
    extends PowellMinimiser {
        private double paramScale;

        public SFPD_Minimiser() {
            super(2);
            this.paramScale = 0.1;
        }

        public SFPD_Minimiser(double d) {
            super(2);
            this.paramScale = 0.1;
            this.paramScale = d;
        }

        @Override
        protected double fObj(double[] dArray) {
            return -SphericalFunction.this.getRadius(dArray[1] * this.paramScale, dArray[2] * this.paramScale);
        }

        @Override
        public double minimise(double[] dArray, double d) throws PowellMinimiserException {
            int n = 0;
            while (n < dArray.length) {
                int n2 = n++;
                dArray[n2] = dArray[n2] / this.paramScale;
            }
            return super.minimise(dArray, d);
        }

        @Override
        public double[] getMinParams() {
            double[] dArray = super.getMinParams();
            int n = 0;
            while (n < dArray.length) {
                int n2 = n++;
                dArray[n2] = dArray[n2] * this.paramScale;
            }
            return dArray;
        }
    }
}

