/*
 * Decompiled with CFR 0.152.
 */
package sphfunc;

import java.util.logging.Logger;
import numerics.Complex;
import numerics.SphericalHarmonicException;
import numerics.SphericalHarmonics;
import sphfunc.LinearBasisFunction;

public class RealSH
extends LinearBasisFunction {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    protected int m;
    protected int l;
    protected double scalar;

    public RealSH(int n, int n2) {
        this.l = n;
        this.m = n2;
        this.scalar = 1.0;
    }

    public RealSH(int n, int n2, double d) {
        this.l = n;
        this.m = n2;
        this.scalar = d;
    }

    @Override
    public double getRadius(double d, double d2) {
        Complex complex;
        try {
            complex = SphericalHarmonics.Y(this.l, this.m, d, d2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return this.scalar * complex.real();
    }

    @Override
    public double getRadius(double d, double d2, double d3) {
        double[] dArray = this.toAngles(d, d2, d3);
        return this.getRadius(dArray[0], dArray[1]);
    }

    @Override
    public double greatCircleIntegral(double[] dArray) {
        double[] dArray2 = this.toAngles(dArray[0], dArray[1], dArray[2]);
        double d = 0.0;
        Complex complex = new Complex();
        try {
            d = SphericalHarmonics.plgndr(this.l, 0, 0.0);
            complex = SphericalHarmonics.Y(this.l, this.m, dArray2[0], dArray2[1]);
        }
        catch (SphericalHarmonicException sphericalHarmonicException) {
            String string = sphericalHarmonicException.getMessage();
            this.logger.warning(string);
        }
        double d2 = complex.real();
        return Math.PI * 2 * d * d2 * this.scalar;
    }
}

