/*
 * Decompiled with CFR 0.152.
 */
package sphfunc;

import misc.SphericalPoints;
import sphfunc.LinearBasisSum;

public abstract class RBF_Sum
extends LinearBasisSum {
    private static final int DEFAULT_RBF_POINTSET = 246;
    protected static double[][] pts = SphericalPoints.getElecPointSet(246);

    public RBF_Sum(double[] dArray) {
        if (dArray.length != pts.length + 2) {
            throw new RuntimeException("RBF_sum was only given " + (dArray.length - 2) + " coefficients for " + pts.length + " basis functions.");
        }
        this.c = new double[dArray.length - 2];
        for (int i = 0; i < this.c.length; ++i) {
            this.c[i] = dArray[i + 2];
        }
    }

    public abstract double rbf(double var1, double var3, double var5, double[] var7);

    @Override
    public double getRadius(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < pts.length; ++i) {
            double d6 = this.rbf(d, d2, d3, pts[i]);
            d5 += d6;
            d4 += d6 * this.c[i];
        }
        return d4 / d5;
    }

    public static void setPoints(double[][] dArray) {
        pts = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                RBF_Sum.pts[i][j] = dArray[i][j];
            }
        }
    }

    public static int numPoints() {
        if (pts == null) {
            return 0;
        }
        return pts.length;
    }
}

