/*
 * Decompiled with CFR 0.152.
 */
package sphfunc;

import java.util.Vector;
import sphfunc.PD;

public class PDList {
    private Vector<PD> pds = new Vector();
    private double dpThresh;
    private double TINY = 1.0E-6;

    public PDList(double d) {
        this.dpThresh = d;
    }

    public PDList() {
        this.dpThresh = this.TINY;
    }

    public void addPD(PD pD) {
        int n;
        boolean bl = true;
        for (n = 0; n < this.pds.size(); ++n) {
            bl &= this.notCloseTo(pD, this.pds.elementAt(n));
        }
        if (bl) {
            for (n = 0; n < this.pds.size() && pD.getProp() < this.pds.elementAt(n).getProp(); ++n) {
            }
            this.pds.insertElementAt(pD, n);
        }
    }

    public boolean isIn(PD pD) {
        boolean bl = true;
        for (int i = 0; i < this.pds.size(); ++i) {
            bl &= this.notCloseTo(pD, this.pds.elementAt(i));
        }
        return !bl;
    }

    public PD getPD(int n) {
        return this.pds.elementAt(n);
    }

    public int getNoPDs() {
        return this.pds.size();
    }

    public void prune(double d) {
        boolean bl = false;
        while (!bl) {
            bl = true;
            double d2 = this.getPropSum();
            for (int i = this.pds.size() - 1; i >= 0; --i) {
                if (!(this.pds.elementAt(i).getProp() < d * d2)) continue;
                this.pds.removeElementAt(i);
                bl = false;
            }
        }
    }

    public void pruneByValue(double d) {
        for (int i = this.pds.size() - 1; i >= 0; --i) {
            if (!(this.pds.elementAt(i).getProp() < d)) continue;
            this.pds.removeElementAt(i);
        }
    }

    public double getPropSum() {
        double d = 0.0;
        for (int i = 0; i < this.pds.size(); ++i) {
            d += this.pds.elementAt(i).getProp();
        }
        return d;
    }

    public boolean equivalent(PDList pDList, double d) {
        boolean bl = this.getNoPDs() == pDList.getNoPDs();
        for (int i = 0; bl && i < this.getNoPDs(); bl &= pDList.isIn(this.getPD(i)), ++i) {
        }
        return bl;
    }

    private boolean notCloseTo(PD pD, PD pD2) {
        double d = pD.getPDX() * pD2.getPDX() + pD.getPDY() * pD2.getPDY() + pD.getPDZ() * pD2.getPDZ();
        boolean bl = 1.0 - Math.abs(d) > this.dpThresh;
        return 1.0 - Math.abs(d) > this.dpThresh;
    }
}

