/*
 * Decompiled with CFR 0.152.
 */
package sphfunc;

import misc.SphericalPoints;

public class PD {
    private double pdTheta;
    private double pdPhi;
    private double pdProp;

    public PD(double d, double d2, double d3) {
        this.pdTheta = d;
        this.pdPhi = d2;
        this.pdProp = d3;
    }

    public PD(double[] dArray, double d) {
        double[] dArray2 = SphericalPoints.getSphPolars(dArray);
        this.pdTheta = dArray2[1];
        this.pdPhi = dArray2[2];
        this.pdProp = d;
    }

    public double getTheta() {
        return this.pdTheta;
    }

    public double getPhi() {
        return this.pdPhi;
    }

    public double getProp() {
        return this.pdProp;
    }

    public double getPDX() {
        return Math.cos(this.pdPhi) * Math.sin(this.pdTheta);
    }

    public double getPDY() {
        return Math.sin(this.pdPhi) * Math.sin(this.pdTheta);
    }

    public double getPDZ() {
        return Math.cos(this.pdTheta);
    }

    public String toString() {
        String string = "Theta: " + this.pdTheta + ", Phi: " + this.pdPhi + ", Prop.: " + this.pdProp;
        return string;
    }
}

