/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Logger;
import simulation.SimulationParams;
import simulation.geometry.Triangle;

public class VRMLReader {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private static VRMLReader vr;
    private static final int ARRAY_INC_SIZE = 200;
    private static final int SB_INIT_SIZE = 1000;
    private Triangle[] triangleList;
    private double[][] verts;
    private int vertsArrayInd;
    private double[][] normals;
    private int normalArrayInd;
    private int[][] faces;
    private int faceInds;
    private int[][] faceNorms;
    private int faceNormInds;
    private boolean inPoints = false;
    private boolean inFaces = false;
    private boolean inNorms = false;
    private boolean inFaceNorms = false;

    private VRMLReader() {
    }

    public static VRMLReader getVRMLReader() {
        if (vr == null) {
            vr = new VRMLReader();
        }
        return vr;
    }

    public Triangle[] loadFile(String string) {
        this.resetVariables();
        int n = 0;
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf("geometry") <= -1 && !bl3) continue;
                bl3 = false;
                ++n;
                if (string2.indexOf("geometry") > -1) {
                    string2 = string2.substring(string2.indexOf("geometry") + 8, string2.length());
                }
                do {
                    bl2 = false;
                    if (string2 == null) {
                        bl2 = true;
                    } else if (string2.indexOf("point") > -1) {
                        this.inPoints = true;
                        this.parseData(bufferedReader, string2.substring(string2.indexOf("point")).trim(), ",");
                        this.inPoints = false;
                    } else if (string2.indexOf("normal ") > -1) {
                        this.inNorms = true;
                        this.parseData(bufferedReader, string2.substring(string2.indexOf("normal ")).trim(), ",");
                        this.inNorms = false;
                    } else if (string2.indexOf("coordIndex") > -1) {
                        this.inFaces = true;
                        this.parseData(bufferedReader, string2.substring(string2.indexOf("coordIndex")).trim(), "-1");
                        this.inFaces = false;
                    } else if (string2.indexOf("normalIndex") > -1) {
                        this.inFaceNorms = true;
                        this.parseData(bufferedReader, string2.substring(string2.indexOf("normalIndex")).trim(), "-1");
                        this.inFaceNorms = false;
                    } else if (string2.indexOf("geometry") > -1) {
                        bl2 = true;
                        bl3 = true;
                    }
                    if (!bl2) {
                        string2 = bufferedReader.readLine();
                        continue;
                    }
                    this.triangleList = this.conCatList(this.triangleList, this.convertToTriangles());
                    this.resetVariables();
                } while (!bl2);
            }
            bufferedReader.close();
            return this.triangleList;
        }
        catch (IOException iOException) {
            this.logger.severe("Couldn't open specified .wrl file");
            this.logger.severe("Returning null list of Triangles!");
            return this.triangleList;
        }
    }

    private void parseData(BufferedReader bufferedReader, String string, String string2) throws IOException {
        boolean bl = false;
        String string3 = string;
        int n = string3.indexOf(91) + 1;
        while (n < 1) {
            string3 = bufferedReader.readLine().trim();
            n = string3.indexOf(91) + 1;
        }
        if (n > string3.length()) {
            string3 = bufferedReader.readLine();
            n = 0;
        } else {
            string3 = string3.substring(n);
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(string3);
        while (string3.indexOf(93) == -1) {
            string3 = bufferedReader.readLine();
            stringBuffer.append(string3);
        }
        string3 = stringBuffer.toString();
        string3 = string3.substring(0, string3.indexOf(93) + 1).trim();
        while (!bl) {
            if (string3.indexOf(string2, n) > -1) {
                if (string2.equals("-1")) {
                    this.parseInt3(string3.substring(n, string3.indexOf(string2, n)));
                } else {
                    this.parseDouble3(string3.substring(n, string3.indexOf(string2, n)));
                }
                n = string3.indexOf(string2, n) + string2.length();
                if (n >= string3.indexOf(93) || n == -1) {
                    bl = true;
                    continue;
                }
                if (n != string3.trim().length() && n != -1) continue;
                if (string3.indexOf(93) > -1) {
                    bl = true;
                    continue;
                }
                string3 = bufferedReader.readLine();
                n = 0;
                continue;
            }
            if (n >= string3.indexOf(93)) {
                bl = true;
                continue;
            }
            if (string3.indexOf(93) - n <= 0) continue;
            string3 = string3.substring(n, string3.indexOf(93) + 1).trim();
            n = 0;
            if (string3.length() > 4) {
                if (string2.equals("-1")) {
                    this.parseInt3(string3.substring(n, string3.indexOf(93)));
                } else {
                    this.parseDouble3(string3.substring(n, string3.indexOf(93)));
                }
            }
            bl = true;
        }
    }

    private void parseDouble3(String string) {
        String string2 = string.trim();
        try {
            int n = string2.indexOf(" ");
            double d = Double.parseDouble(string2.substring(0, n));
            while (string2.charAt(n + 1) == ' ') {
                ++n;
            }
            double d2 = Double.parseDouble(string2.substring(n, string2.indexOf(" ", n + 1)));
            n = string2.indexOf(" ", n + 1);
            while (string2.charAt(n + 1) == ' ') {
                ++n;
            }
            double d3 = Double.parseDouble(string2.substring(n, string2.length()));
            if (this.inPoints) {
                if (this.vertsArrayInd + 1 > this.verts.length) {
                    this.verts = this.increaseArraySize(this.verts);
                }
                this.verts[this.vertsArrayInd][0] = d;
                this.verts[this.vertsArrayInd][1] = d2;
                this.verts[this.vertsArrayInd][2] = d3;
                ++this.vertsArrayInd;
            } else if (this.inNorms) {
                if (this.normalArrayInd + 1 > this.normals.length) {
                    this.normals = this.increaseArraySize(this.normals);
                }
                this.normals[this.normalArrayInd][0] = d;
                this.normals[this.normalArrayInd][1] = d2;
                this.normals[this.normalArrayInd][2] = d3;
                ++this.normalArrayInd;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.severe("could not parse doubles from string: " + string2);
        }
    }

    private void parseInt3(String string) {
        String string2 = string.trim();
        try {
            if (string2.length() > 4) {
                boolean bl = false;
                int n = string2.indexOf(44);
                if (n == 0) {
                    n = 1;
                    while (string2.charAt(n + 1) == ' ') {
                        ++n;
                    }
                } else {
                    n = 0;
                }
                int n2 = string2.indexOf(44, 1);
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                if (n2 == string2.length() || n2 == -1) {
                    n2 = string2.indexOf(32, n + 1);
                    while (string2.charAt(n2 + 1) == ' ') {
                        ++n2;
                    }
                    n3 = Integer.parseInt(string2.substring(n, n2).trim());
                    n = n2;
                    n2 = string2.indexOf(32, n + 1);
                    while (string2.charAt(n2 + 1) == ' ') {
                        ++n2;
                    }
                    n4 = Integer.parseInt(string2.substring(n, n2).trim());
                    n = n2;
                    n2 = string2.indexOf(32, n + 1);
                    n5 = Integer.parseInt(string2.substring(n, string2.length()).trim());
                } else {
                    n3 = Integer.parseInt(string2.substring(n, n2).trim());
                    n4 = Integer.parseInt(string2.substring(n2 + 1, string2.indexOf(44, n2 + 1)).trim());
                    n5 = Integer.parseInt(string2.substring(string2.indexOf(44, n2 + 1) + 1, string2.length() - 1).trim());
                }
                if (this.inFaces) {
                    if (this.faceInds + 1 > this.faces.length) {
                        this.faces = this.increaseArraySize(this.faces);
                    }
                    this.faces[this.faceInds][0] = n3;
                    this.faces[this.faceInds][1] = n4;
                    this.faces[this.faceInds][2] = n5;
                    ++this.faceInds;
                } else if (this.inFaceNorms) {
                    if (this.faceNormInds + 1 > this.faceNorms.length) {
                        this.faceNorms = this.increaseArraySize(this.faceNorms);
                    }
                    this.faceNorms[this.faceNormInds][0] = n3;
                    this.faceNorms[this.faceNormInds][1] = n4;
                    this.faceNorms[this.faceNormInds][2] = n5;
                    ++this.faceNormInds;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.severe("could not parse indices from string: " + string2);
        }
    }

    private double[][] increaseArraySize(double[][] dArray) {
        int n;
        int n2;
        double[][] dArray2 = new double[dArray.length + 200][3];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray2[n2][n] = dArray[n2][n];
            }
        }
        for (n2 = dArray.length; n2 < dArray2.length; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray2[n2][n] = 0.0;
            }
        }
        return dArray2;
    }

    private int[][] increaseArraySize(int[][] nArray) {
        int n;
        int n2;
        int[][] nArray2 = new int[nArray.length + 200][3];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            for (n = 0; n < 3; ++n) {
                nArray2[n2][n] = nArray[n2][n];
            }
        }
        for (n2 = nArray.length; n2 < nArray2.length; ++n2) {
            for (n = 0; n < 3; ++n) {
                nArray2[n2][n] = 0;
            }
        }
        return nArray2;
    }

    private Triangle[] convertToTriangles() {
        Triangle[] triangleArray = new Triangle[this.faceInds];
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        for (int i = 0; i < this.faceInds; ++i) {
            dArray[0] = this.verts[this.faces[i][0]][0];
            dArray[1] = this.verts[this.faces[i][0]][1];
            dArray[2] = this.verts[this.faces[i][0]][2];
            dArray2[0] = this.verts[this.faces[i][1]][0];
            dArray2[1] = this.verts[this.faces[i][1]][1];
            dArray2[2] = this.verts[this.faces[i][1]][2];
            dArray3[0] = this.verts[this.faces[i][2]][0];
            dArray3[1] = this.verts[this.faces[i][2]][1];
            dArray3[2] = this.verts[this.faces[i][2]][2];
            double[] dArray5 = new double[3];
            double[] dArray6 = new double[3];
            dArray5[0] = dArray[0] - dArray2[0];
            dArray5[1] = dArray[1] - dArray2[1];
            dArray5[2] = dArray[2] - dArray2[2];
            dArray6[0] = dArray[0] - dArray3[0];
            dArray6[1] = dArray[1] - dArray3[1];
            dArray6[2] = dArray[2] - dArray3[2];
            triangleArray[i] = new Triangle(dArray, dArray2, dArray3, SimulationParams.sim_p);
        }
        return triangleArray;
    }

    private Triangle[] conCatList(Triangle[] triangleArray, Triangle[] triangleArray2) {
        if (triangleArray != null && triangleArray2 != null) {
            int n;
            Triangle[] triangleArray3 = new Triangle[triangleArray.length + triangleArray2.length];
            for (n = 0; n < triangleArray.length; ++n) {
                triangleArray3[n] = triangleArray[n];
            }
            for (n = triangleArray.length; n < triangleArray.length + triangleArray2.length; ++n) {
                triangleArray3[n] = triangleArray2[n - triangleArray.length];
            }
            return triangleArray3;
        }
        if (triangleArray == null) {
            return triangleArray2;
        }
        return triangleArray;
    }

    private void resetVariables() {
        this.inPoints = false;
        this.inFaces = false;
        this.inNorms = false;
        this.inFaceNorms = false;
        this.verts = new double[200][3];
        this.normals = new double[200][3];
        this.faces = new int[200][3];
        this.faceNorms = new int[200][3];
        this.vertsArrayInd = 0;
        this.normalArrayInd = 0;
        this.faceInds = 0;
        this.faceNormInds = 0;
        Object var1_1 = null;
        for (int i = 0; i < this.verts.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.verts[i][j] = 0.0;
                this.normals[i][j] = 0.0;
                this.faces[i][j] = 0;
                this.faceNorms[i][j] = 0;
            }
        }
    }

    public static void main(String[] stringArray) {
        VRMLReader vRMLReader = VRMLReader.getVRMLReader();
        Triangle[] triangleArray = vRMLReader.loadFile(stringArray[0]);
        System.out.println("num triangles: " + triangleArray.length + "\n\n");
        for (int i = 0; i < triangleArray.length; ++i) {
            System.out.println(i + 1 + ": " + triangleArray[i]);
        }
    }
}

