/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.util.logging.Logger;
import misc.LoggedException;
import simulation.geometry.BoundingBox;
import simulation.geometry.SubstrateObject;
import tools.CL_Initializer;

public class Triangle
implements SubstrateObject {
    private static final int D = 3;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private double[] normal;
    private final double[][] vertex;
    private final double[][] w = new double[3][3];
    private final double[] boxhalfsize = new double[3];
    private final double[] boxcenter = new double[3];
    private final double[] u = new double[3];
    private final double[] v = new double[3];
    private double nP;
    private double uu;
    private double vv;
    private double uv;
    private final double p;
    private final int X = 0;
    private final int Y = 1;
    private final int Z = 2;

    public Triangle(double[] dArray, double[] dArray2, double[] dArray3, double d) {
        this.vertex = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            this.vertex[0][i] = dArray[i];
            this.vertex[1][i] = dArray2[i];
            this.vertex[2][i] = dArray3[i];
        }
        this.p = d;
        this.initVectors();
    }

    public void initVectors() {
        int n;
        for (n = 0; n < 3; ++n) {
            this.u[n] = this.vertex[1][n] - this.vertex[0][n];
            this.v[n] = this.vertex[0][n] - this.vertex[2][n];
        }
        this.normal = Triangle.normCrossProd(this.u, this.v);
        this.nP = 0.0;
        this.uu = 0.0;
        this.vv = 0.0;
        this.uv = 0.0;
        for (n = 0; n < 3; ++n) {
            int n2 = n;
            this.v[n2] = this.v[n2] * -1.0;
            this.nP += this.normal[n] * this.vertex[0][n];
            this.uu += this.u[n] * this.u[n];
            this.vv += this.v[n] * this.v[n];
            this.uv += this.u[n] * this.v[n];
        }
    }

    protected static final double[] normCrossProd(double[] dArray, double[] dArray2) {
        int n;
        double[] dArray3 = new double[dArray.length];
        dArray3[0] = dArray[1] * dArray2[2] - dArray[2] * dArray2[1];
        dArray3[1] = -(dArray[0] * dArray2[2] - dArray[2] * dArray2[0]);
        dArray3[2] = dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
        double d = 0.0;
        for (n = 0; n < dArray3.length; ++n) {
            d += dArray3[n] * dArray3[n];
        }
        d = Math.sqrt(d);
        n = 0;
        while (n < dArray3.length) {
            int n2 = n++;
            dArray3[n2] = dArray3[n2] / d;
        }
        return dArray3;
    }

    public double[] getVertex(int n) {
        if (n >= 0 || n < 3) {
            return this.vertex[n];
        }
        throw new LoggedException("Index to verts array out of range 0-2.  Value given: " + n);
    }

    public double[] getNormal() {
        return this.normal;
    }

    @Override
    public boolean crosses(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl, double d, double[] dArray5, boolean[] blArray, double[] dArray6) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < 3; ++i) {
            d2 += this.normal[i] * (this.vertex[0][i] - dArray[i]);
            d3 += this.normal[i] * dArray2[i];
        }
        if (Math.abs(d3) <= 1.0E-14) {
            return false;
        }
        double d4 = d2 / d3;
        if (d4 < 0.0) {
            return false;
        }
        if (d4 >= 1.0) {
            return false;
        }
        double[] dArray7 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray7[i] = dArray[i] + d4 * dArray2[i] - this.vertex[0][i];
        }
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < 3; ++i) {
            d5 += dArray7[i] * this.v[i];
            d6 += dArray7[i] * this.u[i];
        }
        double d7 = this.uv * this.uv - this.uu * this.vv;
        double d8 = (this.uv * d5 - this.vv * d6) / d7;
        if (d8 < 0.0) {
            return false;
        }
        if (d8 > 1.0) {
            return false;
        }
        double d9 = (this.uv * d6 - this.uu * d5) / d7;
        if (d9 >= 0.0 && d8 + d9 <= 1.0) {
            int n;
            dArray4[0] = 0.0;
            for (n = 0; n < 3; ++n) {
                double d10 = dArray[n] + d4 * dArray2[n];
                dArray4[0] = dArray4[0] + d10 * this.normal[n];
            }
            dArray5[0] = d4;
            for (n = 0; n < 3; ++n) {
                dArray3[n] = this.normal[n];
            }
            dArray6[0] = this.p;
            return true;
        }
        return false;
    }

    @Override
    public final BoundingBox getBoundingBox() {
        this.logger.warning("attenmpt to retreive bounding box from individual triangle!");
        this.logger.warning("returning null.");
        return null;
    }

    @Override
    public final double getDiffusivityAt(double[] dArray) {
        this.logger.warning("attempt to query individual triangle for diffusivity!");
        this.logger.warning("returning extracellular diffusivity");
        return CL_Initializer.DIFF_CONST;
    }

    @Override
    public final boolean inside(double[] dArray) {
        this.logger.warning("individual triangle queried for inside() calculation!");
        this.logger.warning("returning false");
        return false;
    }

    @Override
    public final boolean intersectsCubicRegion(double[] dArray, double[] dArray2) {
        for (int i = 0; i < 3; ++i) {
            this.boxcenter[i] = (dArray2[i] + dArray[i]) / 2.0;
            this.boxhalfsize[i] = (dArray2[i] - dArray[i]) / 2.0;
        }
        return this.triBoxOverlap();
    }

    public final double getPermeability(int n) {
        return this.p;
    }

    @Override
    public final boolean boundingBoxIntersects(double[] dArray, double[] dArray2) {
        return true;
    }

    public String toString() {
        String string = "vertices: (";
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                string = string + " " + this.vertex[i][j];
            }
            string = string + ")\t";
        }
        string = string + "\tnormal: (";
        string = string + this.normal[0] + " " + this.normal[1] + " " + this.normal[2] + ")";
        return string;
    }

    private static void testNormalCalc() {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 1.0, 0.0};
        double[] dArray3 = new double[]{0.5, 0.5, 0.0};
        Triangle triangle = new Triangle(dArray, dArray2, dArray3, 0.0);
        double[] dArray4 = triangle.getNormal();
        System.err.println("triangle 1 (xy-plane) normal is: (" + dArray4[0] + "," + dArray4[1] + "," + dArray4[2] + ")");
        dArray3 = new double[]{0.0, 0.5, 0.5};
        triangle = new Triangle(dArray, dArray2, dArray3, 0.0);
        dArray4 = triangle.getNormal();
        System.err.println("triangle 2 (yz-plane) normal is: (" + dArray4[0] + "," + dArray4[1] + "," + dArray4[2] + ")");
        dArray2 = new double[]{1.0, 0.0, 0.0};
        dArray3 = new double[]{0.5, 0.0, 0.5};
        triangle = new Triangle(dArray, dArray2, dArray3, 0.0);
        dArray4 = triangle.getNormal();
        System.err.println("triangle 3 (xz-plane) normal is: (" + dArray4[0] + "," + dArray4[1] + "," + dArray4[2] + ")");
    }

    private final void CROSS(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[1] * dArray3[2] - dArray2[2] * dArray3[1];
        dArray[1] = dArray2[2] * dArray3[0] - dArray2[0] * dArray3[2];
        dArray[2] = dArray2[0] * dArray3[1] - dArray2[1] * dArray3[0];
    }

    private final double DOT(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    private final void SUB(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] - dArray3[0];
        dArray[1] = dArray2[1] - dArray3[1];
        dArray[2] = dArray2[2] - dArray3[2];
    }

    private final void FINDMINMAX(double d, double d2, double d3, double d4, double d5) {
        d5 = d;
        d4 = d5;
        if (d2 < d4) {
            d4 = d2;
        }
        if (d2 > d5) {
            d5 = d2;
        }
        if (d3 < d4) {
            d4 = d3;
        }
        if (d3 > d5) {
            d5 = d3;
        }
    }

    private final boolean planeBoxOverlap(double[] dArray, double d, double[] dArray2) {
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        for (int i = 0; i <= 2; ++i) {
            if (dArray[i] > 0.0) {
                dArray3[i] = -dArray2[i];
                dArray4[i] = dArray2[i];
                continue;
            }
            dArray3[i] = dArray2[i];
            dArray4[i] = -dArray2[i];
        }
        if (this.DOT(dArray, dArray3) + d > 0.0) {
            return false;
        }
        return this.DOT(dArray, dArray4) + d >= 0.0;
    }

    private final boolean AXISTEST_X01(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7 = d * this.w[0][1] - d2 * this.w[0][2];
        double d8 = d * this.w[2][1] - d2 * this.w[2][2];
        if (d7 < d8) {
            d6 = d7;
            d5 = d8;
        } else {
            d6 = d8;
            d5 = d7;
        }
        double d9 = d3 * this.boxhalfsize[1] + d4 * this.boxhalfsize[2];
        return !(d6 > d9) && !(d5 < -d9);
    }

    private final boolean AXISTEST_X2(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7 = d * this.w[0][1] - d2 * this.w[0][2];
        double d8 = d * this.w[1][1] - d2 * this.w[1][2];
        if (d7 < d8) {
            d6 = d7;
            d5 = d8;
        } else {
            d6 = d8;
            d5 = d7;
        }
        double d9 = d3 * this.boxhalfsize[1] + d4 * this.boxhalfsize[2];
        return !(d6 > d9) && !(d5 < -d9);
    }

    private final boolean AXISTEST_Y02(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7 = -d * this.w[0][0] + d2 * this.w[0][2];
        double d8 = -d * this.w[2][0] + d2 * this.w[2][2];
        if (d7 < d8) {
            d6 = d7;
            d5 = d8;
        } else {
            d6 = d8;
            d5 = d7;
        }
        double d9 = d3 * this.boxhalfsize[0] + d4 * this.boxhalfsize[2];
        return !(d6 > d9) && !(d5 < -d9);
    }

    private final boolean AXISTEST_Y1(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7 = -d * this.w[0][0] + d2 * this.w[0][2];
        double d8 = -d * this.w[1][0] + d2 * this.w[1][2];
        if (d7 < d8) {
            d6 = d7;
            d5 = d8;
        } else {
            d6 = d8;
            d5 = d7;
        }
        double d9 = d3 * this.boxhalfsize[0] + d4 * this.boxhalfsize[2];
        return !(d6 > d9) && !(d5 < -d9);
    }

    private final boolean AXISTEST_Z12(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7 = d * this.w[2][0] - d2 * this.w[2][1];
        double d8 = d * this.w[1][0] - d2 * this.w[1][1];
        if (d7 < d8) {
            d6 = d7;
            d5 = d8;
        } else {
            d6 = d8;
            d5 = d7;
        }
        double d9 = d3 * this.boxhalfsize[0] + d4 * this.boxhalfsize[1];
        return !(d6 > d9) && !(d5 < -d9);
    }

    private final boolean AXISTEST_Z0(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7 = d * this.w[0][0] - d2 * this.w[0][1];
        double d8 = d * this.w[1][0] - d2 * this.w[1][1];
        if (d7 < d8) {
            d6 = d7;
            d5 = d8;
        } else {
            d6 = d8;
            d5 = d7;
        }
        double d9 = d3 * this.boxhalfsize[0] + d4 * this.boxhalfsize[1];
        return !(d6 > d9) && !(d5 < -d9);
    }

    public final boolean triBoxOverlap() {
        double[] dArray = new double[3];
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        this.SUB(this.w[0], this.vertex[0], this.boxcenter);
        this.SUB(this.w[1], this.vertex[1], this.boxcenter);
        this.SUB(this.w[2], this.vertex[2], this.boxcenter);
        this.SUB(dArray3, this.w[1], this.w[0]);
        this.SUB(dArray4, this.w[2], this.w[1]);
        this.SUB(dArray5, this.w[0], this.w[2]);
        double d3 = Math.abs(dArray3[0]);
        double d4 = Math.abs(dArray3[1]);
        double d5 = Math.abs(dArray3[2]);
        if (!this.AXISTEST_X01(dArray3[2], dArray3[1], d5, d4)) {
            return false;
        }
        if (!this.AXISTEST_Y02(dArray3[2], dArray3[0], d5, d3)) {
            return false;
        }
        if (!this.AXISTEST_Z12(dArray3[1], dArray3[0], d4, d3)) {
            return false;
        }
        d3 = Math.abs(dArray4[0]);
        d4 = Math.abs(dArray4[1]);
        d5 = Math.abs(dArray4[2]);
        if (!this.AXISTEST_X01(dArray4[2], dArray4[1], d5, d4)) {
            return false;
        }
        if (!this.AXISTEST_Y02(dArray4[2], dArray4[0], d5, d3)) {
            return false;
        }
        if (!this.AXISTEST_Z0(dArray4[1], dArray4[0], d4, d3)) {
            return false;
        }
        d3 = Math.abs(dArray5[0]);
        d4 = Math.abs(dArray5[1]);
        d5 = Math.abs(dArray5[2]);
        if (!this.AXISTEST_X2(dArray5[2], dArray5[1], d5, d4)) {
            return false;
        }
        if (!this.AXISTEST_Y1(dArray5[2], dArray5[0], d5, d3)) {
            return false;
        }
        if (!this.AXISTEST_Z12(dArray5[1], dArray5[0], d4, d3)) {
            return false;
        }
        this.FINDMINMAX(this.w[0][0], this.w[1][0], this.w[2][0], d, d2);
        if (d > this.boxhalfsize[0] || d2 < -this.boxhalfsize[0]) {
            return false;
        }
        this.FINDMINMAX(this.w[0][1], this.w[1][1], this.w[2][1], d, d2);
        if (d > this.boxhalfsize[1] || d2 < -this.boxhalfsize[1]) {
            return false;
        }
        this.FINDMINMAX(this.w[0][2], this.w[1][2], this.w[2][2], d, d2);
        if (d > this.boxhalfsize[2] || d2 < -this.boxhalfsize[2]) {
            return false;
        }
        this.CROSS(dArray2, dArray3, dArray4);
        double d6 = -this.DOT(dArray2, this.w[0]);
        return this.planeBoxOverlap(dArray2, d6, this.boxhalfsize);
    }

    private static void testLineTriangleIntersection() {
        double[] dArray = new double[]{1.0, 1.0, 0.0};
        double[] dArray2 = new double[]{0.0, 1.0, 0.0};
        double[] dArray3 = new double[]{0.5, 0.5, 0.0};
        Triangle triangle = new Triangle(dArray, dArray2, dArray3, 0.0);
        double[] dArray4 = triangle.getNormal();
        System.err.println("triangle has " + triangle);
        System.err.println("normal is (" + dArray4[0] + "," + dArray4[1] + "," + dArray4[2] + ")");
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[1];
        double[] dArray8 = new double[1];
        double[] dArray9 = new double[1];
        boolean[] blArray = new boolean[1];
        dArray5[0] = 0.5;
        dArray5[1] = 0.75;
        dArray5[2] = 0.5;
        dArray6[0] = 0.0;
        dArray6[1] = 0.0;
        dArray6[2] = -0.4;
        boolean bl = triangle.crosses(dArray5, dArray6, dArray4, dArray7, false, 0.4, dArray8, blArray, dArray9);
        System.err.println("short case: crosses= " + bl);
        dArray5[2] = 0.1;
        dArray6[2] = 0.4;
        bl = triangle.crosses(dArray5, dArray6, dArray4, dArray7, false, 0.4, dArray8, blArray, dArray9);
        System.err.println("opposite direction case: crosses= " + bl);
        dArray5[2] = 1.0;
        dArray6[0] = 0.5;
        dArray6[2] = 0.0;
        bl = triangle.crosses(dArray5, dArray6, dArray4, dArray7, false, 0.5, dArray8, blArray, dArray9);
        System.err.println("parallel case: crosses= " + bl);
        dArray5[0] = 1.0;
        dArray5[1] = 0.5;
        dArray5[2] = 0.5;
        dArray6[0] = 0.0;
        dArray6[1] = 0.0;
        dArray6[2] = -1.0;
        bl = triangle.crosses(dArray5, dArray6, dArray4, dArray7, false, 1.0, dArray8, blArray, dArray9);
        System.err.println("plane intersection case: crosses= " + bl);
        dArray5[0] = 0.5;
        dArray5[1] = 0.75;
        dArray5[2] = 0.5;
        bl = triangle.crosses(dArray5, dArray6, dArray4, dArray7, false, 1.0, dArray8, blArray, dArray9);
        System.err.println("triangle intersection case: crosses= " + bl);
        System.err.println("\tnormal= (" + dArray4[0] + "," + dArray4[1] + "," + dArray4[2] + ")");
        System.err.println("\td= " + dArray7[0]);
        System.err.println("\tintDist= " + dArray8[0]);
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        boolean[] blArray = new boolean[1];
        double[] dArray5 = new double[]{1.5773502691896257, 0.42264973081037416, 1.5773502691896257};
        double[] dArray6 = new double[]{0.42264973081037416, 1.5773502691896257, 1.5773502691896257};
        double[] dArray7 = new double[]{1.5773502691896257, 1.5773502691896257, 1.5773502691896257};
        Triangle triangle = new Triangle(dArray5, dArray6, dArray7, 0.0);
        double[] dArray8 = new double[]{1.1, 1.0, 1.0};
        double[] dArray9 = new double[]{0.0, 0.0, 2.4};
        boolean bl = triangle.crosses(dArray8, dArray9, dArray, dArray2, false, 2.4, dArray3, blArray, dArray4);
        System.err.println("crossing is " + bl);
        if (bl) {
            System.err.println("d= " + dArray2[0]);
            System.err.println("intDist= " + dArray3[0]);
        }
    }
}

