/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.util.logging.Logger;
import misc.LoggedException;
import simulation.SimulationParams;
import simulation.geometry.CrossingCylinderSubstrate;
import simulation.geometry.DistributedRadiusCylinderSubstrate;
import simulation.geometry.EmptySubstrate;
import simulation.geometry.FacetCylinderSubstrate;
import simulation.geometry.FixedFracCellularLattice;
import simulation.geometry.IsoCellularLattice;
import simulation.geometry.MeshSubstrate;
import simulation.geometry.ModCellularLattice;
import simulation.geometry.ParallelCylinderSubstrate;
import simulation.geometry.PercCellularLattice;
import simulation.geometry.PercolationSubstrate;
import simulation.geometry.SquashyInflammationSubstrate;
import simulation.geometry.StripedCellularLattice;
import simulation.geometry.Substrate;

public class SubstrateFactory {
    private static Logger logger = Logger.getLogger("simulation.GeometryFactory");
    public static final int CELL_ISO = 0;
    public static final int CELL_STRIPED = 1;
    public static final int CELL_MODULAR = 2;
    public static final int CELL_FIXEDFRAC = 3;
    public static final int CELL_PERC = 4;
    public static final int CYL_1_FIXED = 5;
    public static final int CYL_1_DISTRIB = 6;
    public static final int CYL_1_INFLAM = 7;
    public static final int CYL_1_FACET = 8;
    public static final int TRI_PLY_MESH = 9;
    public static final int CYL_1_PERC = 10;
    public static final int CYL_1_MYELIN = 11;
    public static final int CYL_2_FIXED = 12;
    public static final int EMPTY = 13;

    public static Substrate getSubstrate(int n, Object[] objectArray, SimulationParams simulationParams) {
        if (n == 0) {
            if (objectArray.length != 2) {
                String string = new String("isocellular lattice needs 2 parameters, but was passed " + objectArray.length);
                logger.severe(string);
                throw new RuntimeException(string);
            }
            return new IsoCellularLattice((Double)objectArray[0], (Integer)objectArray[1], simulationParams);
        }
        if (n == 1) {
            if (objectArray.length != 3) {
                String string = new String("striped cellular lattice needs 3 parameters, but was passed " + objectArray.length);
                logger.severe(string);
                throw new RuntimeException(string);
            }
            return new StripedCellularLattice((Double)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], simulationParams);
        }
        if (n == 2) {
            if (objectArray.length != 4) {
                String string = new String("modular lattice needs 4 parameters, but was passed " + objectArray.length);
                logger.severe(string);
                throw new RuntimeException(string);
            }
            return new ModCellularLattice((Double)objectArray[0], (Integer)objectArray[1], ((Double)objectArray[2]).intValue(), (Integer)objectArray[3], simulationParams);
        }
        if (n == 3) {
            if (objectArray.length != 3) {
                String string = new String("fixed fraction cellular lattice needs 3 parameters, but was passed " + objectArray.length);
                logger.severe(string);
                throw new RuntimeException(string);
            }
            return new FixedFracCellularLattice((Double)objectArray[0], (Integer)objectArray[1], (Double)objectArray[2], simulationParams);
        }
        if (n == 4) {
            if (objectArray.length != 3) {
                String string = new String("percolation lattice needs 3 parameters, but was passed " + objectArray.length);
                logger.severe(string);
                throw new RuntimeException(string);
            }
            return new PercCellularLattice((Double)objectArray[0], (Integer)objectArray[1], (Double)objectArray[2], simulationParams);
        }
        if (n == 5) {
            if (objectArray.length != 3) {
                String string = new String("parallel cylinder substrate requires 3 params, but was passed " + objectArray.length);
                logger.severe(string);
                throw new RuntimeException(string);
            }
            return new ParallelCylinderSubstrate((Double)objectArray[0], (Double)objectArray[1], (Integer)objectArray[2], simulationParams);
        }
        if (n == 6) {
            if (objectArray.length != 4) {
                String string = new String("distributed cylinder substrate requires 4 parameters but was passed " + objectArray.length);
                logger.severe(string);
                throw new RuntimeException(string);
            }
            return new DistributedRadiusCylinderSubstrate((Double)objectArray[0], (Integer)objectArray[1], (Double)objectArray[2], (Double)objectArray[3], simulationParams);
        }
        if (n == 7) {
            if (objectArray.length != 6) {
                String string = new String("Inflammatory cylinder substrate needs 6 params but was passed " + objectArray.length);
                logger.severe(string);
                throw new RuntimeException(string);
            }
            return new SquashyInflammationSubstrate((Double)objectArray[0], (Double)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3], (Integer)objectArray[4], (Double)objectArray[5], simulationParams);
        }
        if (n == 8) {
            if (objectArray.length != 3) {
                String string = new String("Facetted cylinder substrate requires geometry params array of length three but was passed " + objectArray.length);
                throw new LoggedException(string);
            }
            return new FacetCylinderSubstrate((Double)objectArray[0], (Double)objectArray[1], (Integer)objectArray[2], simulationParams);
        }
        if (n == 9) {
            if (objectArray.length != 3) {
                String string = new String("triangular mesh substrate requires 3 params, but passed " + objectArray.length);
                throw new LoggedException(string);
            }
            return new MeshSubstrate((String)objectArray[0], (Double)objectArray[1], (Double)objectArray[2], simulationParams);
        }
        if (n == 10) {
            if (objectArray.length != 7) {
                String string = new String("Percolation cylinder substrate needs 6 params but was passed " + objectArray.length);
                logger.severe(string);
                throw new RuntimeException(string);
            }
            return new PercolationSubstrate((Double)objectArray[0], (Double)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3], (Integer)objectArray[4], (Double)objectArray[5], (Integer)objectArray[6], simulationParams);
        }
        if (n == 11) {
            if (objectArray.length != 7) {
                throw new RuntimeException("Parallel myelinated cylinder substrate requires 7 parameters but was passed " + objectArray.length);
            }
            return new ParallelCylinderSubstrate((Double)objectArray[0], (Double)objectArray[1], (Double)objectArray[2], (Double)objectArray[3], (Double)objectArray[4], (Double)objectArray[5], (Integer)objectArray[6], simulationParams);
        }
        if (n == 12) {
            if (objectArray.length != 2) {
                throw new LoggedException("Fixed radius crossing cylinder substrate requires either 2 or 3 parameters, but was passed " + objectArray.length);
            }
            return new CrossingCylinderSubstrate((Double)objectArray[0], (Double)objectArray[1], simulationParams);
        }
        if (n == 13) {
            return new EmptySubstrate(simulationParams);
        }
        String string = new String("unrecognised substrate type " + n);
        logger.severe(string);
        throw new RuntimeException(string);
    }

    public static void main(String[] stringArray) {
    }
}

