/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import imaging.SchemeV0;
import java.util.logging.Logger;
import numerics.MTRandom;
import simulation.SimulationParams;
import simulation.dynamics.StepAmender;
import simulation.dynamics.StepAmenderFactory;
import simulation.dynamics.Walker;
import simulation.geometry.ParallelCylinderSubstrate;
import simulation.geometry.SubstrateFactory;
import tools.CL_Initializer;

public abstract class Substrate {
    Logger logger = Logger.getLogger(this.getClass().getName());
    private final int D = 3;
    private final double[] p = new double[1];
    private final double[] recheckp = new double[1];
    protected final double[] L;
    private final double[] normal;
    private final double[] recheckNormal;
    private final double[] amended;
    private final double[] recheckAmended;
    private final double[] unamended;
    private final double[] recheckUnamended;
    private final double[] toBarrier;
    private final double[] recheckToBarrier;
    private final double[] intPoint;
    private final double[] newStep;
    private final double[] d;
    private final double[] recheckd;
    private final boolean[] in;
    private final boolean[] recheckIn;
    protected final double[] subsCoords = new double[3];
    private final double[] offset = new double[3];
    private final MTRandom twister;
    private final StepAmender amender;
    public static double factor = 1.0;
    protected double[] intFactor;
    public final double a = 100000.0;
    private final double[] xmin = new double[3];
    private final double[] xmax = new double[3];
    public double[] border = new double[3];
    protected boolean substrateInfo = SimulationParams.substrateInfo;

    public Substrate(SimulationParams simulationParams, double[] dArray) {
        this.L = dArray;
        this.normal = new double[3];
        this.recheckNormal = new double[3];
        this.amended = new double[3];
        this.recheckAmended = new double[3];
        this.unamended = new double[3];
        this.recheckUnamended = new double[3];
        this.d = new double[1];
        this.recheckd = new double[1];
        this.in = new boolean[1];
        this.recheckIn = new boolean[1];
        this.toBarrier = new double[3];
        this.recheckToBarrier = new double[3];
        this.intPoint = new double[3];
        this.newStep = new double[3];
        this.twister = new MTRandom(CL_Initializer.seed);
        this.amender = StepAmenderFactory.getStepAmender(SimulationParams.sim_amender_type);
        for (int i = 0; i < 3; ++i) {
            this.xmin[i] = -this.L[i] / 100000.0;
            this.xmax[i] = this.L[i] * 1.00001;
            this.border[i] = this.L[i] / 100000.0;
        }
    }

    public final void amend(Walker walker, double[] dArray, double d, int n) {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        double d2 = 0.0;
        for (n2 = 0; n2 < 3; ++n2) {
            this.newStep[n2] = 0.0;
        }
        bl = this.crossesMembrane(walker, this.newStep, dArray, this.normal, this.d, bl3, d2, this.in, this.p);
        n2 = 0;
        while (bl) {
            int n3;
            this.getSubstrateCoords(walker.r, this.newStep, this.subsCoords);
            ++n2;
            this.amender.amendStep(walker, this.subsCoords, this.newStep, dArray, this.normal, this.d, d2, this.toBarrier, this.amended, this.unamended, this.L, d, n);
            bl2 = true;
            for (int i = 0; i < 3; ++i) {
                int n4 = i;
                this.newStep[n4] = this.newStep[n4] + this.toBarrier[i];
            }
            double d3 = this.twister.nextDouble();
            if (d3 >= this.p[0]) {
                for (n3 = 0; n3 < 3; ++n3) {
                    dArray[n3] = this.amended[n3];
                }
            } else {
                for (n3 = 0; n3 < 3; ++n3) {
                    dArray[n3] = this.unamended[n3];
                }
            }
            bl3 = true;
            bl = this.crossesMembrane(walker, this.newStep, dArray, this.normal, this.d, bl3, d2, this.in, this.p);
        }
        if (bl2) {
            for (int i = 0; i < 3; ++i) {
                int n5 = i;
                this.newStep[n5] = this.newStep[n5] + dArray[i];
                dArray[i] = this.newStep[i];
            }
        }
    }

    protected boolean checkBoundaryIntersection(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, boolean bl, double d, double[] dArray6, boolean[] blArray, double[] dArray7) {
        int n;
        double d2;
        int n2;
        double[] dArray8 = new double[3];
        int[] nArray = new int[3];
        boolean[] blArray2 = new boolean[3];
        int n3 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            d2 = dArray[n2] + dArray3[n2];
            if (d2 < this.xmin[n2]) {
                dArray8[n3] = (this.xmin[n2] - dArray[n2]) / dArray3[n2];
                nArray[n3] = n2;
                blArray2[n3] = true;
                ++n3;
                continue;
            }
            if (!(d2 > this.xmax[n2])) continue;
            dArray8[n3] = (this.xmax[n2] - dArray[n2]) / dArray3[n2];
            nArray[n3] = n2;
            blArray2[n3] = false;
            ++n3;
        }
        if (n3 == 0) {
            return false;
        }
        n2 = 0;
        d2 = dArray8[0];
        int n4 = nArray[0];
        for (int i = 1; i < n3; ++i) {
            if (!(dArray8[i] < d2)) continue;
            d2 = dArray8[i];
            n4 = nArray[i];
            n2 = i;
        }
        double d3 = 0.0;
        for (n = 0; n < 3; ++n) {
            d3 += dArray3[n] * dArray3[n];
        }
        d3 = Math.sqrt(d3);
        dArray5[0] = blArray2[n2] ? -this.L[n4] / 100000.0 : this.L[n4] * 1.00001;
        dArray6[0] = d2;
        dArray7[0] = 1.0;
        for (n = 0; n < 3; ++n) {
            dArray4[n] = n == n4 ? 1.0 : 0.0;
        }
        return true;
    }

    public abstract boolean crossesMembrane(Walker var1, double[] var2, double[] var3, double[] var4, double[] var5, boolean var6, double var7, boolean[] var9, double[] var10);

    public abstract double[] getSubstrateSize();

    public abstract double getPeakCoord();

    public abstract void init();

    public abstract boolean intracellular(Walker var1);

    public double getDiffusivityAt(double[] dArray) {
        return CL_Initializer.DIFF_CONST;
    }

    public void getSubstrateCoords(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
            double d = Math.floor(dArray3[i] / this.L[i]);
            dArray3[i] = dArray3[i] - d * this.L[i];
        }
    }

    public void testAmendment(Walker walker, double[] dArray, double[] dArray2, double[] dArray3, double d, double[] dArray4, double[] dArray5, double[] dArray6) {
        double[] dArray7 = new double[]{0.0, 0.0, 0.0};
        this.getSubstrateCoords(walker.r, dArray7, this.subsCoords);
        this.amender.amendStep(walker, this.subsCoords, dArray7, dArray, dArray2, dArray3, d, dArray4, dArray5, dArray6, this.L, 0.0, 1);
    }

    public static void testStepAmendment() {
        Object[] objectArray = new Object[]{new Double(1.0), new Integer(3)};
        double[] dArray = new double[]{0.1};
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        SimulationParams simulationParams = new SimulationParams(1, 1000, 0.0, 0, 0, objectArray, 1, 1.5, schemeV0);
        Substrate substrate = SubstrateFactory.getSubstrate(7, objectArray, simulationParams);
        double[] dArray2 = new double[]{1.5, 1.5, 0.0};
        double[] dArray3 = new double[]{1.0, -1.0, 0.0};
        double[] dArray4 = new double[]{0.0, 1.0, 0.0};
        double[] dArray5 = new double[]{1.0};
        Walker walker = new Walker(dArray2);
    }

    protected static final void testBoundaryIntersection() {
        Object[] objectArray = new Object[4];
        SimulationParams simulationParams = new SimulationParams(1, 1000, 0.0, 1, 5, objectArray, 1, 1.0E-5, 0.1);
        ParallelCylinderSubstrate parallelCylinderSubstrate = new ParallelCylinderSubstrate(4.0E-6, 1.0E-6, 1, simulationParams);
        double[] dArray = new double[]{2.0E-6, 2.0E-6, 2.0E-6};
        Walker walker = new Walker(dArray);
        double[] dArray2 = new double[]{-3.0E-6, 0.0, 0.0};
        parallelCylinderSubstrate.amend(walker, dArray2, 0.0, 0);
        dArray = new double[]{6.0E-6, 6.0E-6, 6.0E-6};
        walker = new Walker(dArray);
        dArray2 = new double[]{3.0E-6, 0.0, 0.0};
        parallelCylinderSubstrate.amend(walker, dArray2, 0.0, 0);
    }

    private static final void testIntersectionOrdering() {
        Object[] objectArray = new Object[4];
        SimulationParams simulationParams = new SimulationParams(1, 1000, 0.0, 1, 5, objectArray, 1, 1.0E-5, 0.1);
        ParallelCylinderSubstrate parallelCylinderSubstrate = new ParallelCylinderSubstrate(4.0E-6, 1.0E-6, 1, simulationParams);
        double[] dArray = new double[]{4.0E-6, 6.0E-6, 4.0E-6};
        Walker walker = new Walker(dArray);
        double[] dArray2 = new double[]{0.0, 2.5E-6, 0.0};
        parallelCylinderSubstrate.amend(walker, dArray2, 0.0, 0);
        dArray = new double[]{5.0E-7, 4.0E-6, 4.0E-6};
        walker = new Walker(dArray);
        dArray2 = new double[]{-3.0E-6, 0.0, 0.0};
        parallelCylinderSubstrate.amend(walker, dArray2, 0.0, 0);
    }

    private static final void testVeryLongStep() {
        Object[] objectArray = new Object[4];
        SimulationParams simulationParams = new SimulationParams(1, 1000, 0.0, 1, 5, objectArray, 1, 1.0E-5, 0.1);
        ParallelCylinderSubstrate parallelCylinderSubstrate = new ParallelCylinderSubstrate(4.0E-6, 1.0E-6, 1, simulationParams);
        double[] dArray = new double[]{6.0E-6, 2.0E-6, 2.0E-6};
        Walker walker = new Walker(dArray);
        double[] dArray2 = new double[]{0.0, -2.0E-5, 0.0};
        parallelCylinderSubstrate.amend(walker, dArray2, 0.0, 0);
        dArray2 = new double[]{0.0, 2.0E-5, 0.0};
        parallelCylinderSubstrate.amend(walker, dArray2, 0.0, 0);
    }

    public static void main(String[] stringArray) {
        Substrate.testVeryLongStep();
    }
}

