/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import imaging.SchemeV0;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import numerics.Vector3D;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.geometry.BasicCylinder;
import simulation.geometry.Substrate;
import simulation.geometry.SubstrateFactory;

public class SquashyCylinder
extends BasicCylinder {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private final int D = 3;
    private static final double MaxIntersectionAngle = 2.199114857512855;
    private ArrayList<AnglePair> anglePairs = new ArrayList();
    protected ArrayList<Chord> chords = new ArrayList();
    private ArrayList<SquashyCylinder> bumps = new ArrayList();
    private HashMap<AnglePair, Chord> chordsForAp = new HashMap();
    private HashMap<Chord, AnglePair> apsForChord = new HashMap();
    private HashMap<SquashyCylinder, AnglePair> apsForCylinders = new HashMap();
    private HashMap<Chord, SquashyCylinder> cylsForChords = new HashMap();
    private boolean expanding = true;
    private double[] initialPos = new double[3];
    private boolean initiallyIn;
    private int skipChord = -1;
    private final double[] P = super.getPosition();
    private final double r = super.getRadius();
    private ArrayList<SquashyCylinder> myClones = null;
    private final double p;

    public SquashyCylinder(double[] dArray, double d, double d2) {
        super(dArray, d, d2);
        this.p = d2;
    }

    public boolean abutts(SquashyCylinder squashyCylinder) {
        double d = this.getDistanceFrom(squashyCylinder.getPosition());
        return d <= this.getRadius() + squashyCylinder.getRadius();
    }

    public final boolean isExpanding() {
        return this.expanding;
    }

    public final void stopExpanding() {
        this.expanding = false;
        if (this.myClones != null) {
            for (SquashyCylinder squashyCylinder : this.myClones) {
                squashyCylinder.cloneHasStopped();
            }
        }
    }

    public final void cloneHasStopped() {
        this.expanding = false;
    }

    private double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    private final double[] get2dIntersectionRoots(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.getPosition();
        double d = dArray[0] - dArray3[0];
        double d2 = dArray[1] - dArray3[1];
        double d3 = dArray[0] + dArray2[0] - dArray3[0];
        double d4 = dArray[1] + dArray2[1] - dArray3[1];
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        double d8 = d * d4 - d3 * d2;
        double d9 = this.getRadius();
        double d10 = d9 * d9 * d7 * d7 - d8 * d8;
        if (!(d10 >= 0.0)) {
            return null;
        }
        double d11 = Math.sqrt(d10);
        double d12 = d6 <= 0.0 ? -1.0 : 1.0;
        double d13 = d12 * d5 * d11;
        double d14 = Math.abs(d6) * d11;
        double d15 = (d8 * d6 + d13) / (d7 * d7);
        double d16 = (-d8 * d5 + d14) / (d7 * d7);
        double d17 = (d8 * d6 - d13) / (d7 * d7);
        double d18 = (-d8 * d5 - d14) / (d7 * d7);
        double[] dArray4 = new double[]{Math.sqrt((d15 - d) * (d15 - d) + (d16 - d2) * (d16 - d2)), Math.sqrt((d17 - d3) * (d17 - d3) + (d18 - d4) * (d18 - d4))};
        double d19 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d19 += dArray2[i] * dArray2[i];
        }
        d19 = Math.sqrt(d19);
        dArray4[0] = dArray4[0] / d19;
        dArray4[1] = dArray4[1] / d19;
        return dArray4;
    }

    @Override
    public final boolean crosses(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl, double d, double[] dArray5, boolean[] blArray, double[] dArray6) {
        int n;
        double d2;
        double d3;
        double[] dArray7 = new double[]{dArray[0] - this.P[0], dArray[1] - this.P[1], 0.0};
        double[] dArray8 = new double[]{dArray[0] - this.P[0] + dArray2[0], dArray[1] - this.P[1] + dArray2[1], 0.0};
        double[] dArray9 = new double[3];
        double d4 = Math.sqrt(dArray7[0] * dArray7[0] + dArray7[1] * dArray7[1]);
        double d5 = Math.sqrt(dArray8[0] * dArray8[0] + dArray8[1] * dArray8[1]);
        if (!bl) {
            blArray[0] = this.initiallyIn = this.inside(dArray7);
        }
        if (d4 <= this.r && d5 <= this.r) {
            int n2 = 0;
            for (Chord chord : this.chords) {
                if ((!bl || n2 != this.skipChord) && chord.crossedBy(dArray7, dArray2, dArray3, dArray4, bl, d, this.P, dArray5)) {
                    this.skipChord = n2;
                    SquashyCylinder squashyCylinder = this.cylsForChords.get(chord);
                    squashyCylinder.ignoreIntersectionWith(this);
                    dArray6[0] = this.p;
                    return true;
                }
                ++n2;
            }
            this.skipChord = -1;
            return false;
        }
        double[] dArray10 = super.getIntersectionRoots(dArray, dArray2);
        if (dArray10 == null) {
            return false;
        }
        if (dArray10[0] < 0.0 && dArray10[1] < 0.0) {
            return false;
        }
        if ((!(dArray10[0] >= 0.0) || !(dArray10[0] <= 1.0)) && dArray10[1] >= 0.0 && dArray10[1] <= 1.0) {
            d3 = dArray10[0];
            dArray10[0] = dArray10[1];
            dArray10[1] = d3;
        }
        if (dArray10[0] >= 0.0 && dArray10[0] <= 1.0 && dArray10[1] >= 0.0 && dArray10[1] <= 1.0 && dArray10[0] > dArray10[1]) {
            d3 = dArray10[0];
            dArray10[0] = dArray10[1];
            dArray10[1] = d3;
        }
        d3 = 0.0;
        for (int i = 0; i < 2; ++i) {
            d3 += dArray2[i] * dArray2[i];
            dArray9[i] = dArray[i] + dArray2[i];
        }
        d3 = Math.sqrt(d3);
        double[] dArray11 = new double[2];
        int n3 = 0;
        for (int i = 0; i < dArray10.length; ++i) {
            double[] dArray12 = new double[]{dArray[0] + dArray10[i] * dArray2[0], dArray[1] + dArray10[i] * dArray2[1], dArray[2] + dArray10[i] * dArray2[2]};
            double[] dArray13 = this.getPosition();
            d2 = Math.atan2(dArray12[1] - dArray13[1], dArray12[0] - dArray13[0]);
            dArray11[n3++] = this.mapToCircle(d2);
        }
        boolean[] blArray2 = new boolean[]{false, false};
        for (n = 0; n < n3; ++n) {
            double d6 = dArray11[n];
            int n4 = 0;
            for (AnglePair anglePair : this.anglePairs) {
                if (anglePair.contains(d6)) {
                    blArray2[n] = true;
                    Chord chord = this.chordsForAp.get(anglePair);
                    if ((!bl || n4 != this.skipChord) && chord.crossedBy(dArray7, dArray2, dArray3, dArray4, bl, d, this.P, dArray5)) {
                        this.skipChord = n4;
                        SquashyCylinder squashyCylinder = this.cylsForChords.get(chord);
                        squashyCylinder.ignoreIntersectionWith(this);
                        return true;
                    }
                }
                ++n4;
            }
            if (n == 0 && !blArray2[n]) break;
        }
        this.skipChord = -1;
        for (n = 0; n < dArray10.length; ++n) {
            int n5;
            if (blArray2[n] || !(dArray10[n] > 0.0) || !(dArray10[n] <= 1.0)) continue;
            double[] dArray14 = new double[]{dArray[0] + dArray10[n] * dArray2[0] - this.P[0], dArray[1] + dArray10[n] * dArray2[1] - this.P[1], dArray[2] + dArray10[n] * dArray2[2] - this.P[2]};
            d2 = Math.atan2(dArray14[1], dArray14[0]);
            Object object = new double[dArray3.length];
            object[0] = Math.cos(d2);
            object[1] = Math.sin(d2);
            object[2] = 0.0;
            double d7 = 0.0;
            for (n5 = 0; n5 < 2; ++n5) {
                d7 += (dArray14[n5] + this.P[n5]) * object[n5];
            }
            if (bl) {
                this.initiallyIn = blArray[0];
                n5 = this.checkSkipping(dArray9) ? 1 : 0;
                if (n5 != 0 && this.skipChord != -1) continue;
            }
            dArray4[0] = d7;
            dArray5[0] = 0.0;
            for (n5 = 0; n5 < dArray3.length; ++n5) {
                dArray3[n5] = (double)object[n5];
            }
            dArray5[0] = dArray10[n];
            if (!bl) {
                for (n5 = 0; n5 < 3; ++n5) {
                    this.initialPos[n5] = dArray7[n5];
                }
                if (this.inside(dArray)) {
                    this.initiallyIn = true;
                    blArray[0] = true;
                } else {
                    this.initiallyIn = false;
                    blArray[0] = false;
                }
            }
            return true;
        }
        return false;
    }

    protected final void ignoreIntersectionWith(SquashyCylinder squashyCylinder) {
        int n;
        AnglePair anglePair = this.apsForCylinders.get(squashyCylinder);
        Chord chord = this.chordsForAp.get(anglePair);
        this.skipChord = n = this.chords.indexOf(chord);
    }

    private final boolean checkSkipping(double[] dArray) {
        boolean bl = this.inside(dArray);
        return this.initiallyIn == bl;
    }

    private AnglePair getIntersesctionPair(SquashyCylinder squashyCylinder) {
        double d;
        double d2;
        double d3;
        double d4 = this.getDistanceFrom(squashyCylinder.getPosition());
        double d5 = this.getRadius();
        double d6 = Math.sqrt(d5 * d5 - (d3 = (d4 * d4 - (d2 = squashyCylinder.getRadius()) * d2 + d5 * d5) / (2.0 * d4)) * d3);
        double d7 = Math.atan2(d6, d3);
        if (d7 > (d = Math.atan2(-d6, d3))) {
            double d8 = d7;
            d7 = d;
            d = d8;
        }
        double[] dArray = this.getPosition();
        double[] dArray2 = squashyCylinder.getPosition();
        double[] dArray3 = new double[]{dArray2[0] - dArray[0], dArray2[1] - dArray[1]};
        double d9 = Math.atan2(dArray3[1], dArray3[0]);
        d7 += d9;
        d += d9;
        if ((d7 = this.mapToCircle(d7)) > (d = this.mapToCircle(d))) {
            double d10 = d7;
            d7 = d;
            d = d10;
        }
        return new AnglePair(d7, d, d5, squashyCylinder);
    }

    private final double mapToCircle(double d) {
        double d2 = Math.floor(d / (Math.PI * 2));
        double d3 = Math.PI * 2 * d2;
        double d4 = d - d3;
        return d4;
    }

    private Chord getChord(AnglePair anglePair) {
        double[] dArray = anglePair.getLowerCoords();
        double[] dArray2 = anglePair.getUpperCoords();
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray2[0];
        double d4 = dArray2[1];
        double d5 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        double d6 = 0.0;
        double d7 = d5;
        Chord chord = new Chord(anglePair, d6, d7);
        int n = 0;
        for (AnglePair anglePair2 : this.anglePairs) {
            double[] dArray3;
            Chord chord2 = this.chordsForAp.get(anglePair2);
            if (anglePair2.contains(anglePair.lower)) {
                dArray3 = chord2.getIntersectionParams(d, d2, d3, d4);
                chord.tmin = dArray3[0];
                chord2.tmax = dArray3[1];
                if (d6 < 0.0) {
                    String string = new String("negative intersection parameter between overlapping chords. t= " + d6);
                    this.logger.severe(string);
                    throw new RuntimeException(string);
                }
            }
            if (anglePair2.contains(anglePair.upper)) {
                dArray3 = chord2.getIntersectionParams(d, d2, d3, d4);
                chord.tmax = dArray3[0];
                chord2.tmin = dArray3[1];
                if (d7 > d5) {
                    String string = new String("intersection parameter between overlapping chords greater than cord length. t=" + d7 + ", len= " + d5);
                    this.logger.severe(string);
                    throw new RuntimeException(string);
                }
            }
            ++n;
        }
        return chord;
    }

    private void removeZeroLengthChords() {
        Iterator<Chord> iterator = this.chords.iterator();
        ArrayList<Chord> arrayList = new ArrayList<Chord>();
        while (iterator.hasNext()) {
            Chord chord = iterator.next();
            if (!(chord.tmax - chord.tmin <= 1.0E-14)) continue;
            arrayList.add(chord);
        }
        if (arrayList.size() > 0) {
            for (Chord chord : arrayList) {
                AnglePair anglePair = this.apsForChord.get(chord);
                this.chords.remove(chord);
                this.anglePairs.remove(anglePair);
            }
        }
    }

    public void addIntersectionWith(SquashyCylinder squashyCylinder) {
        AnglePair anglePair = this.getIntersesctionPair(squashyCylinder);
        Chord chord = this.getChord(anglePair);
        if (Math.abs(anglePair.upper - anglePair.lower) >= 2.199114857512855) {
            this.stopExpanding();
            squashyCylinder.stopExpanding();
        }
        this.bumps.add(squashyCylinder);
        this.anglePairs.add(anglePair);
        this.chords.add(chord);
        this.chordsForAp.put(anglePair, chord);
        this.apsForChord.put(chord, anglePair);
        this.apsForCylinders.put(squashyCylinder, anglePair);
        this.cylsForChords.put(chord, squashyCylinder);
        this.removeZeroLengthChords();
    }

    public final boolean hasIntersectionWith(SquashyCylinder squashyCylinder) {
        return this.bumps.contains(squashyCylinder);
    }

    private AnglePair testGetAnglePair(double[] dArray, double[] dArray2) {
        return new AnglePair(dArray, dArray2);
    }

    public final void drawCrossSection(BufferedWriter bufferedWriter) throws IOException {
        int n;
        int n2 = 100;
        double[] dArray = this.getPosition();
        double d = this.getRadius();
        for (n = 0; n <= n2; ++n) {
            double d2 = Math.PI * 2 * (double)n / (double)n2;
            double d3 = dArray[0] + d * Math.cos(d2);
            double d4 = dArray[1] + d * Math.sin(d2);
            bufferedWriter.write(d3 + "," + d4 + "\n");
        }
        n = 0;
        bufferedWriter.flush();
    }

    public final void addToMyClones(SquashyCylinder squashyCylinder) {
        if (this.myClones == null) {
            this.myClones = new ArrayList();
        }
        this.myClones.add(squashyCylinder);
    }

    public final void propagateCloneRelationships() {
        if (this.myClones != null) {
            for (SquashyCylinder squashyCylinder : this.myClones) {
                squashyCylinder.addToMyClones(this);
                for (SquashyCylinder squashyCylinder2 : this.myClones) {
                    if (squashyCylinder2 == squashyCylinder) continue;
                    squashyCylinder.addToMyClones(squashyCylinder2);
                }
            }
        }
    }

    private static final void testEqualSizeIntersection() {
        double d = 1.0;
        double d2 = 3.0 * d / 2.0;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{d2, 0.0, 0.0};
        SquashyCylinder squashyCylinder = new SquashyCylinder(dArray, d, 0.0);
        SquashyCylinder squashyCylinder2 = new SquashyCylinder(dArray2, d, 0.0);
        double d3 = squashyCylinder.getDistanceFrom(squashyCylinder2.getPosition());
        System.err.println("testing overlapping cylinders of equal size:");
        System.err.println("\tdist = " + d3 + ", d=" + d2);
        AnglePair anglePair = squashyCylinder.getIntersesctionPair(squashyCylinder2);
        System.err.println("\tanglePair from squashy1 is (" + anglePair.lower + ", " + anglePair.upper + ")");
        System.err.println("\twhich is (" + d * Math.sin(anglePair.lower) + ", " + d * Math.cos(anglePair.lower) + ") and (" + d * Math.sin(anglePair.upper) + ", " + Math.cos(anglePair.upper) + ")");
        System.err.println("\ttesting chord construction");
        Chord chord = squashyCylinder.getChord(anglePair);
        double[] dArray3 = chord.cordVec;
        double[] dArray4 = chord.normal;
        System.err.println("\t\tChord vector is (" + dArray3[0] + ", " + dArray3[1] + ")");
        System.err.println("\t\tChord normal is (" + dArray4[0] + ", " + dArray4[1] + ")");
    }

    private static final void testUnequalSizeIntersection() {
        double d = 1.0;
        double d2 = 0.6;
        double d3 = 1.5;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{d3, 0.0, 0.0};
        SquashyCylinder squashyCylinder = new SquashyCylinder(dArray, d, 0.0);
        SquashyCylinder squashyCylinder2 = new SquashyCylinder(dArray2, d2, 0.0);
        double d4 = squashyCylinder.getDistanceFrom(squashyCylinder2.getPosition());
        System.err.println("testing overlapping cylinders of unequal sizes:");
        System.err.println("\tr1 = " + d + "    r2 = " + d2);
        System.err.println("\tdist = " + d4 + ", d=" + d3);
        AnglePair anglePair = squashyCylinder.getIntersesctionPair(squashyCylinder2);
        System.err.println("\tanglePair from squashy1 is (" + anglePair.lower + ", " + anglePair.upper + ")");
        double[] dArray3 = anglePair.getLowerCoords();
        double[] dArray4 = anglePair.getUpperCoords();
        System.err.println("\twhich is (" + dArray3[0] + ", " + dArray3[1] + ") and (" + dArray4[0] + ", " + dArray4[1] + ")");
        System.err.println("\ttesting chord construction");
        Chord chord = squashyCylinder.getChord(anglePair);
        double[] dArray5 = chord.cordVec;
        double[] dArray6 = chord.normal;
        System.err.println("\t\tChord vector is (" + dArray5[0] + ", " + dArray5[1] + ")");
        System.err.println("\t\tChord normal is (" + dArray6[0] + ", " + dArray6[1] + ")");
    }

    private static void testChordIntersection() {
        double d = 3.0;
        double d2 = 2.0;
        double[] dArray = new double[]{d, d2 + 0.75};
        double[] dArray2 = new double[]{d, d2 - 0.4};
        double[] dArray3 = new double[]{d - 0.97, d2};
        double[] dArray4 = new double[]{d + 0.5, d2};
        SquashyCylinder squashyCylinder = new SquashyCylinder(new double[]{0.0, 0.0, 0.0}, 1.0, 0.0);
        AnglePair anglePair = squashyCylinder.testGetAnglePair(dArray, dArray2);
        AnglePair anglePair2 = squashyCylinder.testGetAnglePair(dArray3, dArray4);
        Chord chord = squashyCylinder.getChord(anglePair);
        Chord chord2 = squashyCylinder.getChord(anglePair2);
        double[] dArray5 = chord2.getIntersectionParams(dArray[0], dArray[1], dArray2[0], dArray2[1]);
        double[] dArray6 = chord.getIntersectionParams(dArray3[0], dArray3[1], dArray4[0], dArray4[1]);
        System.err.println("t1= " + dArray5[0] + "   t2= " + dArray5[1]);
        System.err.println("s1= " + dArray6[0] + "   s2= " + dArray6[1]);
    }

    private static void testChordAmendment() {
        double d = 1.0;
        double d2 = 0.6;
        double d3 = 1.5;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{d3, 0.0, 0.0};
        double[] dArray3 = new double[]{d3 / 2.0, d2, 0.0};
        SquashyCylinder squashyCylinder = new SquashyCylinder(dArray, d, 0.0);
        SquashyCylinder squashyCylinder2 = new SquashyCylinder(dArray2, d2, 0.0);
        SquashyCylinder squashyCylinder3 = new SquashyCylinder(dArray3, d2, 0.0);
        squashyCylinder.addIntersectionWith(squashyCylinder2);
        AnglePair anglePair = squashyCylinder.apsForCylinders.get(squashyCylinder2);
        AnglePair anglePair2 = squashyCylinder.getIntersesctionPair(squashyCylinder2);
        System.err.println("intAnglepair12= " + anglePair.lower + ", " + anglePair.upper);
        System.err.println("anglepair12   = " + anglePair2.lower + ", " + anglePair2.upper);
        Chord chord = squashyCylinder.chordsForAp.get(anglePair);
        System.err.println("chord between 1 & 2 without 3 is");
        System.err.println("chord12 vec    = (" + chord.cordVec[0] + ", " + chord.cordVec[1] + ")");
        System.err.println("chord12 normal = (" + chord.normal[0] + ", " + chord.normal[1] + ")");
        System.err.println("chord12 limits: tmin= " + chord.tmin + " tmax= " + chord.tmax);
        squashyCylinder.addIntersectionWith(squashyCylinder3);
        AnglePair anglePair3 = squashyCylinder.apsForCylinders.get(squashyCylinder3);
        AnglePair anglePair4 = squashyCylinder.getIntersesctionPair(squashyCylinder3);
        System.err.println("intAnglepair13= " + anglePair3.lower + ", " + anglePair3.upper);
        System.err.println("anglepair13   = " + anglePair4.lower + ", " + anglePair4.upper);
        Chord chord2 = squashyCylinder.chordsForAp.get(anglePair3);
        System.err.println("chords after 3rd cylinder added are:");
        System.err.println("chord13 vec    = (" + chord2.cordVec[0] + ", " + chord2.cordVec[1] + ")");
        System.err.println("chord13 normal = (" + chord2.normal[0] + ", " + chord2.normal[1] + ")");
        System.err.println("chord13 limits: tmin= " + chord2.tmin + " tmax= " + chord2.tmax);
        System.err.println();
        System.err.println("chord12 vec    = (" + chord.cordVec[0] + ", " + chord.cordVec[1] + ")");
        System.err.println("chord12 normal = (" + chord.normal[0] + ", " + chord.normal[1] + ")");
        System.err.println("chord12 limits: tmin= " + chord.tmin + " tmax= " + chord.tmax);
        squashyCylinder = new SquashyCylinder(dArray, d, 0.0);
        squashyCylinder.addIntersectionWith(squashyCylinder3);
    }

    private static void test2DIntersectionRoots() {
        double[] dArray = new double[]{1.0, 1.0, 0.0};
        double d = 2.0;
        SquashyCylinder squashyCylinder = new SquashyCylinder(dArray, d, 0.0);
        double[] dArray2 = new double[]{1.0, 2.9, 0.0};
        double[] dArray3 = new double[]{0.0, 0.2, 0.0};
        double[] dArray4 = squashyCylinder.get2dIntersectionRoots(dArray2, dArray3);
        System.err.println("roots= (" + dArray4[0] + " " + dArray4[1] + ")");
    }

    private static void testExtraCellularReflection() {
        int n = 10;
        double d = 1.0;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{2.0, 0.0, 0.0};
        double[] dArray3 = new double[]{-1.5, 0.0, 0.0};
        SquashyCylinder squashyCylinder = new SquashyCylinder(dArray, d, 0.0);
        double[] dArray4 = squashyCylinder.getIntersectionRoots(dArray2, dArray3);
        System.err.println("root[0]= " + dArray4[0]);
        System.err.println("root[1]= " + dArray4[1]);
        double[] dArray5 = new double[]{0.0, 0.0, 0.0};
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        boolean[] blArray = new boolean[]{false};
        double[] dArray8 = new double[1];
        boolean bl = squashyCylinder.crosses(dArray2, dArray3, dArray5, dArray6, false, 1.5, dArray7, blArray, dArray8);
        System.err.println("crosses = " + bl);
        System.err.println("normal = (" + dArray5[0] + ", " + dArray5[1] + ", " + dArray5[2] + ")");
        System.err.println("d = " + dArray6[0]);
        System.err.println("intDist = " + dArray7[0]);
        double d2 = 1.0;
        Object[] objectArray = new Object[]{new Double(1.0), new Double(1.0), new Integer(1), new Integer(1), new Integer(1), new Double(3.0)};
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        SimulationParams simulationParams = new SimulationParams(10, 100, 1.0, 2, 7, objectArray, 1, 1.0, schemeV0);
        Substrate substrate = SubstrateFactory.getSubstrate(7, objectArray, simulationParams);
        Walker walker = new Walker(dArray2);
        double[] dArray9 = new double[3];
        double[] dArray10 = new double[3];
        double[] dArray11 = new double[3];
        substrate.testAmendment(walker, dArray3, dArray5, dArray6, 1.5, dArray9, dArray10, dArray11);
        System.err.println("startpos= (" + dArray2[0] + ", " + dArray2[1] + ", " + dArray2[2] + ")");
        System.err.println("after amendment:");
        System.err.println("normal = (" + dArray5[0] + ", " + dArray5[1] + ", " + dArray5[2] + ")");
        System.err.println("toBarrier =(" + dArray9[0] + ", " + dArray9[1] + ", " + dArray9[2] + ")");
        System.err.println("unamended = (" + dArray11[0] + ", " + dArray11[1] + ", " + dArray11[2] + ")");
        System.err.println("amended = (" + dArray10[0] + ", " + dArray10[1] + ", " + dArray10[2] + ")");
    }

    private static final void testNonHorizUnequalIntersection() {
        double d = 1.0;
        double d2 = 0.1;
        double d3 = 1.07;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, -d3, 0.0};
        SquashyCylinder squashyCylinder = new SquashyCylinder(dArray, d, 0.0);
        SquashyCylinder squashyCylinder2 = new SquashyCylinder(dArray2, d2, 0.0);
        double d4 = squashyCylinder.getDistanceFrom(squashyCylinder2.getPosition());
        System.err.println("testing overlapping cylinders of unequal sizes separated on non-horizontal axis:");
        System.err.println("\tr1 = " + d + "    r2 = " + d2);
        System.err.println("\tdist = " + d4 + ", d=" + d3);
        AnglePair anglePair = squashyCylinder.getIntersesctionPair(squashyCylinder2);
        System.err.println("\tanglePair from squashy1 is (" + anglePair.lower + ", " + anglePair.upper + ")");
        double[] dArray3 = anglePair.getLowerCoords();
        double[] dArray4 = anglePair.getUpperCoords();
        System.err.println("\twhich is (" + dArray3[0] + ", " + dArray3[1] + ") and (" + dArray4[0] + ", " + dArray4[1] + ")");
        System.err.println("\ttesting chord construction");
        Chord chord = squashyCylinder.getChord(anglePair);
        double[] dArray5 = chord.cordVec;
        double[] dArray6 = chord.normal;
        System.err.println("\t\tChord vector is (" + dArray5[0] + ", " + dArray5[1] + ")");
        System.err.println("\t\tChord normal is (" + dArray6[0] + ", " + dArray6[1] + ")");
    }

    public static void main(String[] stringArray) {
        SquashyCylinder.testNonHorizUnequalIntersection();
    }

    protected class Chord {
        private final double[] normal;
        protected double tmin;
        protected double tmax;
        private final Vector3D P;
        private final double[] cordVec;

        protected Chord(AnglePair anglePair, double d, double d2) {
            double[] dArray = anglePair.getLowerCoords();
            double[] dArray2 = anglePair.getUpperCoords();
            double d3 = dArray[0];
            double d4 = dArray[1];
            double d5 = dArray2[0];
            double d6 = dArray2[1];
            this.cordVec = new double[]{d5 - d3, d6 - d4};
            double d7 = Math.sqrt(this.cordVec[0] * this.cordVec[0] + this.cordVec[1] * this.cordVec[1]);
            this.cordVec[0] = this.cordVec[0] / d7;
            this.cordVec[1] = this.cordVec[1] / d7;
            this.normal = new double[]{this.cordVec[1], -this.cordVec[0], 0.0};
            this.P = new Vector3D(d3, d4, 0.0);
            this.tmin = d;
            this.tmax = d2;
            if (Double.isNaN(d)) {
                System.err.println("tmin is NaN in chord " + this);
            }
            if (Double.isNaN(d2)) {
                System.err.println("tmax is NaN in chord " + this);
            }
        }

        private boolean crossedBy(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl, double d, double[] dArray5, double[] dArray6) {
            int n;
            double[] dArray7 = this.getIntersectionParams(dArray[0], dArray[1], dArray[0] + dArray2[0], dArray[1] + dArray2[1]);
            double d2 = 0.0;
            for (int i = 0; i < 2; ++i) {
                d2 += dArray2[i] * dArray2[i];
            }
            if ((d2 = Math.sqrt(d2)) / d <= 1.0E-14) {
                return false;
            }
            if (dArray7[0] > d2) {
                return false;
            }
            if (dArray7[0] < 0.0) {
                return false;
            }
            double d3 = 0.0;
            double d4 = dArray7[0] / d2;
            double[] dArray8 = new double[2];
            for (n = 0; n < 2; ++n) {
                dArray8[n] = dArray[n] + d4 * dArray2[n];
                d3 += (dArray[n] + d4 * dArray2[n] + dArray5[n]) * this.normal[n];
            }
            if (dArray7[0] < 1.0E-14 * d && bl && d3 == dArray4[0]) {
                return false;
            }
            if (dArray7[1] < this.tmin) {
                return false;
            }
            if (dArray7[1] > this.tmax) {
                return false;
            }
            for (n = 0; n < 2; ++n) {
                dArray3[n] = this.normal[n];
            }
            dArray3[2] = 0.0;
            dArray4[0] = d3;
            dArray6[0] = dArray7[0] / d2;
            return true;
        }

        protected double[] getIntersectionParams(double d, double d2, double d3, double d4) {
            double d5 = d;
            double d6 = d2;
            double d7 = d3;
            double d8 = d4;
            double d9 = this.P.x + this.tmin * this.cordVec[0];
            double d10 = this.P.y + this.tmin * this.cordVec[1];
            double d11 = this.P.x + this.tmax * this.cordVec[0];
            double d12 = this.P.y + this.tmax * this.cordVec[1];
            double d13 = SquashyCylinder.this.det(d5, d6, d7, d8);
            double d14 = d5 - d7;
            double d15 = SquashyCylinder.this.det(d9, d10, d11, d12);
            double d16 = d9 - d11;
            double d17 = SquashyCylinder.this.det(d13, d14, d15, d16);
            double d18 = SquashyCylinder.this.det(d5 - d7, d6 - d8, d9 - d11, d10 - d12);
            double d19 = d17 / d18;
            d14 = d6 - d8;
            d16 = d10 - d12;
            d17 = SquashyCylinder.this.det(d13, d14, d15, d16);
            double d20 = d17 / d18;
            double[] dArray = new double[]{d19 - d, d20 - d2};
            double d21 = dArray[0] * (d7 - d5) + dArray[1] * (d8 - d6);
            double d22 = d21 > 0.0 ? 1.0 : -1.0;
            double d23 = d22 * Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            dArray[0] = d19 - this.P.x;
            dArray[1] = d20 - this.P.y;
            double d24 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            return new double[]{d23, d24};
        }
    }

    protected class AnglePair {
        private final double lower;
        private final double upper;
        private final double[] lowerCoord;
        private final double[] upperCoord;
        private final boolean midPointInOtherCyl;

        protected AnglePair(double d, double d2, double d3, SquashyCylinder squashyCylinder2) {
            this.upper = d2;
            this.lower = d;
            this.lowerCoord = new double[]{d3 * Math.cos(d), d3 * Math.sin(d)};
            this.upperCoord = new double[]{d3 * Math.cos(d2), d3 * Math.sin(d2)};
            double d4 = (d + d2) / 2.0;
            double[] dArray = new double[]{SquashyCylinder.this.P[0] + d3 * Math.cos(d4), SquashyCylinder.this.P[1] + d3 * Math.sin(d4), 0.0};
            this.midPointInOtherCyl = squashyCylinder2.inside(dArray);
        }

        private AnglePair(double[] dArray, double[] dArray2) {
            this.lower = 0.0;
            this.upper = 1.0;
            this.lowerCoord = new double[2];
            this.upperCoord = new double[2];
            for (int i = 0; i < 2; ++i) {
                this.lowerCoord[i] = dArray[i];
                this.upperCoord[i] = dArray2[i];
            }
            this.midPointInOtherCyl = true;
        }

        protected double[] getLowerCoords() {
            return this.lowerCoord;
        }

        protected double[] getUpperCoords() {
            return this.upperCoord;
        }

        private final boolean contains(double d) {
            if (this.midPointInOtherCyl) {
                return d >= this.lower && d <= this.upper;
            }
            return !(d >= this.lower) || !(d <= this.upper);
        }
    }
}

