/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.util.logging.Logger;
import simulation.geometry.Triangle;

public class Quad {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final int D = 3;
    private final double[][] v = new double[2][3];
    private final double[] min = new double[2];
    private final double[] max = new double[2];
    private final double[] n;
    private final double[] V0 = new double[3];

    protected Quad(double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n;
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 3; ++i) {
                this.v[n][i] = dArray[n][i];
            }
            this.min[n] = dArray2[n];
            this.max[n] = dArray3[n];
        }
        for (n = 0; n < 3; ++n) {
            this.V0[n] = dArray4[n];
        }
        this.n = Triangle.normCrossProd(dArray[0], dArray[1]);
    }

    protected final boolean crossedBy(double[] dArray, double[] dArray2) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < 3; ++i) {
            d += this.n[i] * (this.V0[i] - dArray[i]);
            d2 += this.n[i] * dArray2[i];
        }
        if (Math.abs(d2) <= 1.0E-14) {
            return false;
        }
        double d3 = d / d2;
        if (d3 < 0.0) {
            return false;
        }
        if (d3 >= 1.0) {
            return false;
        }
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        for (int i = 0; i < 2; ++i) {
            double d4 = 0.0;
            double d5 = 0.0;
            for (int j = 0; j < 3; ++j) {
                d4 += dArray[j] * this.v[i][j];
                d5 += dArray2[j] * this.v[i][j];
            }
            dArray3[i] = d4;
            dArray4[i] = d5;
        }
        double[] dArray5 = new double[2];
        for (n = 0; n < 2; ++n) {
            dArray5[n] = dArray3[n] + d3 * dArray4[n];
        }
        n = 1;
        for (int i = 0; i < 2; ++i) {
            if (!(dArray5[i] < this.min[i]) && !(dArray5[i] > this.max[i])) continue;
            n = 0;
            break;
        }
        return n != 0;
    }

    private static final void testQuadIntersection() {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = new double[]{1.0, 1.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.5};
        Quad quad = new Quad(dArrayArray, dArray, dArray2, dArray3);
        double[] dArray4 = new double[]{0.5, 0.5, 0.4};
        double[] dArray5 = new double[]{0.0, 0.0, 0.2};
        boolean bl = quad.crossedBy(dArray4, dArray5);
        System.err.println("intersecting step. crosses is " + bl + " (true)");
        dArray5[2] = 0.05;
        bl = quad.crossedBy(dArray4, dArray5);
        System.err.println("non-intersecting step. crosses is " + bl + " (true)");
    }

    public static void main(String[] stringArray) {
        Quad.testQuadIntersection();
    }
}

