/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import imaging.SchemeV0;
import java.util.logging.Logger;
import misc.LoggedException;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.geometry.BasicCylinder;
import simulation.geometry.Cylinder;
import simulation.geometry.CylinderSubstrate;
import simulation.geometry.MyelinatedCylinder;
import simulation.geometry.Substrate;
import simulation.geometry.SubstrateFactory;
import tools.CL_Initializer;

public class ParallelCylinderSubstrate
extends CylinderSubstrate {
    Logger logger = Logger.getLogger(this.getClass().getName());
    private final int D = 3;
    private final double R;
    private final double[] l;
    private final double[] V;
    private final double[] subsCoords = new double[3];
    private final double[] noOffset = new double[]{0.0, 0.0, 0.0};
    public static final int SQUARE = 1;
    public static final int HEX = 2;
    public static final int DISTRIBUTED = 3;
    private static final int BASIC = 1;
    private static final int MYELINATED = 2;
    private final int packing;
    private final int cylType;

    public ParallelCylinderSubstrate(double d, double d2, int n, SimulationParams simulationParams) {
        super(new double[]{2.0 * d, 2.0 * d, 2.0 * d}, simulationParams);
        Cylinder[] cylinderArray;
        int n2;
        double d3 = simulationParams.getP();
        double[] dArray = new double[3];
        if (d < 2.0 * d2) {
            this.logger.warning("Cylinder spacing on parallel cylinder lattice (R=" + d + ") is less than cylinder radius (r=" + d2 + ")");
        }
        this.V = new double[3];
        for (n2 = 0; n2 < 3; ++n2) {
            dArray[n2] = d / 2.0;
            this.V[n2] = 0.0;
        }
        this.V[2] = 1.0;
        this.R = d;
        this.packing = n;
        this.cylType = 1;
        if (n == 1) {
            double d4 = Math.PI * d2 * d2;
            double d5 = d * d;
            double d6 = d4 / d5;
            this.logger.info("Constructing square-packed parallel cylinder substrate. radius= " + d2 + " separation= " + d);
            this.logger.info("intracellular vol frac = " + d6);
            cylinderArray = new Cylinder[9];
            for (int i = 0; i < 3; ++i) {
                dArray[0] = (double)i * d;
                for (int j = 0; j < 3; ++j) {
                    dArray[1] = (double)j * d;
                    cylinderArray[3 * i + j] = new BasicCylinder(dArray, d2, d3);
                }
            }
            this.l = new double[]{2.0 * d, 2.0 * d, 2.0 * d};
        } else if (n == 2) {
            n2 = 0;
            cylinderArray = new Cylinder[8];
            this.l = new double[3];
            double d7 = Math.sqrt(0.75);
            this.l[0] = 2.0 * d;
            this.l[1] = 2.0 * d7 * d;
            this.l[2] = 2.0 * d;
            super.setSubstrateDims(this.l);
            double d8 = Math.PI * 2 * d2 * d2 / (d7 * d * d);
            this.logger.info("constructing hexagonally packed cylinder substrate, radius= " + d2 + " separation= " + d);
            this.logger.info("intracellular vol frac = " + d8);
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            cylinderArray[n2++] = new BasicCylinder(dArray, d2, d3);
            dArray[0] = d;
            cylinderArray[n2++] = new BasicCylinder(dArray, d2, d3);
            dArray[0] = 2.0 * d;
            cylinderArray[n2++] = new BasicCylinder(dArray, d2, d3);
            dArray[0] = d / 2.0;
            dArray[1] = d7 * d;
            cylinderArray[n2++] = new BasicCylinder(dArray, d2, d3);
            dArray[0] = 3.0 * d / 2.0;
            cylinderArray[n2++] = new BasicCylinder(dArray, d2, d3);
            dArray[0] = 0.0;
            dArray[1] = 2.0 * d7 * d;
            cylinderArray[n2++] = new BasicCylinder(dArray, d2, d3);
            dArray[0] = d;
            cylinderArray[n2++] = new BasicCylinder(dArray, d2, d3);
            dArray[0] = 2.0 * d;
            cylinderArray[n2++] = new BasicCylinder(dArray, d2, d3);
        } else {
            Object var9_12 = null;
            throw new LoggedException("packing label = " + n + " not understood, please use square (" + 1 + ") or hexagonal (" + 2 + ")");
        }
        this.setCylinders(cylinderArray);
    }

    public ParallelCylinderSubstrate(double d, double d2, double d3, double d4, double d5, double d6, int n, SimulationParams simulationParams) {
        super(new double[]{4.0 * d, 4.0 * d, 4.0 * d}, simulationParams);
        Cylinder[] cylinderArray;
        int n2;
        double[] dArray = new double[3];
        if (d < 2.0 * d3) {
            this.logger.warning("Cylinder spacing on parallel cylinder lattice (R=" + d + ") is less than cylinder radius (r=" + d3 + ")");
        }
        this.V = new double[3];
        for (n2 = 0; n2 < 3; ++n2) {
            dArray[n2] = d / 2.0;
            this.V[n2] = 0.0;
        }
        this.V[2] = 1.0;
        this.R = d;
        this.packing = n;
        this.cylType = 2;
        if (n == 1) {
            double d7 = Math.PI * d3 * d3;
            double d8 = d * d;
            double d9 = d7 / d8;
            this.logger.info("Constructing square-packed parallel myelinated cylinder substrate. radius= " + d3 + " separation= " + d);
            this.logger.info("intracellular vol frac = " + d9);
            cylinderArray = new Cylinder[9];
            for (int i = 0; i < 3; ++i) {
                dArray[0] = (double)i * d;
                for (int j = 0; j < 3; ++j) {
                    dArray[1] = (double)j * d;
                    cylinderArray[3 * i + j] = new MyelinatedCylinder(dArray, d2, d3, d4, d5, d6);
                }
            }
            this.l = new double[]{d, d, d};
        } else if (n == 2) {
            n2 = 0;
            cylinderArray = new Cylinder[8];
            double d10 = Math.sqrt(0.75) * d;
            this.l = new double[3];
            this.l[0] = 2.0 * d;
            this.l[1] = 2.0 * d10;
            this.l[2] = 2.0 * d;
            super.setSubstrateDims(this.l);
            double d11 = Math.PI * 2 * d3 * d3 / (this.l[1] * d);
            this.logger.info("constructing hexagonally packed myelinated cylinder substrate, radius= " + d3 + " separation= " + d);
            this.logger.info("intracellular vol frac = " + d11);
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            cylinderArray[n2++] = new MyelinatedCylinder(dArray, d2, d3, d4, d5, d6);
            dArray[0] = d;
            cylinderArray[n2++] = new MyelinatedCylinder(dArray, d2, d3, d4, d5, d6);
            dArray[0] = 2.0 * d;
            cylinderArray[n2++] = new MyelinatedCylinder(dArray, d2, d3, d4, d5, d6);
            dArray[0] = d / 2.0;
            dArray[1] = d10;
            cylinderArray[n2++] = new MyelinatedCylinder(dArray, d2, d3, d4, d5, d6);
            dArray[0] = 3.0 * d / 2.0;
            cylinderArray[n2++] = new MyelinatedCylinder(dArray, d2, d3, d4, d5, d6);
            dArray[0] = 0.0;
            dArray[1] = 2.0 * d10;
            cylinderArray[n2++] = new MyelinatedCylinder(dArray, d2, d3, d4, d5, d6);
            dArray[0] = d;
            cylinderArray[n2++] = new MyelinatedCylinder(dArray, d2, d3, d4, d5, d6);
            dArray[0] = 2.0 * d;
            cylinderArray[n2++] = new MyelinatedCylinder(dArray, d2, d3, d4, d5, d6);
        } else {
            Object var15_15 = null;
            throw new LoggedException("packing label = " + n + " not understood, please use square (" + 1 + ") or hexagonal (" + 2 + ")");
        }
        this.setCylinders(cylinderArray);
    }

    @Override
    public double[] getSubstrateSize() {
        return this.l;
    }

    @Override
    public double getPeakCoord() {
        return this.l[0] / 2.0;
    }

    @Override
    public final double getDiffusivityAt(double[] dArray) {
        double[] dArray2 = new double[3];
        this.getSubstrateCoords(dArray, this.noOffset, dArray2);
        for (int i = 0; i < this.cylinder.length; ++i) {
            if (!this.cylinder[i].inside(dArray2)) continue;
            return this.cylinder[i].getDiffusivityAt(dArray2);
        }
        return CL_Initializer.DIFF_CONST;
    }

    public double getCylinderSpacing() {
        return this.R;
    }

    public int getPacking() {
        return this.packing;
    }

    public String getPackingString() {
        if (this.packing == 1) {
            return new String("square");
        }
        if (this.packing == 2) {
            return new String("hex");
        }
        return new String("unknown! code =" + this.packing);
    }

    @Override
    public void getSubstrateCoords(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < 3; ++i) {
            double d = dArray[i] + dArray2[i];
            double d2 = Math.floor(d / this.l[i]);
            dArray3[i] = d - d2 * this.l[i];
        }
    }

    public static void main(String[] stringArray) {
        int n = 3;
        int n2 = 10;
        double[] dArray = new double[]{1.4, 1.0, 0.0};
        Walker walker = new Walker(dArray);
        double[] dArray2 = new double[]{0.2, 0.0, 0.0};
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[1];
        Object[] objectArray = new Object[]{new Double(2.0), new Double(0.5), new Integer(1)};
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        SimulationParams simulationParams = new SimulationParams(1, 1000, 1.0, 1, 5, objectArray, 1, 1.0, schemeV0);
        System.err.println("testing geometry directly");
        ParallelCylinderSubstrate parallelCylinderSubstrate = new ParallelCylinderSubstrate(2.0, 0.5, 1, simulationParams);
        System.err.println("substrate type is " + parallelCylinderSubstrate.getPackingString());
        System.err.println("cylinder spacing is " + parallelCylinderSubstrate.getCylinderSpacing());
        boolean[] blArray = new boolean[1];
        double[] dArray5 = new double[]{0.0, 0.0, 0.0};
        double[] dArray6 = new double[1];
        boolean bl = parallelCylinderSubstrate.crossesMembrane(walker, dArray5, dArray2, dArray3, dArray4, false, 0.2, blArray, dArray6);
        System.err.println("crosses is " + bl + " normal=(" + dArray3[0] + "," + dArray3[1] + "," + dArray3[2] + ") d=" + dArray4[0]);
        System.err.println("\ntesting geometry in substrate framework");
        Substrate substrate = SubstrateFactory.getSubstrate(7, objectArray, simulationParams);
        substrate.crossesMembrane(walker, dArray5, dArray2, dArray3, dArray4, false, 0.2, blArray, dArray6);
        System.err.println("crosses is " + bl + " normal=(" + dArray3[0] + "," + dArray3[1] + "," + dArray3[2] + ") d=" + dArray4[0]);
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double[] dArray9 = new double[n];
        substrate.testAmendment(walker, dArray2, dArray3, dArray4, 0.2, dArray7, dArray8, dArray9);
        System.err.println("toBarrier= (" + dArray7[0] + "," + dArray7[1] + "," + dArray7[2] + ")");
        System.err.println("reflected= (" + dArray8[0] + "," + dArray8[1] + "," + dArray8[2] + ")");
        System.err.println("unreflected= (" + dArray9[0] + "," + dArray9[1] + "," + dArray9[2] + ")");
    }
}

