/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import imaging.Scheme;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.geometry.PLYreader;
import simulation.geometry.Substrate;
import simulation.geometry.Triangle;

public class MeshSubstrate
extends Substrate {
    private static final int D = 3;
    private final Collection<Triangle> triangles;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private int skipping = -1;
    private final double[] sep;
    private final double size;
    private final double[] ray;
    private final HashMap<Triangle, ArrayList<Triangle>> coplanarMap;

    public MeshSubstrate(String string, double d, double d2, SimulationParams simulationParams) {
        super(simulationParams, new double[]{d2, d2, d2});
        BufferedWriter bufferedWriter;
        int n;
        double[] dArray;
        int n2;
        if (d2 < d) {
            this.logger.warning("size of PLY mesh object " + d + " is smaller that specifed separation " + d2);
        }
        this.sep = new double[]{d2, d2, d2};
        this.size = d;
        this.ray = new double[]{0.0, 0.0, Double.MAX_VALUE};
        this.logger.info("reading object mesh from '" + string + "'");
        this.triangles = PLYreader.readPLYfile(string, 1.0, simulationParams.getP());
        Iterator<Triangle> iterator = this.triangles.iterator();
        double d3 = 0.0;
        while (iterator.hasNext()) {
            Triangle object2 = iterator.next();
            for (n2 = 0; n2 < 3; ++n2) {
                double iOException = 0.0;
                dArray = object2.getVertex(n2);
                for (n = 0; n < 3; ++n) {
                    iOException += dArray[n] * dArray[n];
                }
                if (!(iOException > d3)) continue;
                d3 = iOException;
            }
        }
        d3 = Math.sqrt(d3);
        for (Triangle triangle : this.triangles) {
            for (n2 = 0; n2 < 3; ++n2) {
                double[] iOException = triangle.getVertex(n2);
                double d4 = d / d3;
                n = 0;
                while (n < 3) {
                    int n3 = n;
                    iOException[n3] = iOException[n3] * d4;
                    int n4 = n++;
                    iOException[n4] = iOException[n4] + d2 / 2.0;
                }
            }
            triangle.initVectors();
        }
        this.coplanarMap = PLYreader.getCoplanarListMap();
        Iterator<Triangle> iterator2 = this.triangles.iterator();
        try {
            bufferedWriter = new BufferedWriter(new FileWriter("tris.csv"));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        while (iterator2.hasNext()) {
            Triangle triangle = iterator2.next();
            try {
                for (int i = 0; i < 3; ++i) {
                    dArray = triangle.getVertex(i);
                    bufferedWriter.write(dArray[0] + "," + dArray[1] + "," + dArray[2] + "\n");
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        try {
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private double[] getSubstrateCoords(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            double d = Math.floor((dArray[i] + dArray2[i]) / this.sep[i]);
            dArray3[i] = dArray[i] + dArray2[i] - d * this.sep[i];
        }
        return dArray3;
    }

    @Override
    public boolean crossesMembrane(Walker walker, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl, double d, boolean[] blArray, double[] dArray5) {
        double d2 = 2.0;
        boolean bl2 = false;
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[1];
        double[] dArray8 = new double[1];
        Iterator<Triangle> iterator = this.triangles.iterator();
        int n = 0;
        double[] dArray9 = this.getSubstrateCoords(walker.r, dArray);
        while (iterator.hasNext()) {
            Triangle triangle = iterator.next();
            if (bl && n == this.skipping) {
                ++n;
                continue;
            }
            if (triangle.crosses(dArray9, dArray2, dArray6, dArray7, false, d, dArray8, null, dArray5)) {
                bl2 = true;
                if (dArray8[0] < d2) {
                    d2 = dArray8[0];
                    for (int i = 0; i < 3; ++i) {
                        dArray3[i] = dArray6[i];
                    }
                    dArray4[0] = dArray7[0];
                    this.skipping = n;
                }
                dArray5[0] = triangle.getPermeability(0);
            }
            ++n;
        }
        if (!bl2) {
            this.skipping = -1;
        }
        return bl2;
    }

    @Override
    public double getPeakCoord() {
        return this.sep[0] / 2.0;
    }

    @Override
    public double[] getSubstrateSize() {
        return this.sep;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean intracellular(Walker walker) {
        ArrayList<Triangle> arrayList = new ArrayList<Triangle>();
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = this.getSubstrateCoords(walker.r, dArray);
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        int n = 0;
        for (Triangle triangle : this.triangles) {
            if (arrayList.contains(triangle) || !triangle.crosses(dArray2, this.ray, dArray3, dArray4, false, 2.0 * this.size, dArray5, null, dArray6)) continue;
            ArrayList<Triangle> arrayList2 = this.coplanarMap.get(triangle);
            if (arrayList2 != null) {
                arrayList.addAll(arrayList2);
            }
            ++n;
        }
        return n % 2 == 1;
    }

    public static void main(String[] stringArray) {
        int n = 100;
        Scheme scheme = null;
        Object[] objectArray = null;
        SimulationParams simulationParams = new SimulationParams(1, 1000, 0.0, 1, 0, objectArray, 1, 1.5, scheme);
        MeshSubstrate meshSubstrate = new MeshSubstrate("cube.ply", 1.0, 2.0, simulationParams);
        Collection<Triangle> collection = meshSubstrate.triangles;
        System.err.println("read " + collection.size() + " triangles");
        int n2 = 0;
        for (Triangle triangle : collection) {
            System.err.println(++n2 + " " + triangle);
        }
        double d = meshSubstrate.getPeakCoord();
        double[] dArray = new double[]{d, d, d};
        Walker walker = new Walker(dArray);
        System.err.println("midpoint is " + d);
        System.err.println("intracellular(midpoint) is " + meshSubstrate.intracellular(walker));
        double d2 = meshSubstrate.size;
        System.err.println("mesh size is " + d2);
        dArray[0] = dArray[0] + 1.1 * d2;
        walker = new Walker(dArray);
        System.err.println("extra cellular point is (" + dArray[0] + "," + dArray[1] + "," + dArray[2] + ")");
        System.err.println("intracellular is " + meshSubstrate.intracellular(walker));
    }
}

