/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.util.logging.Logger;
import numerics.RealMatrix;
import numerics.Rotations;
import numerics.Vector3D;
import simulation.SimulationParams;
import simulation.geometry.BasicCylinder;
import simulation.geometry.Cylinder;
import simulation.geometry.CylinderSubstrate;

public class CrossingCylinderSubstrate
extends CylinderSubstrate {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final double D = 3.0;
    private final double cAngle;
    private final double R;

    public CrossingCylinderSubstrate(double d, double d2, SimulationParams simulationParams) {
        super(new double[]{2.0 * d, 2.0 * d, 2.0 * d}, simulationParams);
        if (d < 2.0 * d2) {
            this.logger.warning("Cylinder separation on crossing cylinder substrate is less than twice the radius.");
            this.logger.warning("overlapping cylinders on this substrate will behave unpredictably");
        }
        Cylinder[] cylinderArray = new BasicCylinder[11];
        double d3 = simulationParams.getP();
        this.cAngle = SimulationParams.sim_cAngle;
        RealMatrix realMatrix = Rotations.getRotMat(new double[]{0.0, 1.0, 0.0}, this.cAngle);
        Vector3D vector3D = new Vector3D(0.0, 0.0, 1.0);
        Vector3D vector3D2 = Rotations.rotateVector(vector3D, realMatrix);
        double[] dArray = new double[]{vector3D2.x, vector3D2.y, vector3D2.z};
        this.R = d;
        cylinderArray[0] = new BasicCylinder(new double[]{0.0, 0.0, 0.0}, d2, d3);
        cylinderArray[1] = new BasicCylinder(new double[]{d, 0.0, 0.0}, d2, d3);
        cylinderArray[2] = new BasicCylinder(new double[]{2.0 * d, 0.0, 0.0}, d2, d3);
        cylinderArray[3] = new BasicCylinder(new double[]{0.0, d, 0.0}, dArray, d2, d3);
        cylinderArray[4] = new BasicCylinder(new double[]{0.0, d, d}, dArray, d2, d3);
        cylinderArray[5] = new BasicCylinder(new double[]{0.0, d, 2.0 * d}, dArray, d2, d3);
        cylinderArray[6] = new BasicCylinder(new double[]{0.0, 2.0 * d, 0.0}, d2, d3);
        cylinderArray[7] = new BasicCylinder(new double[]{d, 2.0 * d, 0.0}, d2, d3);
        cylinderArray[8] = new BasicCylinder(new double[]{2.0 * d, 2.0 * d, 0.0}, d2, d3);
        cylinderArray[9] = new BasicCylinder(new double[]{0.0, d, -d}, dArray, d2, d3);
        cylinderArray[10] = new BasicCylinder(new double[]{0.0, d, 3.0 * d}, dArray, d2, d3);
        super.setCylinders(cylinderArray);
    }

    @Override
    public double getPeakCoord() {
        return this.R;
    }

    @Override
    public double[] getSubstrateSize() {
        return new double[]{2.0 * this.R, 2.0 * this.R, 2.0 * this.R};
    }
}

