/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.io.IOException;
import java.io.Writer;
import numerics.Point3D;
import numerics.RealMatrix;
import numerics.Rotations;
import numerics.Vector3D;
import simulation.geometry.BoundingBox;
import simulation.geometry.Cylinder;
import tools.CL_Initializer;

public class BasicCylinder
implements Cylinder {
    private static final double TINYNUM = 5.0E-14;
    public final Point3D P;
    private final Point3D Prot;
    public final double[] Parr;
    private final Vector3D V;
    private final double r;
    private final RealMatrix rotMat;
    private final RealMatrix invRotMat;
    private final double p;
    private final double d = CL_Initializer.DIFF_CONST;
    private final int D = 3;
    private double[] initialPos = new double[3];
    private boolean initiallyIn;
    private int N = 20;
    private final BoundingBox bbox;

    public BasicCylinder(double[] dArray, double d, double d2) {
        this.P = new Point3D(dArray);
        this.Parr = new double[3];
        for (int i = 0; i < 3; ++i) {
            this.Parr[i] = dArray[i];
        }
        this.Prot = this.P;
        this.r = d;
        this.p = d2;
        double[] dArray2 = new double[]{0.0, 0.0, 1.0};
        this.V = new Vector3D(dArray2);
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        double[] dArray3 = new double[]{dArray[0] - d, dArray[1] - d, 0.0};
        double[] dArray4 = new double[]{dArray[0] + d, dArray[1] + d, Double.MAX_VALUE};
        this.bbox = new BoundingBox(dArrayArray, dArray3, dArray4);
        this.rotMat = null;
        this.invRotMat = null;
    }

    protected BasicCylinder(double[] dArray, double[] dArray2, double d, double d2) {
        int n;
        this.P = new Point3D(dArray);
        this.Parr = new double[3];
        for (int i = 0; i < dArray.length; ++i) {
            this.Parr[i] = dArray[i];
        }
        this.r = d;
        this.p = d2;
        double d3 = 0.0;
        for (n = 0; n < 3; ++n) {
            d3 += dArray2[n] * dArray2[n];
        }
        d3 = Math.sqrt(d3);
        for (n = 0; n < 3; ++n) {
            dArray2[n] = dArray2[n] / d3;
        }
        this.V = new Vector3D(dArray2);
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
        double[] dArray3 = new double[]{dArray[0] - d, dArray[1] - d};
        double[] dArray4 = new double[]{dArray[0] + d, dArray[1] + d};
        this.bbox = null;
        double d4 = Math.acos(dArray2[2]);
        Vector3D vector3D = new Vector3D(0.0, 0.0, 1.0);
        Vector3D vector3D2 = this.V.cross(vector3D);
        this.rotMat = Rotations.getRotMat(vector3D2, -d4);
        this.invRotMat = Rotations.getRotMat(vector3D2, d4);
        this.Prot = new Point3D(Rotations.transformPoint(this.rotMat, this.Parr));
    }

    @Override
    public boolean crosses(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl, double d, double[] dArray5, boolean[] blArray, double[] dArray6) {
        int n;
        double d2;
        double[] dArray7;
        double[] dArray8 = dArray7 = this.getPosition();
        double d3 = this.getRadius();
        double[] dArray9 = dArray;
        double[] dArray10 = dArray2;
        if (this.rotMat != null) {
            dArray9 = Rotations.transformPoint(this.rotMat, dArray);
            dArray10 = Rotations.transformPoint(this.rotMat, dArray10);
            dArray7 = Rotations.transformPoint(this.rotMat, dArray7);
        }
        double[] dArray11 = new double[]{dArray9[0] - dArray7[0], dArray9[1] - dArray7[1], 0.0};
        double[] dArray12 = new double[]{dArray9[0] - dArray7[0] + dArray10[0], dArray9[1] - dArray7[1] + dArray10[1], 0.0};
        double[] dArray13 = new double[]{dArray[0] - dArray8[0], dArray[1] - dArray8[1], dArray[2] - dArray8[2]};
        double[] dArray14 = new double[]{dArray[0] - dArray8[0] + dArray2[0], dArray[1] - dArray8[1] + dArray2[1], dArray[2] - dArray8[2] + dArray2[2]};
        double[] dArray15 = new double[3];
        double d4 = Math.sqrt(dArray11[0] * dArray11[0] + dArray11[1] * dArray11[1]);
        double d5 = Math.sqrt(dArray12[0] * dArray12[0] + dArray12[1] * dArray12[1]);
        double d6 = Math.sqrt(dArray13[0] * dArray13[0] + dArray13[1] * dArray13[1] + dArray13[2] * dArray13[2]);
        double d7 = Math.sqrt(dArray14[0] * dArray14[0] + dArray14[1] * dArray14[1] + dArray14[2] * dArray14[2]);
        if (!bl) {
            blArray[0] = this.initiallyIn = this.inside(dArray);
        }
        if (d4 <= d3 && d5 <= d3) {
            return false;
        }
        double[] dArray16 = this.getIntersectionRoots(dArray9, dArray10);
        if (dArray16 == null) {
            return false;
        }
        if (dArray16[0] < 0.0 && dArray16[1] < 0.0) {
            return false;
        }
        if ((!(dArray16[0] >= 0.0) || !(dArray16[0] <= 1.0)) && dArray16[1] >= 0.0 && dArray16[1] <= 1.0) {
            d2 = dArray16[0];
            dArray16[0] = dArray16[1];
            dArray16[1] = d2;
        }
        if (dArray16[0] >= 0.0 && dArray16[0] <= 1.0 && dArray16[1] >= 0.0 && dArray16[1] <= 1.0 && dArray16[0] > dArray16[1]) {
            d2 = dArray16[0];
            dArray16[0] = dArray16[1];
            dArray16[1] = d2;
        }
        d2 = 0.0;
        for (n = 0; n < 2; ++n) {
            d2 += dArray10[n] * dArray10[n];
        }
        d2 = Math.sqrt(d2);
        for (n = 0; n < 3; ++n) {
            dArray15[n] = dArray[n] + dArray2[n];
        }
        for (n = 0; n < dArray16.length; ++n) {
            int n2;
            int n3;
            if (!(dArray16[n] > 0.0) || !(dArray16[n] <= 1.0)) continue;
            double[] dArray17 = new double[]{dArray9[0] + dArray16[n] * dArray10[0] - dArray7[0], dArray9[1] + dArray16[n] * dArray10[1] - dArray7[1], dArray9[2] + dArray16[n] * dArray10[2] - dArray7[2]};
            double d8 = Math.atan2(dArray17[1], dArray17[0]);
            double[] dArray18 = new double[dArray3.length];
            dArray18[0] = Math.cos(d8);
            dArray18[1] = Math.sin(d8);
            dArray18[2] = 0.0;
            double d9 = 0.0;
            for (n3 = 0; n3 < 2; ++n3) {
                d9 += (dArray17[n3] + dArray7[n3]) * dArray18[n3];
            }
            if (bl && (n3 = (int)(this.checkSkipping(dArray15) ? 1 : 0)) != 0) continue;
            dArray4[0] = d9;
            dArray5[0] = 0.0;
            if (this.invRotMat != null) {
                double[] dArray19 = Rotations.transformPoint(this.invRotMat, dArray18);
                dArray18 = dArray19;
            }
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                dArray3[n2] = dArray18[n2];
            }
            dArray5[0] = dArray16[n];
            if (!bl) {
                for (n2 = 0; n2 < 3; ++n2) {
                    this.initialPos[n2] = dArray11[n2];
                }
                this.initiallyIn = this.inside(dArray);
            }
            dArray6[0] = this.p;
            return true;
        }
        return false;
    }

    private final boolean checkSkipping(double[] dArray) {
        return this.initiallyIn == this.inside(dArray);
    }

    @Override
    public double getDistanceFrom(double[] dArray) {
        Vector3D vector3D = new Vector3D(new Point3D(dArray), this.P);
        double d = vector3D.modSquared();
        double d2 = vector3D.dot(this.V);
        double d3 = Math.sqrt(d - d2 * d2);
        return d3;
    }

    @Override
    public boolean inside(double[] dArray) {
        double d = this.getDistanceFrom(dArray);
        return d <= this.r;
    }

    protected double[] getIntersectionRoots(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[]{this.Prot.x, this.Prot.y, this.Prot.z};
        for (int i = 0; i < 3; ++i) {
            dArray4[i] = dArray[i] - dArray5[i];
        }
        double d = 2.0 * (dArray4[0] * dArray2[0] + dArray4[1] * dArray2[1]);
        double d2 = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
        double d3 = dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] - this.r * this.r;
        if (d * d < 4.0 * d2 * d3) {
            return null;
        }
        dArray3[0] = (-d + Math.sqrt(d * d - 4.0 * d2 * d3)) / (2.0 * d2);
        dArray3[1] = (-d - Math.sqrt(d * d - 4.0 * d2 * d3)) / (2.0 * d2);
        for (int i = 0; i < 2; ++i) {
            if (!(Math.abs(dArray3[i]) < 5.0E-14)) continue;
            dArray3[i] = 0.0;
        }
        return dArray3;
    }

    protected void getIntersectionNormal(double[] dArray, double d, double[] dArray2, double[] dArray3) {
        int n;
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[]{this.P.x, this.P.y, this.P.z};
        Vector3D vector3D = new Vector3D(dArray2);
        vector3D = Rotations.rotateVector(vector3D, this.rotMat);
        for (n = 0; n < 3; ++n) {
            dArray4[n] = dArray[n] - dArray5[n] + d * dArray2[n];
        }
        for (n = 0; n < 2; ++n) {
            dArray3[n] = dArray4[n] / this.r;
        }
        dArray3[2] = 0.0;
    }

    @Override
    public double getDiffusivityAt(double[] dArray) {
        if (this.inside(dArray)) {
            return this.d;
        }
        return CL_Initializer.DIFF_CONST;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    @Override
    public boolean boundingBoxIntersects(double[] dArray, double[] dArray2) {
        return this.bbox.intersectedBy(dArray, dArray2);
    }

    @Override
    public final boolean intersectsCubicRegion(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = (dArray[i] + dArray2[i]) / 2.0;
        }
        double[][] dArrayArray = new double[][]{{dArray[0], dArray[1], dArray[2]}, {dArray[0], dArray[1], dArray2[2]}, {dArray[0], dArray2[1], dArray[2]}, {dArray[0], dArray2[1], dArray2[2]}, {dArray2[0], dArray[1], dArray[2]}, {dArray2[0], dArray[1], dArray2[2]}, {dArray2[0], dArray2[1], dArray[2]}, {dArray2[0], dArray2[1], dArray2[2]}};
        double d = this.getDistanceFrom(dArray3);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < dArrayArray.length; ++i) {
            double d2 = this.getDistanceFrom(dArrayArray[i]);
            if (d <= d2) {
                bl = true;
            }
            if (d2 > this.r) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return true;
        }
        return false;
    }

    @Override
    public double[] getPosition() {
        return this.Parr;
    }

    public double[] getAxis() {
        return new double[]{this.V.x, this.V.y, this.V.z};
    }

    @Override
    public double getRadius() {
        return this.r;
    }

    @Override
    public void toFile(Writer writer) throws IOException {
        for (int i = 0; i <= this.N; ++i) {
            double d = Math.PI * 2 * (double)i / (double)this.N;
            double d2 = this.P.x + this.r * Math.cos(d);
            double d3 = this.P.y + this.r * Math.sin(d);
            writer.write(d2 + "," + d3 + "\n");
        }
    }

    private static void testArbOrientation() {
        double[] dArray = new double[]{0.0, 4.0E-6, 0.0};
        double[] dArray2 = new double[]{1.0, 0.0, 0.0};
        double d = 1.9E-6;
        double d2 = 0.0;
        BasicCylinder basicCylinder = new BasicCylinder(dArray, dArray2, d, d2);
        double[] dArray3 = new double[]{5.579550874118729E-6, 4.932731024543929E-6, 1.6552955529658E-6};
        double[] dArray4 = new double[]{-2.312586608428411E-7, -7.941170655425175E-7, 3.7819754468400464E-7};
        double[] dArray5 = new double[dArray3.length];
        for (int i = 0; i < dArray5.length; ++i) {
            dArray5[i] = dArray3[i] + dArray4[i];
        }
        System.err.println("start point inside is " + basicCylinder.inside(dArray3));
        System.err.println("end point inside is " + basicCylinder.inside(dArray5));
        double[] dArray6 = new double[dArray3.length];
        double[] dArray7 = new double[1];
        double[] dArray8 = new double[1];
        double[] dArray9 = new double[1];
        boolean[] blArray = new boolean[1];
        boolean bl = basicCylinder.crosses(dArray3, dArray4, dArray6, dArray7, false, 0.5, dArray9, blArray, dArray8);
        bl = basicCylinder.crosses(dArray3, dArray4, dArray6, dArray7, true, 0.5, dArray9, blArray, dArray8);
        System.err.println("crosses is " + bl + " (expected true)");
        System.err.println("ind dist is " + dArray9[0] + " (expected 0.1)");
        System.err.println("normal is (" + dArray6[0] + "," + dArray6[1] + "," + dArray6[2] + ") (expected (0.0,0.0,1.0)");
    }

    public static void main(String[] stringArray) {
        BasicCylinder.testArbOrientation();
    }
}

