/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import numerics.NumDeriv;
import optimizers.ConjGradMinimizerException;

public abstract class ConjGradMinimizer {
    protected int n;
    protected int iter;
    protected double fret;
    private final int ITMAX = 500;
    private final double EPS = 1.0E-10;
    private final double TOL = 2.0E-4;
    private final double GOLD = 1.618034;
    private final double GLIMIT = 100.0;
    private final double TINY = 1.0E-20;
    private final int BRENTITMAX = 100;
    private final double CGOLD = 0.381966;
    private final double ZEPS = 1.0E-10;
    private double ax;
    private double bx;
    private double cx;
    private double xmin;
    private double fa;
    private double fb;
    private double fc;

    protected abstract double fObj(double[] var1);

    protected double[] dfObj(double[] dArray) {
        return this.dfObjNumerical(dArray);
    }

    protected double[] dfObjNumerical(double[] dArray) {
        int n;
        double[] dArray2 = new double[this.n + 1];
        final double[] dArray3 = new double[dArray.length];
        for (n = 1; n < dArray.length; ++n) {
            dArray3[n] = dArray[n];
        }
        for (n = 1; n <= this.n; ++n) {
            final int n2 = n;
            NumDeriv numDeriv = new NumDeriv(){

                @Override
                protected float func(float f) {
                    dArray3[n2] = f;
                    float f2 = (float)ConjGradMinimizer.this.fObj(dArray3);
                    return f2;
                }
            };
            float[] fArray = new float[1];
            float f = dArray[n] != 0.0 ? 0.1f * (float)dArray[n] : 0.001f;
            dArray2[n] = numDeriv.dfridr((float)dArray[n], f, fArray);
            dArray3[n2] = dArray[n2];
        }
        return dArray2;
    }

    public void minimise(double[] dArray, double d) throws ConjGradMinimizerException {
        this.iter = 0;
        this.frprmn(dArray, d);
    }

    protected void init(int n) {
        this.n = n;
    }

    protected void frprmn(double[] dArray, double d) throws ConjGradMinimizerException {
        int n;
        double[] dArray2 = new double[this.n + 1];
        double[] dArray3 = new double[this.n + 1];
        double d2 = this.fObj(dArray);
        double[] dArray4 = this.dfObj(dArray);
        for (n = 1; n <= this.n; ++n) {
            dArray2[n] = -dArray4[n];
            dArray4[n] = dArray3[n] = dArray2[n];
        }
        for (n = 1; n <= 500; ++n) {
            this.iter = n;
            this.linmin(dArray, dArray4);
            if (2.0 * Math.abs(this.fret - d2) <= d * (Math.abs(this.fret) + Math.abs(d2) + 1.0E-10)) {
                return;
            }
            d2 = this.fObj(dArray);
            dArray4 = this.dfObj(dArray);
            double d3 = 0.0;
            double d4 = 0.0;
            for (int i = 1; i <= this.n; ++i) {
                d4 += dArray2[i] * dArray2[i];
                d3 += (dArray4[i] + dArray2[i]) * dArray4[i];
            }
            if (d4 == 0.0) {
                return;
            }
            double d5 = d3 / d4;
            for (int i = 1; i <= this.n; ++i) {
                dArray2[i] = -dArray4[i];
                dArray4[i] = dArray3[i] = dArray2[i] + d5 * dArray3[i];
            }
        }
        throw new ConjGradMinimizerException("Too many iterations in frprmn");
    }

    void linmin(double[] dArray, double[] dArray2) throws ConjGradMinimizerException {
        this.ax = 0.0;
        this.bx = 1.0;
        this.mnbrak(dArray, dArray2);
        this.fret = this.brent(dArray, dArray2, 2.0E-4);
        for (int i = 1; i <= this.n; ++i) {
            int n = i;
            dArray2[n] = dArray2[n] * this.xmin;
            int n2 = i;
            dArray[n2] = dArray[n2] + dArray2[i];
        }
    }

    protected void mnbrak(double[] dArray, double[] dArray2) {
        this.fa = this.f1dim(this.ax, dArray, dArray2);
        this.fb = this.f1dim(this.bx, dArray, dArray2);
        if (this.fb > this.fa) {
            double d = this.ax;
            this.ax = this.bx;
            this.bx = d;
            d = this.fb;
            this.fb = this.fa;
            this.fa = d;
        }
        this.cx = this.bx + 1.618034 * (this.bx - this.ax);
        this.fc = this.f1dim(this.cx, dArray, dArray2);
        while (this.fb > this.fc) {
            double d;
            double d2 = (this.bx - this.ax) * (this.fb - this.fc);
            double d3 = (this.bx - this.cx) * (this.fb - this.fa);
            double d4 = this.bx - ((this.bx - this.cx) * d3 - (this.bx - this.ax) * d2) / (2.0 * ConjGradMinimizer.SIGN(Math.max(Math.abs(d3 - d2), 1.0E-20), d3 - d2));
            double d5 = this.bx + 100.0 * (this.cx - this.bx);
            if ((this.bx - d4) * (d4 - this.cx) > 0.0) {
                d = this.f1dim(d4, dArray, dArray2);
                if (d < this.fc) {
                    this.ax = this.bx;
                    this.bx = d4;
                    this.fa = this.fb;
                    this.fb = d;
                    return;
                }
                if (d > this.fb) {
                    this.cx = d4;
                    this.fc = d;
                    return;
                }
                d4 = this.cx + 1.618034 * (this.cx - this.bx);
                d = this.f1dim(d4, dArray, dArray2);
            } else if ((this.cx - d4) * (d4 - d5) > 0.0) {
                d = this.f1dim(d4, dArray, dArray2);
                if (d < this.fc) {
                    this.bx = this.cx;
                    this.cx = d4;
                    d4 = this.cx + 1.618034 * (this.cx - this.bx);
                    this.fb = this.fc;
                    this.fc = d;
                    d = this.f1dim(d4, dArray, dArray2);
                }
            } else if ((d4 - d5) * (d5 - this.cx) >= 0.0) {
                d4 = d5;
                d = this.f1dim(d4, dArray, dArray2);
            } else {
                d4 = this.cx + 1.618034 * (this.cx - this.bx);
                d = this.f1dim(d4, dArray, dArray2);
            }
            this.ax = this.bx;
            this.bx = this.cx;
            this.cx = d4;
            this.fa = this.fb;
            this.fb = this.fc;
            this.fc = d;
        }
    }

    protected double brent(double[] dArray, double[] dArray2, double d) throws ConjGradMinimizerException {
        double d2;
        double d3;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.ax < this.cx ? this.ax : this.cx;
        double d7 = this.ax > this.cx ? this.ax : this.cx;
        double d8 = d3 = this.bx;
        double d9 = d3;
        double d10 = d2 = this.f1dim(d9, dArray, dArray2);
        double d11 = d2;
        for (int i = 1; i <= 100; ++i) {
            double d12;
            double d13 = 0.5 * (d6 + d7);
            double d14 = d * Math.abs(d9) + 1.0E-10;
            double d15 = 2.0 * d14;
            if (Math.abs(d9 - d13) <= d15 - 0.5 * (d7 - d6)) {
                this.xmin = d9;
                return d2;
            }
            if (Math.abs(d4) > d14) {
                double d16 = (d9 - d8) * (d2 - d10);
                double d17 = (d9 - d3) * (d2 - d11);
                double d18 = (d9 - d3) * d17 - (d9 - d8) * d16;
                if ((d17 = 2.0 * (d17 - d16)) > 0.0) {
                    d18 = -d18;
                }
                d17 = Math.abs(d17);
                double d19 = d4;
                d4 = d5;
                if (Math.abs(d18) >= Math.abs(0.5 * d17 * d19) || d18 <= d17 * (d6 - d9) || d18 >= d17 * (d7 - d9)) {
                    d4 = d9 >= d13 ? d6 - d9 : d7 - d9;
                    d5 = 0.381966 * d4;
                } else {
                    d5 = d18 / d17;
                    d12 = d9 + d5;
                    if (d12 - d6 < d15 || d7 - d12 < d15) {
                        d5 = ConjGradMinimizer.SIGN(d14, d13 - d9);
                    }
                }
            } else {
                d4 = d9 >= d13 ? d6 - d9 : d7 - d9;
                d5 = 0.381966 * d4;
            }
            d12 = Math.abs(d5) >= d14 ? d9 + d5 : d9 + ConjGradMinimizer.SIGN(d14, d5);
            double d20 = this.f1dim(d12, dArray, dArray2);
            if (d20 <= d2) {
                if (d12 >= d9) {
                    d6 = d9;
                } else {
                    d7 = d9;
                }
                d3 = d8;
                d8 = d9;
                d9 = d12;
                d10 = d11;
                d11 = d2;
                d2 = d20;
                continue;
            }
            if (d12 < d9) {
                d6 = d12;
            } else {
                d7 = d12;
            }
            if (d20 <= d11 || d8 == d9) {
                d3 = d8;
                d8 = d12;
                d10 = d11;
                d11 = d20;
                continue;
            }
            if (!(d20 <= d10) && d3 != d9 && d3 != d8) continue;
            d3 = d12;
            d10 = d20;
        }
        throw new ConjGradMinimizerException("Too many iterations in brent");
    }

    private double f1dim(double d, double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[this.n + 1];
        for (int i = 1; i <= this.n; ++i) {
            dArray3[i] = dArray[i] + d * dArray2[i];
        }
        double d2 = this.fObj(dArray3);
        return d2;
    }

    public static double SIGN(double d, double d2) {
        return d2 >= 0.0 ? Math.abs(d) : -Math.abs(d);
    }
}

