/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import numerics.BinghamFitter;
import numerics.ConvergenceException;
import numerics.Rotations;
import numerics.Vector3D;
import optimizers.ConjGradMinimizer;
import optimizers.ConjGradMinimizerException;

public class TwoFibreBinghamFitter
extends ConjGradMinimizer {
    protected Vector3D[] samples;
    protected double[] gi;
    protected double[] mu11DotXSq;
    protected double[] mu12DotXSq;
    protected double[] mu21DotXSq;
    protected double[] mu22DotXSq;
    protected double[] normC;

    public TwoFibreBinghamFitter(Vector3D[] vector3DArray) {
        this.samples = vector3DArray;
        this.gi = new double[this.samples.length];
        this.normC = new double[6];
        this.init(10);
        this.mu11DotXSq = new double[this.samples.length];
        this.mu21DotXSq = new double[this.samples.length];
        this.mu12DotXSq = new double[this.samples.length];
        this.mu22DotXSq = new double[this.samples.length];
    }

    public double[] fitEstimatedParams(Vector3D[] vector3DArray, double[] dArray, double d) throws ConjGradMinimizerException {
        double[] dArray2 = this.getParams(vector3DArray, dArray);
        this.minimise(dArray2, d);
        dArray2[4] = -1.0 * dArray2[4] * dArray2[4];
        dArray2[5] = dArray2[4] * Math.cos(dArray2[5]) * Math.cos(dArray2[5]);
        dArray2[9] = -1.0 * dArray2[9] * dArray2[9];
        dArray2[10] = dArray2[9] * Math.cos(dArray2[10]) * Math.cos(dArray2[10]);
        double[] dArray3 = new double[13];
        for (int i = 0; i < 11; ++i) {
            dArray3[i] = dArray2[i];
        }
        double d2 = 0.0;
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[4];
        try {
            d2 = BinghamFitter.bingc(dArray2[4], dArray2[5], dArray4, dArray5);
        }
        catch (ConvergenceException convergenceException) {
            throw new IllegalStateException("Couldn't calculate normC");
        }
        double d3 = 0.0;
        try {
            d3 = BinghamFitter.bingc(dArray2[9], dArray2[10], dArray4, dArray5);
        }
        catch (ConvergenceException convergenceException) {
            throw new IllegalStateException("Couldn't calculate normC");
        }
        dArray3[11] = d2;
        dArray3[12] = d3;
        return dArray3;
    }

    public static Vector3D[] getMus(double[] dArray) {
        Vector3D vector3D = Vector3D.vectorFromSPC(1.0, dArray[1], dArray[2]);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, dArray[6], dArray[7]);
        Vector3D vector3D3 = new Vector3D(Math.cos(dArray[2]) * Math.cos(dArray[3]) * Math.cos(dArray[1]) - Math.sin(dArray[2]) * Math.sin(dArray[3]), Math.cos(dArray[3]) * Math.cos(dArray[1]) * Math.sin(dArray[2]) + Math.cos(dArray[2]) * Math.sin(dArray[3]), -(Math.cos(dArray[3]) * Math.sin(dArray[1])));
        Vector3D vector3D4 = new Vector3D(Math.cos(dArray[7]) * Math.cos(dArray[8]) * Math.cos(dArray[6]) - Math.sin(dArray[7]) * Math.sin(dArray[8]), Math.cos(dArray[8]) * Math.cos(dArray[6]) * Math.sin(dArray[7]) + Math.cos(dArray[7]) * Math.sin(dArray[8]), -(Math.cos(dArray[8]) * Math.sin(dArray[6])));
        Vector3D vector3D5 = vector3D.cross(vector3D3);
        Vector3D vector3D6 = vector3D2.cross(vector3D4);
        return new Vector3D[]{vector3D5, vector3D3, vector3D, vector3D6, vector3D4, vector3D2};
    }

    public double[] getParams(Vector3D[] vector3DArray, double[] dArray) {
        double[] dArray2 = new double[11];
        double[] dArray3 = Vector3D.thetaPhi(vector3DArray[0]);
        dArray2[1] = dArray3[0];
        dArray2[2] = dArray3[1];
        Vector3D vector3D = Rotations.rotateVector(Rotations.X_AXIS, Rotations.Y_AXIS, dArray2[1]);
        vector3D = Rotations.rotateVector(vector3D, Rotations.Z_AXIS, dArray2[2]);
        dArray2[3] = Math.acos(-vector3D.dot(vector3DArray[1]));
        if (Math.abs(vector3DArray[1].dot(Rotations.rotateVector(vector3D, vector3DArray[0], dArray2[3]))) < 0.99) {
            dArray2[3] = -dArray2[3];
        }
        dArray2[4] = Math.sqrt(Math.abs(dArray[0]));
        dArray2[5] = Math.acos(Math.sqrt(Math.abs(dArray[1])) / dArray2[4]);
        dArray3 = Vector3D.thetaPhi(vector3DArray[2]);
        dArray2[6] = dArray3[0];
        dArray2[7] = dArray3[1];
        vector3D = Rotations.rotateVector(Rotations.X_AXIS, Rotations.Y_AXIS, dArray2[6]);
        vector3D = Rotations.rotateVector(vector3D, Rotations.Z_AXIS, dArray2[7]);
        dArray2[8] = Math.acos(-vector3D.dot(vector3DArray[3]));
        if (Math.abs(vector3DArray[3].dot(Rotations.rotateVector(vector3D, vector3DArray[2], dArray2[8]))) < 0.99) {
            dArray2[8] = -dArray2[8];
        }
        dArray2[9] = Math.sqrt(Math.abs(dArray[2]));
        dArray2[10] = Math.acos(Math.sqrt(Math.abs(dArray[3])) / dArray2[9]);
        return dArray2;
    }

    @Override
    protected void init(int n) {
        super.init(n);
    }

    @Override
    protected double fObj(double[] dArray) {
        double d = Math.sin(dArray[1]);
        double d2 = Math.cos(dArray[1]);
        double d3 = Math.sin(dArray[2]);
        double d4 = Math.cos(dArray[2]);
        double d5 = Math.sin(dArray[3]);
        double d6 = Math.cos(dArray[3]);
        double d7 = Math.sin(dArray[6]);
        double d8 = Math.cos(dArray[6]);
        double d9 = Math.sin(dArray[7]);
        double d10 = Math.cos(dArray[7]);
        double d11 = Math.sin(dArray[8]);
        double d12 = Math.cos(dArray[8]);
        double d13 = Math.cos(dArray[5]) * Math.cos(dArray[5]);
        double d14 = Math.cos(dArray[10]) * Math.cos(dArray[10]);
        double d15 = -1.0 * dArray[4] * dArray[4];
        double d16 = -1.0 * dArray[4] * dArray[4] * d13;
        double d17 = 0.0;
        try {
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[4];
            this.normC[0] = d17 = Math.PI * 4 * BinghamFitter.bingc(d15, d16, dArray2, dArray3);
            this.normC[1] = Math.PI * 4 * dArray2[0] * d17;
            this.normC[2] = Math.PI * 4 * dArray2[1] * d17;
        }
        catch (ConvergenceException convergenceException) {
            throw new IllegalStateException("Couldn't calculate normC");
        }
        double d18 = -1.0 * dArray[9] * dArray[9];
        double d19 = -1.0 * dArray[9] * dArray[9] * d14;
        double d20 = 0.0;
        try {
            double[] dArray4 = new double[2];
            double[] dArray5 = new double[4];
            this.normC[3] = d20 = Math.PI * 4 * BinghamFitter.bingc(d18, d19, dArray4, dArray5);
            this.normC[4] = Math.PI * 4 * dArray4[0] * d20;
            this.normC[5] = Math.PI * 4 * dArray4[1] * d20;
        }
        catch (ConvergenceException convergenceException) {
            throw new IllegalStateException("Couldn't calculate normC");
        }
        double d21 = 0.0;
        for (int i = 0; i < this.samples.length; ++i) {
            double d22 = this.samples[i].z * d2 + this.samples[i].x * d4 * d + this.samples[i].y * d3 * d;
            double d23 = this.samples[i].y * (d6 * d2 * d3 + d4 * d5) + this.samples[i].x * (d4 * d6 * d2 - d3 * d5) - this.samples[i].z * d6 * d;
            double d24 = this.samples[i].z * d8 + this.samples[i].x * d10 * d7 + this.samples[i].y * d9 * d7;
            double d25 = this.samples[i].y * (d12 * d8 * d9 + d10 * d11) + this.samples[i].x * (d10 * d12 * d8 - d9 * d11) - this.samples[i].z * d12 * d7;
            this.mu11DotXSq[i] = d22 * d22;
            this.mu21DotXSq[i] = d23 * d23;
            this.mu12DotXSq[i] = d24 * d24;
            this.mu22DotXSq[i] = d25 * d25;
            this.gi[i] = Math.exp(d16 * this.mu21DotXSq[i] + d15 * this.mu11DotXSq[i]) / (2.0 * this.normC[0]) + Math.exp(d19 * this.mu22DotXSq[i] + d18 * this.mu12DotXSq[i]) / (2.0 * this.normC[3]);
            d21 -= Math.log(this.gi[i]);
        }
        return d21;
    }

    @Override
    protected double[] dfObj(double[] dArray) {
        double d = Math.sin(dArray[1]);
        double d2 = Math.cos(dArray[1]);
        double d3 = Math.sin(dArray[2]);
        double d4 = Math.cos(dArray[2]);
        double d5 = Math.sin(dArray[3]);
        double d6 = Math.cos(dArray[3]);
        double d7 = Math.sin(dArray[6]);
        double d8 = Math.cos(dArray[6]);
        double d9 = Math.sin(dArray[7]);
        double d10 = Math.cos(dArray[7]);
        double d11 = Math.sin(dArray[8]);
        double d12 = Math.cos(dArray[8]);
        double d13 = dArray[4];
        double d14 = dArray[9];
        double d15 = dArray[5];
        double d16 = dArray[10];
        double d17 = Math.cos(d15);
        double d18 = Math.sin(d15);
        double d19 = Math.cos(d16);
        double d20 = Math.sin(d16);
        double d21 = d17 * d17;
        double d22 = d19 * d19;
        double[] dArray2 = new double[11];
        for (int i = 0; i < this.samples.length; ++i) {
            double[] dArray3 = new double[11];
            double d23 = this.samples[i].x;
            double d24 = this.samples[i].y;
            double d25 = this.samples[i].z;
            double d26 = Math.exp(-(d13 * d13 * d21 * this.mu21DotXSq[i]) - d13 * d13 * this.mu11DotXSq[i]);
            double d27 = Math.exp(-(d14 * d14 * d22 * this.mu22DotXSq[i]) - d14 * d14 * this.mu12DotXSq[i]);
            dArray3[1] = d26 * (-2.0 * (d13 * d13) * (d23 * d4 * d2 + d24 * d2 * d3 - d25 * d) * (d25 * d2 + d23 * d4 * d + d24 * d3 * d) - 2.0 * (d13 * d13) * d21 * (d24 * (d6 * d2 * d3 + d4 * d5) + d23 * (d4 * d6 * d2 - d3 * d5) - d25 * d6 * d) * (-(d25 * d6 * d2) - d23 * d4 * d6 * d - d24 * d6 * d3 * d)) / (2.0 * this.normC[0]);
            dArray2[1] = dArray2[1] - dArray3[1] / this.gi[i];
            dArray3[2] = d26 * (-2.0 * (d13 * d13) * d21 * (d23 * (-(d6 * d2 * d3) - d4 * d5) + d24 * (d4 * d6 * d2 - d3 * d5)) * (d24 * (d6 * d2 * d3 + d4 * d5) + d23 * (d4 * d6 * d2 - d3 * d5) - d25 * d6 * d) - 2.0 * (d13 * d13) * (d24 * d4 * d - d23 * d3 * d) * (d25 * d2 + d23 * d4 * d + d24 * d3 * d)) / (2.0 * this.normC[0]);
            dArray2[2] = dArray2[2] - dArray3[2] / this.gi[i];
            dArray3[3] = -(d26 * (d13 * d13) * d21 * (d24 * (d6 * d2 * d3 + d4 * d5) + d23 * (d4 * d6 * d2 - d3 * d5) - d25 * d6 * d) * (d23 * (-(d6 * d3) - d4 * d2 * d5) + d24 * (d4 * d6 - d2 * d3 * d5) + d25 * d5 * d) / this.normC[0]);
            dArray2[3] = dArray2[3] - dArray3[3] / this.gi[i];
            dArray3[4] = d26 * (-2.0 * d13 * d21 * this.mu21DotXSq[i] - 2.0 * d13 * this.mu11DotXSq[i]) / (2.0 * this.normC[0]) - d26 * (-2.0 * d13 * d21 * this.normC[2] - 2.0 * d13 * this.normC[1]) / (2.0 * (this.normC[0] * this.normC[0]));
            dArray2[4] = dArray2[4] - dArray3[4] / this.gi[i];
            dArray3[5] = d26 * (d13 * d13) * d17 * d18 * this.mu21DotXSq[i] / this.normC[0] - d26 * (d13 * d13) * d17 * d18 * this.normC[2] / (this.normC[0] * this.normC[0]);
            dArray2[5] = dArray2[5] - dArray3[5] / this.gi[i];
            dArray3[6] = d27 * (-2.0 * (d14 * d14) * (d23 * d10 * d8 + d24 * d8 * d9 - d25 * d7) * (d25 * d8 + d23 * d10 * d7 + d24 * d9 * d7) - 2.0 * (d14 * d14) * d22 * (d24 * (d12 * d8 * d9 + d10 * d11) + d23 * (d10 * d12 * d8 - d9 * d11) - d25 * d12 * d7) * (-(d25 * d12 * d8) - d23 * d10 * d12 * d7 - d24 * d12 * d9 * d7)) / (2.0 * this.normC[3]);
            dArray2[6] = dArray2[6] - dArray3[6] / this.gi[i];
            dArray3[7] = d27 * (-2.0 * (d14 * d14) * d22 * (d23 * (-(d12 * d8 * d9) - d10 * d11) + d24 * (d10 * d12 * d8 - d9 * d11)) * (d24 * (d12 * d8 * d9 + d10 * d11) + d23 * (d10 * d12 * d8 - d9 * d11) - d25 * d12 * d7) - 2.0 * (d14 * d14) * (d24 * d10 * d7 - d23 * d9 * d7) * (d25 * d8 + d23 * d10 * d7 + d24 * d9 * d7)) / (2.0 * this.normC[3]);
            dArray2[7] = dArray2[7] - dArray3[7] / this.gi[i];
            dArray3[8] = -(d27 * (d14 * d14) * d22 * (d24 * (d12 * d8 * d9 + d10 * d11) + d23 * (d10 * d12 * d8 - d9 * d11) - d25 * d12 * d7) * (d23 * (-(d12 * d9) - d10 * d8 * d11) + d24 * (d10 * d12 - d8 * d9 * d11) + d25 * d11 * d7) / this.normC[3]);
            dArray2[8] = dArray2[8] - dArray3[8] / this.gi[i];
            dArray3[9] = d27 * (-2.0 * d14 * d22 * this.mu22DotXSq[i] - 2.0 * d14 * this.mu12DotXSq[i]) / (2.0 * this.normC[3]) - d27 * (-2.0 * d14 * d22 * this.normC[5] - 2.0 * d14 * this.normC[4]) / (2.0 * (this.normC[3] * this.normC[3]));
            dArray2[9] = dArray2[9] - dArray3[9] / this.gi[i];
            dArray3[10] = d27 * (d14 * d14) * d19 * d20 * this.mu22DotXSq[i] / this.normC[3] - d27 * (d14 * d14) * d19 * d20 * this.normC[5] / (this.normC[3] * this.normC[3]);
            dArray2[10] = dArray2[10] - dArray3[10] / this.gi[i];
        }
        return dArray2;
    }
}

