/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import numerics.Complex;
import numerics.SphericalHarmonicException;

public class SphericalHarmonics {
    public static Complex Y(int n, int n2, double d, double d2) throws SphericalHarmonicException {
        int n3 = Math.abs(n2);
        double d3 = SphericalHarmonics.getFactor(n, n3);
        double d4 = SphericalHarmonics.plgndr(n, n3, Math.cos(d));
        Complex complex = new Complex(Math.cos((double)n3 * d2), Math.sin((double)n3 * d2));
        Complex complex2 = complex.times(d3 * d4);
        if (n2 < 0) {
            complex2 = complex2.conjugate();
            if (n3 % 2 == 1) {
                complex2 = complex2.negate();
            }
        }
        return complex2;
    }

    private static double getFactor(int n, int n2) {
        double d = 1.0;
        for (int i = n - n2 + 1; i <= n + n2; ++i) {
            d *= (double)i;
        }
        d = (double)(2 * n + 1) / d;
        d /= Math.PI * 4;
        d = Math.sqrt(d);
        return d;
    }

    public static double plgndr(int n, int n2, double d) throws SphericalHarmonicException {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = 0;
        int n4 = 0;
        if (n2 < 0 || n2 > n || Math.abs(d) > 1.0) {
            throw new SphericalHarmonicException("Bad arguments in routine plgndr");
        }
        d4 = 1.0;
        if (n2 > 0) {
            d6 = Math.sqrt((1.0 - d) * (1.0 + d));
            d2 = 1.0;
            for (n3 = 1; n3 <= n2; ++n3) {
                d4 *= -d2 * d6;
                d2 += 2.0;
            }
        }
        if (n == n2) {
            return d4;
        }
        d5 = d * (double)(2 * n2 + 1) * d4;
        if (n == n2 + 1) {
            return d5;
        }
        for (n4 = n2 + 2; n4 <= n; ++n4) {
            d3 = (d * (double)(2 * n4 - 1) * d5 - (double)(n4 + n2 - 1) * d4) / (double)(n4 - n2);
            d4 = d5;
            d5 = d3;
        }
        return d3;
    }

    public static int funcsUpTo(int n) {
        return (n + 1) * (n + 1);
    }

    public static int evenFuncsUpTo(int n) {
        if (n % 2 == 1) {
            --n;
        }
        return (n + 1) * (n / 2 + 1);
    }
}

