/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.io.Serializable;
import numerics.SVD_Exception;

public class RealMatrix
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -495648904583884654L;
    protected int r;
    protected int c;
    public double[][] entries;

    public RealMatrix() {
        this.r = 0;
        this.c = 0;
        this.entries = null;
    }

    public RealMatrix(int n, int n2) {
        this.r = n;
        this.c = n2;
        this.entries = null;
        this.entries = new double[this.r][this.c];
    }

    public RealMatrix(double[][] dArray) {
        this.r = dArray.length;
        this.c = dArray[0].length;
        this.entries = dArray;
    }

    public Object clone() {
        RealMatrix realMatrix = new RealMatrix(this.r, this.c);
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                realMatrix.entries[i][j] = this.entries[i][j];
            }
        }
        return realMatrix;
    }

    public static RealMatrix identity(int n) {
        RealMatrix realMatrix = new RealMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            realMatrix.setEntry(i, i, 1.0);
        }
        return realMatrix;
    }

    public double entry(int n, int n2) {
        if (n < 0 || n >= this.r || n2 < 0 || n2 >= this.c) {
            throw new RuntimeException("RealMatrix entry out of range! row= " + n + " num rows= " + this.r + " column = " + n2 + " num columns = " + this.c);
        }
        return this.entries[n][n2];
    }

    public void setEntry(int n, int n2, double d) {
        if (n < 0 || n >= this.r || n2 < 0 || n2 >= this.c) {
            throw new RuntimeException("RealMatrix entry out of range! row= " + n + " num rows= " + this.r + " column = " + n2 + " num columns = " + this.c);
        }
        this.entries[n][n2] = d;
    }

    public int rows() {
        return this.r;
    }

    public int columns() {
        return this.c;
    }

    public void swapColumns(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.r; ++i) {
            d = this.entries[i][n];
            this.entries[i][n] = this.entries[i][n2];
            this.entries[i][n2] = d;
        }
    }

    public void swapRows(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.c; ++i) {
            d = this.entries[n][i];
            this.entries[n][i] = this.entries[n2][i];
            this.entries[n2][i] = d;
        }
    }

    public RealMatrix product(RealMatrix realMatrix) {
        RealMatrix realMatrix2 = new RealMatrix(this.r, realMatrix.columns());
        if (this.c != realMatrix.rows()) {
            System.err.println("WARNING: Cannot multiply matrices (columns in this =" + this.c + ", rows in given = " + realMatrix.rows() + ") - zero matrix returned");
            return realMatrix2;
        }
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < realMatrix.columns(); ++j) {
                double d = 0.0;
                for (int k = 0; k < this.c; ++k) {
                    d += this.entries[i][k] * realMatrix.entries[k][j];
                }
                realMatrix2.entries[i][j] = d;
            }
        }
        return realMatrix2;
    }

    public RealMatrix add(RealMatrix realMatrix) {
        RealMatrix realMatrix2 = new RealMatrix(this.r, this.c);
        if (this.r != realMatrix.rows() || this.c != realMatrix.columns()) {
            System.err.println("Cannot add matrices of different sizes [this is a (" + this.r + "x" + this.c + "), given a (" + realMatrix.rows() + "x" + realMatrix.columns() + ")]\t- zero matrix returned.");
            return realMatrix2;
        }
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                realMatrix2.entries[i][j] = this.entries[i][j] + realMatrix.entries[i][j];
            }
        }
        return realMatrix2;
    }

    public RealMatrix sub(RealMatrix realMatrix) {
        RealMatrix realMatrix2 = new RealMatrix(this.r, this.c);
        if (this.r != realMatrix.rows() || this.c != realMatrix.columns()) {
            System.err.println("Cannot subtract matrices of different sizes [this is a (" + this.r + "x" + this.c + "), given a (" + realMatrix.rows() + "x" + realMatrix.columns() + ")]\t- zero matrix returned.");
            return realMatrix2;
        }
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                realMatrix2.entries[i][j] = this.entries[i][j] - realMatrix.entries[i][j];
            }
        }
        return realMatrix2;
    }

    public RealMatrix negate() {
        RealMatrix realMatrix = new RealMatrix(this.r, this.c);
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                realMatrix.entries[i][j] = -this.entries[i][j];
            }
        }
        return realMatrix;
    }

    public void scale(double d) {
        for (int i = 0; i < this.r; ++i) {
            int n = 0;
            while (n < this.c) {
                double[] dArray = this.entries[i];
                int n2 = n++;
                dArray[n2] = dArray[n2] * d;
            }
        }
    }

    public RealMatrix scalarMult(double d) {
        RealMatrix realMatrix = new RealMatrix(this.r, this.c);
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                realMatrix.entries[i][j] = this.entries[i][j] * d;
            }
        }
        return realMatrix;
    }

    public RealMatrix inverse() {
        RealMatrix realMatrix = new RealMatrix(this.r, this.c);
        if (this.r != this.c) {
            System.err.println("Cannot invert non-square RealMatrix - NULL RealMatrix returned");
            return realMatrix;
        }
        realMatrix = this.adjoint();
        realMatrix = realMatrix.transpose();
        realMatrix.scale(1.0 / this.det());
        return realMatrix;
    }

    public RealMatrix adjoint() {
        RealMatrix realMatrix = new RealMatrix(this.r, this.c);
        if (this.r != this.c) {
            System.err.println("Cannot adjoint non-square RealMatrix - NULL RealMatrix returned");
            return realMatrix;
        }
        if (this.r == 1) {
            realMatrix = (RealMatrix)this.clone();
            return realMatrix;
        }
        int n = -1;
        for (int i = 0; i < this.r; ++i) {
            int n2 = -n;
            for (int j = 0; j < this.c; ++j) {
                RealMatrix realMatrix2 = new RealMatrix(this.r - 1, this.c - 1);
                int n3 = 0;
                for (int k = 0; k < this.r; ++k) {
                    int n4 = 0;
                    for (int i2 = 0; i2 < this.c; ++i2) {
                        if (k == i || i2 == j) continue;
                        realMatrix2.entries[n3][n4] = this.entries[k][i2];
                        ++n4;
                    }
                    if (k == i) continue;
                    ++n3;
                }
                realMatrix.entries[i][j] = (double)n2 * realMatrix2.det();
                n2 = -n2;
            }
            n = -n;
        }
        return realMatrix;
    }

    public double det() {
        if (this.r != this.c) {
            System.err.println("Cannot find determinant of non-square RealMatrix - zero returned");
            return 0.0;
        }
        if (this.r == 1) {
            return this.entries[0][0];
        }
        if (this.triangular()) {
            double d = this.entries[0][0];
            for (int i = 1; i < this.r; ++i) {
                d *= this.entries[i][i];
            }
            return d;
        }
        double d = 0.0;
        int n = 1;
        for (int i = 0; i < this.c; ++i) {
            RealMatrix realMatrix = new RealMatrix(this.r - 1, this.c - 1);
            for (int j = 0; j < this.r - 1; ++j) {
                int n2 = 0;
                for (int k = 0; k < this.c; ++k) {
                    if (k == i) continue;
                    realMatrix.entries[j][n2] = this.entries[j + 1][k];
                    ++n2;
                }
            }
            d += (double)n * this.entries[0][i] * realMatrix.det();
            n = -n;
        }
        return d;
    }

    public double trace() {
        double d = 0.0;
        for (int i = 0; i < this.r && i < this.c; ++i) {
            d += this.entries[i][i];
        }
        return d;
    }

    public RealMatrix transpose() {
        RealMatrix realMatrix = new RealMatrix(this.c, this.r);
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                realMatrix.entries[j][i] = this.entries[i][j];
            }
        }
        return realMatrix;
    }

    public RealMatrix[] jacobi() {
        int n;
        if (!this.symmetric()) {
            throw new RuntimeException("RealMatrix is not symmetric, cannot perform Jacobi transformation");
        }
        RealMatrix realMatrix = new RealMatrix(this.r, this.r);
        for (int i = 0; i < this.r; ++i) {
            realMatrix.entries[i][i] = 1.0;
        }
        RealMatrix realMatrix2 = new RealMatrix(this.r, this.r);
        for (n = 0; n < this.r; ++n) {
            for (int i = 0; i < this.r; ++i) {
                realMatrix2.entries[n][i] = this.entries[n][i];
            }
        }
        for (n = 0; n < 50; ++n) {
            double d = 0.0;
            for (int i = 0; i < this.r; ++i) {
                for (int j = 0; j < i; ++j) {
                    d += Math.abs(realMatrix2.entries[i][j]);
                }
            }
            if (d == 0.0) {
                RealMatrix[] realMatrixArray = new RealMatrix[]{realMatrix2, realMatrix};
                return realMatrixArray;
            }
            double d2 = 0.0;
            if (n < 4) {
                d2 = 0.2 * d / (double)(this.r * this.r);
            }
            for (int i = 0; i < this.r - 1; ++i) {
                for (int j = i + 1; j < this.r; ++j) {
                    double d3;
                    double d4 = 100.0 * Math.abs(realMatrix2.entries[i][j]);
                    if (n > 4 && Math.abs(realMatrix2.entries[i][i]) + d4 == Math.abs(realMatrix2.entries[i][i]) && Math.abs(realMatrix2.entries[j][j]) + d4 == Math.abs(realMatrix2.entries[j][j])) {
                        realMatrix2.entries[i][j] = 0.0;
                        realMatrix2.entries[j][i] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(realMatrix2.entries[i][j]) > d2)) continue;
                    double d5 = realMatrix2.entries[j][j] - realMatrix2.entries[i][i];
                    double d6 = 0.0;
                    if (Math.abs(d5) + d4 == Math.abs(d5)) {
                        d6 = realMatrix2.entries[i][j] / d5;
                    } else {
                        d3 = 0.5 * d5 / realMatrix2.entries[i][j];
                        d6 = 1.0 / (Math.abs(d3) + Math.sqrt(1.0 + d3 * d3));
                        if (d3 < 0.0) {
                            d6 = -d6;
                        }
                    }
                    d3 = 1.0 / Math.sqrt(1.0 + d6 * d6);
                    double d7 = d6 * d3;
                    RealMatrix realMatrix3 = new RealMatrix(this.r, this.r);
                    for (int k = 0; k < this.r; ++k) {
                        realMatrix3.entries[k][k] = 1.0;
                    }
                    realMatrix3.entries[i][i] = d3;
                    realMatrix3.entries[j][j] = d3;
                    realMatrix3.entries[i][j] = d7;
                    realMatrix3.entries[j][i] = -d7;
                    realMatrix2 = realMatrix3.transpose().product(realMatrix2).product(realMatrix3);
                    realMatrix = realMatrix.product(realMatrix3);
                }
            }
        }
        throw new RuntimeException("Too many iterations in Jacobi routine");
    }

    public boolean symmetric() {
        if (this.r != this.c) {
            return false;
        }
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.entries[i][j] == this.entries[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean triangular() {
        if (this.r != this.c) {
            return false;
        }
        if (this.r == 1) {
            return true;
        }
        boolean bl = true;
        boolean bl2 = true;
        for (int i = 1; i < this.r; ++i) {
            for (int j = 0; j < i; ++j) {
                bl = bl && this.entries[i][j] == 0.0;
                bl2 = bl2 && this.entries[j][i] == 0.0;
            }
        }
        return bl || bl2;
    }

    public RealMatrix luinvert() {
        if (this.r != this.c) {
            throw new RuntimeException("Cannot LU-decompose non-square RealMatrix");
        }
        RealMatrix realMatrix = new RealMatrix(this.r, this.r);
        RealMatrix realMatrix2 = new RealMatrix(this.r, this.c);
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                realMatrix2.entries[i][j] = this.entries[i][j];
            }
        }
        int[] nArray = new int[this.r];
        double[] dArray = new double[this.r];
        realMatrix2.ludecomp(nArray);
        for (int i = 0; i < this.r; ++i) {
            int n;
            for (n = 0; n < this.r; ++n) {
                dArray[n] = 0.0;
            }
            dArray[i] = 1.0;
            realMatrix2.lubksub(nArray, dArray);
            for (n = 0; n < this.r; ++n) {
                realMatrix.entries[n][i] = dArray[n];
            }
        }
        return realMatrix;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                string = string + this.entries[i][j] + "\t";
            }
            string = string + "\n";
        }
        return string;
    }

    private void ludecomp(int[] nArray) {
        int n;
        double d;
        int n2;
        RealMatrix realMatrix = new RealMatrix(this.r, 1);
        int n3 = 0;
        for (n2 = 0; n2 < this.r; ++n2) {
            d = 0.0;
            for (n = 0; n < this.r; ++n) {
                double d2;
                double d3 = Math.abs(this.entries[n2][n]);
                if (!(d2 > d)) continue;
                d = d3;
            }
            if (d == 0.0) {
                throw new RuntimeException("Cannot LU-decompose singular RealMatrix");
            }
            realMatrix.entries[n2][0] = 1.0 / d;
        }
        for (n2 = 0; n2 < this.r; ++n2) {
            double d4;
            int n4;
            double d5;
            for (n = 0; n <= n2; ++n) {
                d5 = this.entries[n][n2];
                for (n4 = 0; n4 < n; ++n4) {
                    d5 -= this.entries[n][n4] * this.entries[n4][n2];
                }
                this.entries[n][n2] = d5;
            }
            d = 0.0;
            for (n = n2 + 1; n < this.r; ++n) {
                double d6;
                d5 = this.entries[n][n2];
                for (n4 = 0; n4 < n2; ++n4) {
                    d5 -= this.entries[n][n4] * this.entries[n4][n2];
                }
                this.entries[n][n2] = d5;
                d4 = realMatrix.entries[n][0] * Math.abs(d5);
                if (!(d6 >= d)) continue;
                d = d4;
                n3 = n;
            }
            if (n2 != n3) {
                for (n = 0; n < this.r; ++n) {
                    d4 = this.entries[n3][n];
                    this.entries[n3][n] = this.entries[n2][n];
                    this.entries[n2][n] = d4;
                }
                realMatrix.entries[n3][0] = realMatrix.entries[n2][0];
            }
            nArray[n2] = n3;
            if (n2 == this.r - 1) continue;
            d4 = 1.0 / this.entries[n2][n2];
            for (n = n2 + 1; n < this.r; ++n) {
                double[] dArray = this.entries[n];
                int n5 = n2;
                dArray[n5] = dArray[n5] * d4;
            }
        }
    }

    private void lubksub(int[] nArray, double[] dArray) {
        double d;
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.r; ++n2) {
            n = nArray[n2];
            d = dArray[n];
            dArray[n] = dArray[n2];
            if (n3 != 0) {
                for (int i = n3 - 1; i < n2; ++i) {
                    d -= this.entries[n2][i] * dArray[i];
                }
            } else if (d != 0.0) {
                n3 = n2 + 1;
            }
            dArray[n2] = d;
        }
        for (n2 = this.r - 1; n2 >= 0; --n2) {
            d = dArray[n2];
            for (n = n2 + 1; n < this.r; ++n) {
                d -= this.entries[n2][n] * dArray[n];
            }
            dArray[n2] = d / this.entries[n2][n2];
        }
    }

    public RealMatrix[] svd() throws SVD_Exception {
        int n;
        int n2;
        double[][] dArray = new double[this.r + 1][this.c + 1];
        for (int i = 1; i <= this.r; ++i) {
            for (int j = 1; j <= this.c; ++j) {
                dArray[i][j] = this.entries[i - 1][j - 1];
            }
        }
        double[][] dArray2 = new double[this.c + 1][this.c + 1];
        double[] dArray3 = new double[this.c + 1];
        this.dsvdcmp(dArray, this.r, this.c, dArray3, dArray2);
        RealMatrix[] realMatrixArray = new RealMatrix[3];
        realMatrixArray[0] = new RealMatrix(dArray.length - 1, dArray[0].length - 1);
        for (n2 = 0; n2 < dArray.length - 1; ++n2) {
            for (n = 0; n < dArray[0].length - 1; ++n) {
                realMatrixArray[0].setEntry(n2, n, dArray[n2 + 1][n + 1]);
            }
        }
        realMatrixArray[1] = new RealMatrix(dArray3.length - 1, dArray3.length - 1);
        for (n2 = 0; n2 < dArray3.length - 1; ++n2) {
            realMatrixArray[1].setEntry(n2, n2, dArray3[n2 + 1]);
        }
        realMatrixArray[2] = new RealMatrix(dArray2.length - 1, dArray2[0].length - 1);
        for (n2 = 0; n2 < dArray2.length - 1; ++n2) {
            for (n = 0; n < dArray2[0].length - 1; ++n) {
                realMatrixArray[2].setEntry(n2, n, dArray2[n2 + 1][n + 1]);
            }
        }
        return realMatrixArray;
    }

    protected void dsvdcmp(double[][] dArray, int n, int n2, double[] dArray2, double[][] dArray3) throws SVD_Exception {
        int n3;
        double d;
        double d2;
        int n4;
        double d3;
        int n5;
        int n6 = 0;
        int n7 = 0;
        double[] dArray4 = new double[n2 + 1];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n5 = 1; n5 <= n2; ++n5) {
            n6 = n5 + 1;
            dArray4[n5] = d5 * d6;
            d5 = 0.0;
            d3 = 0.0;
            d6 = 0.0;
            if (n5 <= n) {
                for (n4 = n5; n4 <= n; ++n4) {
                    d5 += Math.abs(dArray[n4][n5]);
                }
                if (d5 != 0.0) {
                    for (n4 = n5; n4 <= n; ++n4) {
                        double[] dArray5 = dArray[n4];
                        int n8 = n5;
                        dArray5[n8] = dArray5[n8] / d5;
                        d3 += dArray[n4][n5] * dArray[n4][n5];
                    }
                    d2 = dArray[n5][n5];
                    d6 = -(d2 >= 0.0 ? Math.sqrt(d3) : -Math.sqrt(d3));
                    d = d2 * d6 - d3;
                    dArray[n5][n5] = d2 - d6;
                    for (n3 = n6; n3 <= n2; ++n3) {
                        d3 = 0.0;
                        for (n4 = n5; n4 <= n; ++n4) {
                            d3 += dArray[n4][n5] * dArray[n4][n3];
                        }
                        d2 = d3 / d;
                        for (n4 = n5; n4 <= n; ++n4) {
                            double[] dArray6 = dArray[n4];
                            int n9 = n3;
                            dArray6[n9] = dArray6[n9] + d2 * dArray[n4][n5];
                        }
                    }
                    for (n4 = n5; n4 <= n; ++n4) {
                        double[] dArray7 = dArray[n4];
                        int n10 = n5;
                        dArray7[n10] = dArray7[n10] * d5;
                    }
                }
            }
            dArray2[n5] = d5 * d6;
            d5 = 0.0;
            d3 = 0.0;
            d6 = 0.0;
            if (n5 <= n && n5 != n2) {
                for (n4 = n6; n4 <= n2; ++n4) {
                    d5 += Math.abs(dArray[n5][n4]);
                }
                if (d5 != 0.0) {
                    for (n4 = n6; n4 <= n2; ++n4) {
                        double[] dArray8 = dArray[n5];
                        int n11 = n4;
                        dArray8[n11] = dArray8[n11] / d5;
                        d3 += dArray[n5][n4] * dArray[n5][n4];
                    }
                    d2 = dArray[n5][n6];
                    d6 = -(d2 >= 0.0 ? Math.sqrt(d3) : -Math.sqrt(d3));
                    d = d2 * d6 - d3;
                    dArray[n5][n6] = d2 - d6;
                    for (n4 = n6; n4 <= n2; ++n4) {
                        dArray4[n4] = dArray[n5][n4] / d;
                    }
                    for (n3 = n6; n3 <= n; ++n3) {
                        d3 = 0.0;
                        for (n4 = n6; n4 <= n2; ++n4) {
                            d3 += dArray[n3][n4] * dArray[n5][n4];
                        }
                        for (n4 = n6; n4 <= n2; ++n4) {
                            double[] dArray9 = dArray[n3];
                            int n12 = n4;
                            dArray9[n12] = dArray9[n12] + d3 * dArray4[n4];
                        }
                    }
                    n4 = n6;
                    while (n4 <= n2) {
                        double[] dArray10 = dArray[n5];
                        int n13 = n4++;
                        dArray10[n13] = dArray10[n13] * d5;
                    }
                }
            }
            d4 = d4 > Math.abs(dArray2[n5]) + Math.abs(dArray4[n5]) ? d4 : Math.abs(dArray2[n5]) + Math.abs(dArray4[n5]);
        }
        n5 = n2;
        while (n5 >= 1) {
            if (n5 < n2) {
                if (d6 != 0.0) {
                    for (n3 = n6; n3 <= n2; ++n3) {
                        dArray3[n3][n5] = dArray[n5][n3] / dArray[n5][n6] / d6;
                    }
                    for (n3 = n6; n3 <= n2; ++n3) {
                        d3 = 0.0;
                        for (n4 = n6; n4 <= n2; ++n4) {
                            d3 += dArray[n5][n4] * dArray3[n4][n3];
                        }
                        for (n4 = n6; n4 <= n2; ++n4) {
                            double[] dArray11 = dArray3[n4];
                            int n14 = n3;
                            dArray11[n14] = dArray11[n14] + d3 * dArray3[n4][n5];
                        }
                    }
                }
                for (n3 = n6; n3 <= n2; ++n3) {
                    dArray3[n3][n5] = 0.0;
                    dArray3[n5][n3] = 0.0;
                }
            }
            dArray3[n5][n5] = 1.0;
            d6 = dArray4[n5];
            n6 = n5--;
        }
        int n15 = n5 = n < n2 ? n : n2;
        while (n5 >= 1) {
            n6 = n5 + 1;
            d6 = dArray2[n5];
            for (n3 = n6; n3 <= n2; ++n3) {
                dArray[n5][n3] = 0.0;
            }
            if (d6 != 0.0) {
                d6 = 1.0 / d6;
                for (n3 = n6; n3 <= n2; ++n3) {
                    d3 = 0.0;
                    for (n4 = n6; n4 <= n; ++n4) {
                        d3 += dArray[n4][n5] * dArray[n4][n3];
                    }
                    d2 = d3 / dArray[n5][n5] * d6;
                    for (n4 = n5; n4 <= n; ++n4) {
                        double[] dArray12 = dArray[n4];
                        int n16 = n3;
                        dArray12[n16] = dArray12[n16] + d2 * dArray[n4][n5];
                    }
                }
                for (n3 = n5; n3 <= n; ++n3) {
                    double[] dArray13 = dArray[n3];
                    int n17 = n5;
                    dArray13[n17] = dArray13[n17] * d6;
                }
            } else {
                for (n3 = n5; n3 <= n; ++n3) {
                    dArray[n3][n5] = 0.0;
                }
            }
            double[] dArray14 = dArray[n5];
            int n18 = n5--;
            dArray14[n18] = dArray14[n18] + 1.0;
        }
        block27: for (n4 = n2; n4 >= 1; --n4) {
            for (int i = 1; i <= 30; ++i) {
                double d7;
                double d8;
                double d9;
                boolean bl = true;
                for (n6 = n4; n6 >= 1; --n6) {
                    n7 = n6 - 1;
                    if (Math.abs(dArray4[n6]) + d4 == d4) {
                        bl = false;
                        break;
                    }
                    if (Math.abs(dArray2[n7]) + d4 == d4) break;
                }
                if (bl) {
                    d9 = 0.0;
                    d3 = 1.0;
                    for (n5 = n6; n5 <= n4; ++n5) {
                        d2 = d3 * dArray4[n5];
                        dArray4[n5] = d9 * dArray4[n5];
                        if (Math.abs(d2) + d4 == d4) break;
                        d6 = dArray2[n5];
                        dArray2[n5] = d = this.dpythag(d2, d6);
                        d = 1.0 / d;
                        d9 = d6 * d;
                        d3 = -d2 * d;
                        for (n3 = 1; n3 <= n; ++n3) {
                            d8 = dArray[n3][n7];
                            d7 = dArray[n3][n5];
                            dArray[n3][n7] = d8 * d9 + d7 * d3;
                            dArray[n3][n5] = d7 * d9 - d8 * d3;
                        }
                    }
                }
                d7 = dArray2[n4];
                if (n6 == n4) {
                    if (!(d7 < 0.0)) continue block27;
                    dArray2[n4] = -d7;
                    for (n3 = 1; n3 <= n2; ++n3) {
                        dArray3[n3][n4] = -dArray3[n3][n4];
                    }
                    continue block27;
                }
                if (i == 30) {
                    throw new SVD_Exception("no convergence in 30 dsvdcmp iterations");
                }
                double d10 = dArray2[n6];
                n7 = n4 - 1;
                d8 = dArray2[n7];
                d6 = dArray4[n7];
                d = dArray4[n4];
                d2 = ((d8 - d7) * (d8 + d7) + (d6 - d) * (d6 + d)) / (2.0 * d * d8);
                d6 = this.dpythag(d2, 1.0);
                d2 = ((d10 - d7) * (d10 + d7) + d * (d8 / (d2 + (d2 >= 0.0 ? d6 : -d6)) - d)) / d10;
                d3 = 1.0;
                d9 = 1.0;
                for (n3 = n6; n3 <= n7; ++n3) {
                    int n19;
                    n5 = n3 + 1;
                    d6 = dArray4[n5];
                    d8 = dArray2[n5];
                    d = d3 * d6;
                    d6 = d9 * d6;
                    dArray4[n3] = d7 = this.dpythag(d2, d);
                    d9 = d2 / d7;
                    d3 = d / d7;
                    d2 = d10 * d9 + d6 * d3;
                    d6 = d6 * d9 - d10 * d3;
                    d = d8 * d3;
                    d8 *= d9;
                    for (n19 = 1; n19 <= n2; ++n19) {
                        d10 = dArray3[n19][n3];
                        d7 = dArray3[n19][n5];
                        dArray3[n19][n3] = d10 * d9 + d7 * d3;
                        dArray3[n19][n5] = d7 * d9 - d10 * d3;
                    }
                    dArray2[n3] = d7 = this.dpythag(d2, d);
                    if (d7 != 0.0) {
                        d7 = 1.0 / d7;
                        d9 = d2 * d7;
                        d3 = d * d7;
                    }
                    d2 = d9 * d6 + d3 * d8;
                    d10 = d9 * d8 - d3 * d6;
                    for (n19 = 1; n19 <= n; ++n19) {
                        d8 = dArray[n19][n3];
                        d7 = dArray[n19][n5];
                        dArray[n19][n3] = d8 * d9 + d7 * d3;
                        dArray[n19][n5] = d7 * d9 - d8 * d3;
                    }
                }
                dArray4[n6] = 0.0;
                dArray4[n4] = d2;
                dArray2[n4] = d10;
            }
        }
    }

    protected double dpythag(double d, double d2) {
        double d3;
        double d4 = Math.abs(d);
        if (d4 > (d3 = Math.abs(d2))) {
            return d4 * Math.sqrt(1.0 + d3 / d4 * (d3 / d4));
        }
        return d3 == 0.0 ? 0.0 : d3 * Math.sqrt(1.0 + d4 / d3 * (d4 / d3));
    }

    public RealMatrix pseudoInv(double d) {
        int n;
        RealMatrix[] realMatrixArray = null;
        try {
            realMatrixArray = this.svd();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        double d2 = realMatrixArray[1].entry(0, 0);
        for (n = 0; n < realMatrixArray[1].rows() && n < realMatrixArray[1].columns(); ++n) {
            if (!(realMatrixArray[1].entry(n, n) > d2)) continue;
            d2 = realMatrixArray[1].entry(n, n);
        }
        for (n = 0; n < realMatrixArray[1].rows() && n < realMatrixArray[1].columns(); ++n) {
            double d3 = realMatrixArray[1].entry(n, n);
            realMatrixArray[1].setEntry(n, n, d3 > d2 / d ? 1.0 / d3 : 0.0);
        }
        return realMatrixArray[2].product(realMatrixArray[1].transpose()).product(realMatrixArray[0].transpose());
    }

    public RealMatrix pseudoInv() {
        return this.pseudoInv(1.0E12);
    }
}

