/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import numerics.Vector3D;

public final class Point3D {
    public final double x;
    public final double y;
    public final double z;

    public Point3D() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Point3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Point3D(Point3D point3D) {
        this.x = point3D.getX();
        this.y = point3D.getY();
        this.z = point3D.getZ();
    }

    public Point3D(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Point3D displaced(Vector3D vector3D) {
        return new Point3D(this.x + vector3D.x, this.y + vector3D.y, this.z + vector3D.z);
    }

    public double distance(Point3D point3D) {
        return Math.sqrt((this.x - point3D.x) * (this.x - point3D.x) + (this.y - point3D.y) * (this.y - point3D.y) + (this.z - point3D.z) * (this.z - point3D.z));
    }

    public String toString() {
        return "Point3D: (" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof Point3D)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        Point3D point3D = (Point3D)object;
        return point3D.x == this.x && point3D.y == this.y && point3D.z == this.z;
    }

    public int hashCode() {
        return (int)(17.0 * this.x + 23.0 * this.y + 31.0 * this.z);
    }
}

