/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import numerics.MTRandom;

public class GammaRandom {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final MTRandom rng;
    private final double k;
    private final double beta;
    private final int kFloor;
    private final double delta;

    public GammaRandom(long l, double d, double d2) {
        this.rng = new MTRandom(l);
        this.k = d;
        this.kFloor = (int)Math.floor(d);
        this.delta = d - (double)this.kFloor;
        this.beta = d2;
    }

    public double nextGamma() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.kFloor; ++i) {
            double d3 = this.getUniformNonZeroValue();
            d += -Math.log(d3);
        }
        if (this.delta > 0.0) {
            double d4 = Math.E / (Math.E + this.delta);
            boolean bl = false;
            while (!bl) {
                double d5;
                double d6 = this.getUniformNonZeroValue();
                double d7 = this.getUniformNonZeroValue();
                double d8 = this.getUniformNonZeroValue();
                if (d6 < d4) {
                    d2 = Math.pow(d7, 1.0 / this.delta);
                    d5 = d8 * Math.pow(d2, this.delta - 1.0);
                } else {
                    d2 = 1.0 - Math.log(d7);
                    d5 = d8 * Math.exp(-d2);
                }
                if (!(d5 > Math.pow(d2, this.delta - 1.0) * Math.exp(-d2))) continue;
                bl = true;
            }
        }
        double d9 = Math.max(0.0, d2 + d);
        return this.beta * d9;
    }

    private double getUniformNonZeroValue() {
        double d = 0.0;
        while (d == 0.0) {
            d = this.rng.nextDouble();
        }
        return d;
    }

    public static void main(String[] stringArray) {
        int n = 100000;
        int n2 = 1000;
        double[] dArray = new double[n2];
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        GammaRandom gammaRandom = new GammaRandom(34756037485L, 2.331206, 6.909243E-7);
        System.err.print("generating and binning " + n + " numbers... ");
        for (int i = 0; i < n; ++i) {
            double d3 = gammaRandom.nextGamma();
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        double d4 = (d2 - d) / (double)n2;
        for (int i = 0; i < n; ++i) {
            double d5 = gammaRandom.nextGamma();
            int n3 = Math.min((int)(d5 / d4), n2 - 1);
            if (n3 == -1) {
                System.err.println("i=" + i + " bin is -1. that shouldn't happen...");
            }
            int n4 = n3;
            dArray[n4] = dArray[n4] + 1.0;
        }
        System.err.println("done");
        System.err.print("outputting distributiion... ");
        try {
            FileWriter fileWriter = new FileWriter("gammaDist.csv");
            for (int i = 0; i < n2; ++i) {
                fileWriter.write((double)i * d4 + "," + dArray[i] + "\n");
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        System.err.println("done");
    }
}

